/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Filenames {
    public static List<String> disectFilename(String filename) {
        char sep = File.separatorChar;
        ArrayList<String> res = new ArrayList<String>();
        if (filename.indexOf("/") != -1) {
            assert (sep == '/') : "\"" + filename + "\" contains both / and \\";
        } else if (filename.indexOf("\\") != -1) {
            assert (sep == '\\') : "\"" + filename + "\" contains both / and \\";
        } else {
            res.add(filename);
            return res;
        }
        int i = 0;
        while (i < filename.length()) {
            String s;
            int j = filename.indexOf(sep, i);
            if (j == -1) {
                s = filename.substring(i, filename.length());
                if (s.equals(".")) break;
                res.add(s);
                break;
            }
            if (i == j) {
                if (i == 0) {
                    res.add("");
                }
            } else {
                s = filename.substring(i, j);
                if (!s.equals(".")) {
                    res.add(s);
                }
            }
            i = j + 1;
        }
        return res;
    }

    public static String makeFilenameRelative(String origFilename, String toFilename) {
        int i;
        List<String> origFileNameSections = Filenames.disectFilename(origFilename);
        String[] a = origFileNameSections.toArray(new String[origFileNameSections.size()]);
        List<String> destinationFilenameSections = Filenames.disectFilename(toFilename);
        String[] b = destinationFilenameSections.toArray(new String[destinationFilenameSections.size()]);
        if (File.separatorChar == '\\' && a[0].length() == 2 && a[0].charAt(1) == ':') {
            char drive = Character.toUpperCase(a[0].charAt(0));
            if (b[0].length() != 2 || Character.toUpperCase(b[0].charAt(0)) != drive || b[0].charAt(1) != ':') {
                throw new RuntimeException("cannot make paths on different drives relative");
            }
            a[0] = "";
            b[0] = "";
        }
        Object s = "";
        Object t = "";
        if (a[0].equals("")) {
            if (!b[0].equals("")) {
                throw new RuntimeException("\"" + toFilename + "\" is a relative path. Please use absolute paths to make others relative to them.");
            }
            a = Filenames.removeDotDot(a);
            b = Filenames.removeDotDot(b);
            boolean diff = false;
            for (i = 1; i < b.length; ++i) {
                if (i >= a.length || !a[i].equals(b[i])) {
                    diff = true;
                }
                if (!diff) continue;
                s = (String)s + "../";
                if (i >= a.length) continue;
                t = (String)t + (a[i].equals("") ? "" : "/") + a[i];
            }
        } else {
            i = 0;
        }
        while (i < a.length) {
            t = (String)t + (a[i].equals("") ? "" : "/") + a[i++];
        }
        if (((String)t).length() > 0 && ((String)t).charAt(0) == '/') {
            t = ((String)t).substring(1);
        }
        if (((String)(t = (String)s + (String)t)).length() > 0 && ((String)t).charAt(((String)t).length() - 1) == '/') {
            t = ((String)t).substring(0, ((String)t).length() - 1);
        }
        return t;
    }

    private static String[] removeDotDot(String[] a) {
        String[] newa = new String[a.length];
        int k = 0;
        for (int j = 0; j < a.length - 1; ++j) {
            if (a[j].equals("..") || !a[j + 1].equals("..")) {
                newa[k++] = a[j];
                continue;
            }
            ++j;
        }
        if (!a[a.length - 1].equals("..")) {
            newa[k++] = a[a.length - 1];
        }
        return Arrays.copyOf(newa, k);
    }

    public static String toValidFileName(String s) {
        s = s.replace("\\", "_").replace("$", "_").replace("?", "_").replace("|", "_").replace("<", "_").replace(">", "_").replace(":", "_").replace("*", "+").replace("\"", "'").replace("/", "-").replace("[", "(").replace("]", ")");
        return s;
    }
}

