/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.bitops;

import java.util.ArrayList;

public class ImmutableFixedLengthBitSet {
    private boolean[] bitSet = null;
    private int value = -1;

    public ImmutableFixedLengthBitSet(int length) {
        this.bitSet = new boolean[length];
        this.value = 0;
    }

    private ImmutableFixedLengthBitSet(boolean[] bitSet, int value) {
        this.bitSet = bitSet;
        this.value = value;
    }

    public int getValue() {
        if (this.value > -1) {
            return this.value;
        }
        int result = 0;
        for (int i = 0; i < this.bitSet.length; ++i) {
            if (!this.bitSet[i]) continue;
            result |= ImmutableFixedLengthBitSet.intPow(2, i);
        }
        return result;
    }

    public ImmutableFixedLengthBitSet setToValue(int value) {
        assert (value < ImmutableFixedLengthBitSet.intPow(2, this.bitSet.length)) : "Value to high for this bit set.";
        assert (value > -1) : "Only non-negative values are allowed.";
        boolean[] newBitSet = new boolean[this.bitSet.length];
        for (int i = 0; i < newBitSet.length; ++i) {
            int bit = ImmutableFixedLengthBitSet.intPow(2, i);
            newBitSet[i] = (value & bit) != 0;
        }
        return new ImmutableFixedLengthBitSet(newBitSet, value);
    }

    public ImmutableFixedLengthBitSet inc() {
        return this.setToValue(this.getValue() + 1);
    }

    public int getNumOfZeroBits() {
        int result = 0;
        for (int i = 0; i < this.bitSet.length; ++i) {
            if (this.bitSet[i]) continue;
            ++result;
        }
        return result;
    }

    public ArrayList<Integer> getNonzeroPositions() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this.bitSet.length; ++i) {
            if (!this.bitSet[i]) continue;
            result.add(i);
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getValue()).append(" [");
        for (boolean bit : this.bitSet) {
            result.append(bit ? "1" : Integer.valueOf(0));
            result.append(",");
        }
        result.deleteCharAt(result.length() - 1);
        result.append("]");
        return result.toString();
    }

    private static int intPow(int a, int b) {
        return (int)Math.round(Math.pow(a, b));
    }
}

