/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.collection;

import java.util.Iterator;
import org.key_project.util.collection.ImmutableMap;
import org.key_project.util.collection.ImmutableMapEntry;
import org.key_project.util.collection.ImmutableSLList;

public class DefaultImmutableMap<S, T>
implements ImmutableMap<S, T> {
    private static final long serialVersionUID = 3268346732418187405L;
    private final DefaultImmutableMap<S, T> parent;
    private final ImmutableMapEntry<S, T> entry;
    private final int size;

    public static <S, T> DefaultImmutableMap<S, T> nilMap() {
        return NILMap.EMPTY_MAP;
    }

    protected DefaultImmutableMap() {
        this.entry = null;
        this.parent = null;
        this.size = 0;
    }

    protected DefaultImmutableMap(ImmutableMapEntry<S, T> entry) {
        if (entry == null) {
            throw new RuntimeException("'null' is not allowed as entry");
        }
        this.entry = entry;
        this.parent = DefaultImmutableMap.nilMap();
        this.size = 1;
    }

    protected DefaultImmutableMap(ImmutableMapEntry<S, T> entry, DefaultImmutableMap<S, T> parent) {
        if (entry == null) {
            throw new IllegalArgumentException("'null' is not allowed as entry");
        }
        this.entry = entry;
        this.parent = parent;
        this.size = parent.size + 1;
    }

    @Override
    public ImmutableMap<S, T> put(S key, T value) {
        return new DefaultImmutableMap<S, T>(new MapEntry<S, T>(key, value), this.remove((Object)key));
    }

    @Override
    public T get(S key) {
        DefaultImmutableMap<S, T> queue = this;
        while (!queue.isEmpty()) {
            ImmutableMapEntry<S, T> e = queue.entry;
            S entryKey = e.key();
            if (entryKey == key || entryKey.equals(key)) {
                return e.value();
            }
            queue = queue.parent;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(S key) {
        DefaultImmutableMap<S, T> queue = this;
        while (!queue.isEmpty()) {
            ImmutableMapEntry<S, T> e = queue.entry;
            S entryKey = e.key();
            if (entryKey == key || entryKey.equals(key)) {
                return true;
            }
            queue = queue.parent;
        }
        return false;
    }

    @Override
    public boolean containsValue(T value) {
        DefaultImmutableMap<S, T> queue = this;
        while (!queue.isEmpty()) {
            ImmutableMapEntry<S, T> e = queue.entry;
            T entryVal = e.value();
            if (entryVal == value || entryVal.equals(value)) {
                return true;
            }
            queue = queue.parent;
        }
        return false;
    }

    private DefaultImmutableMap<S, T> createMap(ImmutableMapEntry<S, T>[] stack, int counter, DefaultImmutableMap<S, T> p_parent) {
        DefaultImmutableMap<S, T> result = p_parent;
        for (int i = 0; i < counter; ++i) {
            result = new DefaultImmutableMap<S, T>(stack[i], result);
        }
        return result;
    }

    @Override
    public DefaultImmutableMap<S, T> remove(S key) {
        DefaultImmutableMap<S, T> queue = this;
        ImmutableMapEntry[] stack = new ImmutableMapEntry[this.size()];
        int counter = 0;
        while (!queue.isEmpty()) {
            ImmutableMapEntry<S, T> e = queue.entry;
            S entryKey = e.key();
            if (entryKey == key || entryKey.equals(key)) {
                return this.createMap(stack, counter, queue.parent);
            }
            stack[counter] = e;
            ++counter;
            queue = queue.parent;
        }
        return this;
    }

    @Override
    public ImmutableMap<S, T> removeAll(T value) {
        DefaultImmutableMap<S, T> queue = this;
        ImmutableMapEntry[] stack = new ImmutableMapEntry[this.size()];
        int counter = 0;
        while (!queue.isEmpty()) {
            ImmutableMapEntry<S, T> e = queue.entry;
            T entryVal = e.value();
            if (entryVal != value && !entryVal.equals(value)) {
                stack[counter] = e;
                ++counter;
            }
            queue = queue.parent;
        }
        return counter < stack.length ? this.createMap(stack, counter, DefaultImmutableMap.nilMap()) : this;
    }

    @Override
    public Iterator<S> keyIterator() {
        return new MapKeyIterator(this);
    }

    @Override
    public Iterator<T> valueIterator() {
        return new MapValueIterator(this);
    }

    @Override
    public Iterator<ImmutableMapEntry<S, T>> iterator() {
        return new MapEntryIterator(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        Iterator<ImmutableMapEntry<S, T>> it = this.iterator();
        while (it.hasNext()) {
            sb.append("" + it.next());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImmutableMap)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ImmutableMap o1 = null;
        try {
            o1 = (ImmutableMap)o;
            if (o1.size() != this.size()) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            return false;
        }
        for (ImmutableMapEntry<S, T> e : this) {
            if (e.value().equals(o1.get(e.key()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator<ImmutableMapEntry<S, T>> p = this.iterator();
        while (p.hasNext()) {
            hashCode += 7 * p.next().hashCode();
        }
        return hashCode;
    }

    private static final class MapKeyIterator<S, T>
    extends MapIterator<S, T>
    implements Iterator<S> {
        MapKeyIterator(DefaultImmutableMap<S, T> map) {
            super(map);
        }

        @Override
        public S next() {
            return this.nextEntry().key();
        }
    }

    private static final class MapValueIterator<S, T>
    extends MapIterator<S, T>
    implements Iterator<T> {
        MapValueIterator(DefaultImmutableMap<S, T> map) {
            super(map);
        }

        @Override
        public final T next() {
            return this.nextEntry().value();
        }
    }

    private static final class MapEntryIterator<S, T>
    extends MapIterator<S, T>
    implements Iterator<ImmutableMapEntry<S, T>> {
        MapEntryIterator(DefaultImmutableMap<S, T> map) {
            super(map);
        }

        @Override
        public final ImmutableMapEntry<S, T> next() {
            return this.nextEntry();
        }
    }

    private static abstract class MapIterator<S, T> {
        private DefaultImmutableMap<S, T> map;

        MapIterator(DefaultImmutableMap<S, T> map) {
            this.map = map;
        }

        public boolean hasNext() {
            return !this.map.isEmpty();
        }

        protected final ImmutableMapEntry<S, T> nextEntry() {
            ImmutableMapEntry entry = this.map.entry;
            this.map = this.map.parent;
            return entry;
        }

        public void remove() {
            throw new UnsupportedOperationException("Removing elements via an iterator is not supported for immutable maps.");
        }
    }

    private static class MapEntry<S, T>
    implements ImmutableMapEntry<S, T> {
        private static final long serialVersionUID = -6785625761293313622L;
        private final S key;
        private final T value;

        MapEntry(S key, T value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public S key() {
            return this.key;
        }

        @Override
        public T value() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ImmutableMapEntry)) {
                return false;
            }
            ImmutableMapEntry cmp = (ImmutableMapEntry)obj;
            Object cmpKey = cmp.key();
            Object cmpVal = cmp.value();
            return this.key == cmpKey && this.value == cmpVal || this.key.equals(cmpKey) && this.value.equals(cmpVal);
        }

        public int hashCode() {
            return this.key.hashCode() * 7 + this.value.hashCode();
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }

    private static class NILMap<S, T>
    extends DefaultImmutableMap<S, T> {
        static final NILMap<?, ?> EMPTY_MAP = new NILMap();
        private static final long serialVersionUID = 412820308341055305L;

        private NILMap() {
        }

        @Override
        public ImmutableMap<S, T> put(S key, T value) {
            return new DefaultImmutableMap<S, T>(new MapEntry<S, T>(key, value));
        }

        @Override
        public T get(S key) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(S key) {
            return false;
        }

        @Override
        public boolean containsValue(T val) {
            return false;
        }

        @Override
        public DefaultImmutableMap<S, T> remove(S key) {
            return this;
        }

        @Override
        public ImmutableMap<S, T> removeAll(T value) {
            return this;
        }

        @Override
        public Iterator<S> keyIterator() {
            return ImmutableSLList.nil().iterator();
        }

        @Override
        public Iterator<T> valueIterator() {
            return ImmutableSLList.nil().iterator();
        }

        @Override
        public Iterator<ImmutableMapEntry<S, T>> iterator() {
            return ImmutableSLList.nil().iterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public String toString() {
            return "[(,)]";
        }
    }
}

