/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.collection;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.collection.ImmutableSet;
import org.key_project.util.collection.Immutables;
import org.key_project.util.collection.NotUniqueException;

public class DefaultImmutableSet<T>
implements ImmutableSet<T> {
    private static final long serialVersionUID = -5000602574000532257L;
    public static final int UNION_OPTIMIZATION_SIZE = 100;
    private final ImmutableList<T> elementList;

    public static final <T> DefaultImmutableSet<T> nil() {
        return NILSet.NIL;
    }

    protected DefaultImmutableSet() {
        this.elementList = ImmutableSLList.nil();
    }

    protected DefaultImmutableSet(T element) {
        this.elementList = ImmutableSLList.nil().prepend(element);
    }

    private DefaultImmutableSet(ImmutableList<T> elementList) {
        this.elementList = elementList;
    }

    private void complainAboutSize() {
    }

    @Override
    public ImmutableSet<T> add(T element) {
        this.complainAboutSize();
        if (this.elementList.contains(element)) {
            return this;
        }
        return new DefaultImmutableSet<T>(this.elementList.prepend(element));
    }

    @Override
    public ImmutableSet<T> addUnique(T element) throws NotUniqueException {
        this.complainAboutSize();
        if (this.elementList.contains(element)) {
            throw new NotUniqueException(element);
        }
        return new DefaultImmutableSet<T>(this.elementList.prepend(element));
    }

    @Override
    public ImmutableSet<T> union(ImmutableSet<? extends T> set) {
        if (set instanceof DefaultImmutableSet && this.size() * set.size() > 100) {
            return this.newUnion((DefaultImmutableSet)set);
        }
        return this.originalUnion(set);
    }

    private DefaultImmutableSet<T> newUnion(DefaultImmutableSet<? extends T> set) {
        ImmutableList<T> otherList = set.elementList;
        ImmutableList<T> clean = Immutables.concatDuplicateFreeLists(this.elementList, otherList);
        return new DefaultImmutableSet<T>(clean);
    }

    private DefaultImmutableSet<T> originalUnion(ImmutableSet<? extends T> set) {
        if (set.isEmpty()) {
            return this;
        }
        ImmutableList<T> unionElements = this.elementList;
        for (T otherEl : set) {
            if (this.contains(otherEl)) continue;
            unionElements = unionElements.prepend(otherEl);
        }
        return new DefaultImmutableSet<T>(unionElements);
    }

    @Override
    public ImmutableSet<T> intersect(ImmutableSet<? extends T> set) {
        this.complainAboutSize();
        if (set.isEmpty()) {
            return set;
        }
        ImmutableList<T> intersectElements = ImmutableSLList.nil();
        for (T el : set) {
            if (!this.contains(el)) continue;
            intersectElements = intersectElements.prepend(el);
        }
        if (intersectElements.isEmpty()) {
            return DefaultImmutableSet.nil();
        }
        return new DefaultImmutableSet(intersectElements);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elementList.iterator();
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public boolean contains(T obj) {
        this.complainAboutSize();
        return this.elementList.contains(obj);
    }

    @Override
    public boolean subset(ImmutableSet<T> s) {
        if (this.size() > s.size()) {
            return false;
        }
        for (T el : this) {
            if (s.contains(el)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean exists(Predicate<T> predicate) {
        return this.elementList.exists(predicate);
    }

    @Override
    public int size() {
        return this.elementList.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public ImmutableSet<T> remove(T element) {
        ImmutableList<T> list = this.elementList.removeFirst(element);
        return list.isEmpty() ? DefaultImmutableSet.nil() : new DefaultImmutableSet<T>(list);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ImmutableSet)) {
            return false;
        }
        ImmutableSet o = (ImmutableSet)obj;
        return o.subset(this) && this.subset(o);
    }

    @Override
    public <S> S[] toArray(S[] array) {
        return this.elementList.toArray(array);
    }

    @Override
    public Set<T> toSet() {
        HashSet result = new HashSet();
        this.elementList.forEach(el -> result.add(el));
        return result;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        ImmutableList<T> crt = this.elementList;
        while (!crt.isEmpty()) {
            T element = crt.head();
            hashCode = (element == null ? 0 : element.hashCode()) + hashCode;
            crt = crt.tail();
        }
        return hashCode;
    }

    public ImmutableList<T> toImmutableList() {
        return this.elementList;
    }

    public static <T> ImmutableSet<T> fromImmutableList(ImmutableList<T> list) {
        if (list.isEmpty()) {
            return DefaultImmutableSet.nil();
        }
        return new DefaultImmutableSet<T>(Immutables.removeDuplicates(list));
    }

    public static <T> ImmutableSet<T> fromSet(@Nullable Set<T> set) {
        if (set == null) {
            return null;
        }
        if (set.isEmpty()) {
            return DefaultImmutableSet.nil();
        }
        ImmutableList<T> backerList = ImmutableSLList.nil();
        for (T element : set) {
            backerList = backerList.prepend(element);
        }
        return new DefaultImmutableSet(backerList);
    }

    public static <T> ImmutableSet<T> fromCollection(@Nullable Collection<T> seq) {
        if (seq == null) {
            return null;
        }
        return DefaultImmutableSet.fromSet(new HashSet<T>(seq));
    }

    public String toString() {
        Iterator<T> it = this.iterator();
        StringBuffer str = new StringBuffer("{");
        while (it.hasNext()) {
            str.append(it.next());
            if (!it.hasNext()) continue;
            str.append(",");
        }
        str.append("}");
        return str.toString();
    }

    private static class NILSet<T>
    extends DefaultImmutableSet<T> {
        private static final long serialVersionUID = -8055357307337694419L;
        static final NILSet<?> NIL = new NILSet();

        private NILSet() {
        }

        private Object readResolve() throws ObjectStreamException {
            return NIL;
        }

        @Override
        public ImmutableSet<T> add(T element) {
            return new DefaultImmutableSet<T>(element);
        }

        @Override
        public ImmutableSet<T> addUnique(T element) {
            return new DefaultImmutableSet<T>(element);
        }

        @Override
        public ImmutableSet<T> union(ImmutableSet<? extends T> set) {
            return set;
        }

        @Override
        public boolean contains(T obj) {
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return ImmutableSLList.nil().iterator();
        }

        @Override
        public boolean subset(ImmutableSet<T> s) {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof NILSet;
        }

        @Override
        public int hashCode() {
            return 23456;
        }

        @Override
        public String toString() {
            return "{}";
        }

        @Override
        public ImmutableSet<T> remove(T element) {
            return this;
        }

        @Override
        public <S> S[] toArray(S[] array) {
            return array;
        }
    }
}

