/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;

public class ImmutableArray<S>
implements Iterable<S>,
Serializable {
    private static final long serialVersionUID = -9041545065066866250L;
    private final S[] content;

    public ImmutableArray() {
        this.content = new Object[0];
    }

    public ImmutableArray(S ... arr) {
        this.content = (Object[])Array.newInstance(arr.getClass().getComponentType(), arr.length);
        System.arraycopy(arr, 0, this.content, 0, arr.length);
    }

    public ImmutableArray(@Nonnull Collection<? extends S> list) {
        this.content = list.toArray();
    }

    public final S get(int pos) {
        return this.content[pos];
    }

    public final S last() {
        return this.content[this.content.length - 1];
    }

    public int size() {
        return this.content.length;
    }

    public void arraycopy(int srcIdx, Object dest, int destIndex, int length) {
        System.arraycopy(this.content, srcIdx, dest, destIndex, length);
    }

    public final boolean isEmpty() {
        return this.content.length == 0;
    }

    public boolean contains(S op) {
        for (S el : this.content) {
            if (!el.equals(op)) continue;
            return true;
        }
        return false;
    }

    public <T> T[] toArray(T[] array) {
        Object[] result = array.length < this.size() ? (Object[])Array.newInstance(array.getClass().getComponentType(), this.content.length) : array;
        System.arraycopy(this.content, 0, result, 0, this.content.length);
        return result;
    }

    public int hashCode() {
        return Arrays.hashCode(this.content);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        S[] cmp = null;
        if (!(o instanceof ImmutableArray)) {
            return false;
        }
        cmp = ((ImmutableArray)o).content;
        if (cmp.length != this.content.length) {
            return false;
        }
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i].equals(cmp[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            sb.append(this.content[i]);
            if (i >= sz - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Iterator<S> iterator() {
        return new ArrayIterator(this);
    }

    public ImmutableList<S> toImmutableList() {
        ImmutableList<S> ret = ImmutableSLList.nil();
        Iterator<S> it = this.iterator();
        while (it.hasNext()) {
            ret = ret.prepend(it.next());
        }
        return ret.reverse();
    }

    public List<S> toList() {
        ArrayList<S> result = new ArrayList<S>();
        Iterator<S> it = this.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public Stream<S> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    private static class ArrayIterator<T>
    implements Iterator<T> {
        private int i = 0;
        private final ImmutableArray<T> coll;

        ArrayIterator(ImmutableArray<T> coll) {
            this.coll = coll;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.coll.size();
        }

        @Override
        public T next() {
            return this.coll.get(this.i++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Illegal modification access on unmodifiable array.");
        }
    }
}

