/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.collection;

import java.util.Iterator;
import java.util.Stack;
import org.key_project.util.collection.ImmutableHeap;

public abstract class ImmutableLeftistHeap<T extends Comparable<T>>
implements ImmutableHeap<T> {
    private static final long serialVersionUID = -4035441830559680469L;

    public static <T extends Comparable<T>> ImmutableLeftistHeap<T> nilHeap() {
        return Empty.EMPTY_HEAP;
    }

    protected abstract int getRightHeight();

    @Override
    public ImmutableHeap<T> insert(Iterator<T> elements) {
        Stack<ImmutableLeftistHeap> s = new Stack<ImmutableLeftistHeap>();
        s.push(this);
        while (elements.hasNext()) {
            ImmutableHeap h = new Node<Comparable>((Comparable)elements.next());
            do {
                ImmutableHeap top = (ImmutableHeap)s.peek();
                if (h.size() < top.size()) break;
                h = h.insert(top);
                s.pop();
            } while (!s.isEmpty());
            s.push((ImmutableLeftistHeap)h);
        }
        ImmutableHeap res = (ImmutableHeap)s.pop();
        while (!s.isEmpty()) {
            res = res.insert((ImmutableHeap)s.pop());
        }
        return res;
    }

    @Override
    public Iterator<T> iterator() {
        return new UnsortedIterator(this);
    }

    @Override
    public Iterator<T> sortedIterator() {
        return new SortedIterator(this);
    }

    public String toString() {
        Iterator<T> it = this.iterator();
        StringBuffer str = new StringBuffer("[");
        while (it.hasNext()) {
            str.append(it.next());
            if (!it.hasNext()) continue;
            str.append(",");
        }
        str.append("]");
        return str.toString();
    }

    private static class SortedIterator<T extends Comparable<T>>
    implements Iterator<T> {
        private ImmutableHeap<T> remainder;

        public SortedIterator(ImmutableHeap<T> heap) {
            this.remainder = heap;
        }

        @Override
        public boolean hasNext() {
            return !this.remainder.isEmpty();
        }

        @Override
        public T next() {
            assert (!this.remainder.isEmpty()) : "Missing next element in SortedIterator.next()";
            T data = this.remainder.findMin();
            this.remainder = this.remainder.deleteMin();
            return data;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnsortedIterator<T extends Comparable<T>>
    implements Iterator<T> {
        private final Stack<Node<T>> remainder = new Stack();

        public UnsortedIterator(ImmutableLeftistHeap<T> heap) {
            this.push(heap);
        }

        private void push(ImmutableLeftistHeap<T> heap) {
            if (!heap.isEmpty()) {
                this.remainder.push((Node)heap);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.remainder.isEmpty();
        }

        @Override
        public T next() {
            assert (!this.remainder.isEmpty()) : "Missing next element in UnsortedIterator.next()";
            Node<T> heap = this.remainder.pop();
            this.push(heap.left);
            this.push(heap.right);
            return (T)heap.data;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Empty<S extends Comparable<S>>
    extends ImmutableLeftistHeap<S> {
        private static final long serialVersionUID = -2471143956420721016L;
        private static final ImmutableLeftistHeap<?> EMPTY_HEAP = new Empty();

        private Empty() {
        }

        @Override
        protected int getRightHeight() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public ImmutableHeap<S> insert(S element) {
            return new Node<S>(element);
        }

        @Override
        public ImmutableHeap<S> insert(ImmutableHeap<S> h) {
            return h;
        }

        @Override
        public S findMin() {
            return null;
        }

        @Override
        public ImmutableHeap<S> deleteMin() {
            return this;
        }

        @Override
        public ImmutableHeap<S> removeAll(S element) {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    private static class Node<S extends Comparable<S>>
    extends ImmutableLeftistHeap<S> {
        private static final long serialVersionUID = 4913355498617409303L;
        private final int rightHeight;
        private final int size;
        private final S data;
        private final ImmutableLeftistHeap<S> left;
        private final ImmutableLeftistHeap<S> right;

        public Node(S element) {
            this.rightHeight = 1;
            this.size = 1;
            this.data = element;
            this.left = ImmutableLeftistHeap.nilHeap();
            this.right = ImmutableLeftistHeap.nilHeap();
        }

        public Node(S element, ImmutableLeftistHeap<S> a) {
            this.rightHeight = 1;
            this.size = 1 + a.size();
            this.data = element;
            this.left = a;
            this.right = ImmutableLeftistHeap.nilHeap();
        }

        private Node(S element, ImmutableLeftistHeap<S> a, ImmutableLeftistHeap<S> b) {
            this.data = element;
            this.size = 1 + a.size() + b.size();
            if (a.getRightHeight() <= b.getRightHeight()) {
                this.rightHeight = a.getRightHeight() + 1;
                this.left = b;
                this.right = a;
            } else {
                this.rightHeight = b.getRightHeight() + 1;
                this.left = a;
                this.right = b;
            }
        }

        @Override
        protected int getRightHeight() {
            return this.rightHeight;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public ImmutableHeap<S> insert(S element) {
            if (element.compareTo(this.data) <= 0) {
                return new Node<S>(element, this);
            }
            return new Node<S>(this.data, this.left, (ImmutableLeftistHeap)this.right.insert(element));
        }

        @Override
        public ImmutableHeap<S> insert(ImmutableHeap<S> h) {
            if (h.isEmpty()) {
                return this;
            }
            if (h instanceof Node) {
                Node other = (Node)h;
                if (this.data.compareTo(other.data) <= 0) {
                    return new Node<S>(this.data, this.left, (ImmutableLeftistHeap)this.right.insert(other));
                }
                return new Node<S>(other.data, other.left, (ImmutableLeftistHeap)this.insert((ImmutableHeap<S>)other.right));
            }
            return this.insert((S)h.iterator());
        }

        @Override
        public S findMin() {
            return this.data;
        }

        @Override
        public ImmutableHeap<S> deleteMin() {
            return this.left.insert((ImmutableHeap<S>)this.right);
        }

        @Override
        public ImmutableHeap<S> removeAll(S element) {
            int c = this.data.compareTo(element);
            if (c > 0) {
                return this;
            }
            ImmutableLeftistHeap newLeft = (ImmutableLeftistHeap)this.left.removeAll(element);
            ImmutableLeftistHeap newRight = (ImmutableLeftistHeap)this.right.removeAll(element);
            if (c == 0 && this.data.equals(element)) {
                return newLeft.insert(newRight);
            }
            if (this.left == newLeft && this.right == newRight) {
                return this;
            }
            return new Node<S>(this.data, newLeft, newRight);
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

