/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.key_project.util.collection.ImmutableSLList;

public interface ImmutableList<T>
extends Iterable<T>,
Serializable {
    public static <T> Collector<T, List<T>, ImmutableList<T>> collector() {
        return Collector.of(LinkedList::new, (list, el) -> list.add(el), (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }, ImmutableList::fromList, new Collector.Characteristics[0]);
    }

    public static <T> ImmutableList<T> fromList(Collection<T> list) {
        ImmutableList<T> result = ImmutableSLList.nil();
        for (T el : list) {
            result = result.append(el);
        }
        return result;
    }

    public ImmutableList<T> prepend(T var1);

    public ImmutableList<T> prepend(ImmutableList<T> var1);

    public ImmutableList<T> prependReverse(ImmutableList<T> var1);

    public ImmutableList<T> prependReverse(Iterable<T> var1);

    public ImmutableList<T> prepend(T ... var1);

    public ImmutableList<T> append(T var1);

    public ImmutableList<T> append(ImmutableList<T> var1);

    public ImmutableList<T> append(Iterable<T> var1);

    public ImmutableList<T> append(T ... var1);

    public T head();

    public boolean exists(Predicate<T> var1);

    public ImmutableList<T> tail();

    public ImmutableList<T> take(int var1);

    public ImmutableList<T> reverse();

    @Override
    public Iterator<T> iterator();

    public boolean contains(T var1);

    public int size();

    public boolean isEmpty();

    public ImmutableList<T> removeFirst(T var1);

    public ImmutableList<T> removeAll(T var1);

    public <S> S[] toArray(S[] var1);

    public <S> S[] toArray(Class<S> var1);

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public List<T> toList() {
        ArrayList<T> result = new ArrayList<T>();
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }
}

