/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.collection;

import java.io.ObjectStreamException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.key_project.util.collection.ImmutableList;

public abstract class ImmutableSLList<T>
implements ImmutableList<T> {
    private static final long serialVersionUID = 8717813038177120287L;

    public static <T> ImmutableSLList<T> nil() {
        return (ImmutableSLList)NIL.NIL;
    }

    public static <T> ImmutableSLList<T> singleton(T obj) {
        return new Cons<T>(obj, ImmutableSLList.nil());
    }

    @Override
    public ImmutableList<T> reverse() {
        if (this.size() <= 1) {
            return this;
        }
        ImmutableList<T> rest = this;
        ImmutableList rev = ImmutableSLList.nil();
        while (!rest.isEmpty()) {
            rev = rev.prepend(rest.head());
            rest = rest.tail();
        }
        return rev;
    }

    @Override
    public <S> S[] toArray(S[] array) {
        Object[] result = array.length < this.size() ? (Object[])Array.newInstance(array.getClass().getComponentType(), this.size()) : array;
        ImmutableList<T> rest = this;
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            result[i] = rest.head();
            rest = rest.tail();
        }
        return result;
    }

    @Override
    public <S> S[] toArray(Class<S> type) {
        Object[] result = (Object[])Array.newInstance(type, this.size());
        ImmutableList<T> rest = this;
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            result[i] = rest.head();
            rest = rest.tail();
        }
        return result;
    }

    @Override
    public ImmutableList<T> prepend(T ... array) {
        return this.prepend(array, array.length);
    }

    protected ImmutableList<T> prepend(T[] array, int n) {
        Cons<T> res = this;
        while (n-- != 0) {
            res = new Cons<T>(array[n], res);
        }
        return res;
    }

    @Override
    public ImmutableList<T> append(Iterable<T> collection) {
        ImmutableList<T> tmp = this;
        for (T elem : collection) {
            tmp = tmp.append(elem);
        }
        return tmp;
    }

    @Override
    public ImmutableList<T> prependReverse(Iterable<T> collection) {
        Cons<T> tmp = this;
        for (T elem : collection) {
            tmp = new Cons<T>(elem, tmp);
        }
        return tmp;
    }

    @Override
    public ImmutableList<T> take(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("Unable to take " + n + " elements from list " + this);
        }
        ImmutableList<T> rest = this;
        while (n-- != 0) {
            rest = rest.tail();
        }
        return rest;
    }

    public static <T> Collector<T, List<T>, ImmutableList<T>> toImmutableList() {
        return new ImmutableListCollector();
    }

    static class ImmutableListCollector<T>
    implements Collector<T, List<T>, ImmutableList<T>> {
        ImmutableListCollector() {
        }

        @Override
        public Supplier<List<T>> supplier() {
            return () -> new ArrayList();
        }

        @Override
        public BiConsumer<List<T>, T> accumulator() {
            return (list, entry) -> list.add(entry);
        }

        @Override
        public BinaryOperator<List<T>> combiner() {
            return (l1, l2) -> {
                l1.addAll(l2);
                return l1;
            };
        }

        @Override
        public Function<List<T>, ImmutableList<T>> finisher() {
            return list -> ImmutableSLList.nil().append(list);
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            HashSet<Collector.Characteristics> result = new HashSet<Collector.Characteristics>();
            return result;
        }
    }

    private static class NIL<S>
    extends ImmutableSLList<S> {
        static final ImmutableList<?> NIL = new NIL();
        private static final long serialVersionUID = -4070450212306526804L;
        private final transient Iterator<S> iterator = new SLNilListIterator();

        private NIL() {
        }

        private Object readResolve() throws ObjectStreamException {
            return org.key_project.util.collection.ImmutableSLList$NIL.nil();
        }

        @Override
        public int size() {
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof NIL;
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public ImmutableList<S> prepend(S element) {
            return new Cons<S>(element);
        }

        @Override
        public ImmutableList<S> prepend(ImmutableList<S> list) {
            return list;
        }

        @Override
        public ImmutableList<S> prependReverse(ImmutableList<S> list) {
            return list.reverse();
        }

        @Override
        public ImmutableList<S> append(S element) {
            return new Cons<S>(element);
        }

        @Override
        public ImmutableList<S> append(ImmutableList<S> list) {
            return list;
        }

        @Override
        public ImmutableList<S> append(S ... array) {
            return this.prepend((S)array);
        }

        @Override
        public boolean contains(S obj) {
            return false;
        }

        @Override
        public boolean exists(Predicate<S> predicate) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<S> iterator() {
            return this.iterator;
        }

        @Override
        public S head() {
            return null;
        }

        @Override
        public ImmutableList<S> tail() {
            return this;
        }

        @Override
        public ImmutableList<S> removeAll(S obj) {
            return this;
        }

        @Override
        public ImmutableList<S> removeFirst(S obj) {
            return this;
        }

        public String toString() {
            return "[]";
        }

        private class SLNilListIterator
        implements Iterator<S> {
            @Override
            public S next() {
                return null;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing elements via an iterator is not supported for immutable datastructures.");
            }
        }
    }

    private static class SLListIterator<T>
    implements Iterator<T> {
        private ImmutableList<T> list;

        public SLListIterator(ImmutableList<T> list) {
            this.list = list;
        }

        @Override
        public T next() {
            T element = this.list.head();
            this.list = this.list.tail();
            return element;
        }

        @Override
        public boolean hasNext() {
            return !this.list.isEmpty();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing elements via an iterator is not supported for immutable datastructures.");
        }
    }

    private static class Cons<S>
    extends ImmutableSLList<S> {
        private static final long serialVersionUID = 2377644880764534935L;
        private final S element;
        private final ImmutableSLList<S> cons;
        private final int size;

        Cons(S element) {
            this.element = element;
            this.cons = Cons.nil();
            this.size = 1;
        }

        Cons(S element, ImmutableSLList<S> cons) {
            this.element = element;
            this.cons = cons;
            this.size = cons.size() + 1;
        }

        @Override
        public ImmutableList<S> prepend(S e) {
            return new Cons<S>(e, this);
        }

        @Override
        public ImmutableList<S> prepend(ImmutableList<S> list) {
            if (list.isEmpty()) {
                return this;
            }
            int sz = list.size();
            if (sz == 1) {
                return new Cons<S>(list.head(), this);
            }
            Cons<Object> result = this;
            Object[] listElements = list.toArray(new Object[sz]);
            for (int i = sz - 1; i >= 0; --i) {
                result = new Cons<Object>(listElements[i], result);
            }
            return result;
        }

        @Override
        public ImmutableList<S> prependReverse(ImmutableList<S> list) {
            if (list.isEmpty()) {
                return this;
            }
            Cons<S> result = this;
            for (int sz = list.size(); sz > 0; --sz) {
                result = new Cons<S>(list.head(), result);
                list = list.tail();
            }
            return result;
        }

        @Override
        public boolean exists(Predicate<S> predicate) {
            ImmutableList<Object> list = this;
            while (!list.isEmpty()) {
                if (predicate.test(list.head())) {
                    return true;
                }
                list = list.tail();
            }
            return false;
        }

        @Override
        public ImmutableList<S> append(S e) {
            return new Cons<S>(e).prepend(this);
        }

        @Override
        public ImmutableList<S> append(ImmutableList<S> list) {
            return list.prepend(this);
        }

        @Override
        public ImmutableList<S> append(S ... array) {
            return Cons.nil().prepend(array).prepend(this);
        }

        @Override
        public S head() {
            return this.element;
        }

        @Override
        public ImmutableList<S> tail() {
            return this.cons;
        }

        public int hashCode() {
            int hashCode = 0;
            ImmutableList<Object> crt = this;
            while (!crt.isEmpty()) {
                Object element = crt.head();
                hashCode = (element == null ? 0 : element.hashCode()) + 31 * hashCode;
                crt = crt.tail();
            }
            return hashCode;
        }

        @Override
        public Iterator<S> iterator() {
            return new SLListIterator(this);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean contains(S obj) {
            ImmutableList<Object> list = this;
            while (!list.isEmpty()) {
                Object t = list.head();
                if (t == null ? obj == null : t.equals(obj)) {
                    return true;
                }
                list = list.tail();
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public ImmutableList<S> removeFirst(S obj) {
            Object[] res = new Object[this.size()];
            int i = 0;
            ImmutableSLList rest = this;
            while (!rest.isEmpty()) {
                Object t = rest.head();
                rest = (ImmutableSLList)rest.tail();
                if (!(t != null ? t.equals(obj) : obj == null)) {
                    res[i++] = t;
                    continue;
                }
                ImmutableSLList unmodifiedTail = rest;
                return unmodifiedTail.prepend(res, i);
            }
            return this;
        }

        @Override
        public ImmutableList<S> removeAll(S obj) {
            Object[] res = new Object[this.size()];
            int i = 0;
            ImmutableSLList rest = this;
            Cons unmodifiedTail = this;
            while (!rest.isEmpty()) {
                Object t = rest.head();
                rest = (ImmutableSLList)rest.tail();
                if (!(t != null ? t.equals(obj) : obj == null)) {
                    res[i++] = t;
                    continue;
                }
                unmodifiedTail = rest;
            }
            return unmodifiedTail.prepend(res, i - unmodifiedTail.size());
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImmutableList)) {
                return false;
            }
            ImmutableList o1 = (ImmutableList)o;
            if (o1.size() != this.size()) {
                return false;
            }
            Iterator<S> p = this.iterator();
            Iterator q = o1.iterator();
            while (p.hasNext()) {
                S ep = p.next();
                Object eq = q.next();
                if ((ep != null || eq == null) && (ep == null || ep.equals(eq))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            Iterator<S> it = this.iterator();
            StringBuilder str = new StringBuilder("[");
            while (it.hasNext()) {
                str.append(it.next());
                if (!it.hasNext()) continue;
                str.append(",");
            }
            str.append("]");
            return str.toString();
        }
    }
}

