/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.key_project.util.collection.DefaultImmutableSet;
import org.key_project.util.collection.NotUniqueException;

public interface ImmutableSet<T>
extends Iterable<T>,
Serializable {
    public static <T> Collector<T, Set<T>, ImmutableSet<T>> collector() {
        return Collector.of(HashSet::new, (set, el) -> set.add(el), (set1, set2) -> {
            set1.addAll(set2);
            return set1;
        }, ImmutableSet::fromSet, Collector.Characteristics.UNORDERED);
    }

    public static <T> ImmutableSet<T> fromSet(Set<T> set) {
        ImmutableSet<T> result = DefaultImmutableSet.nil();
        for (T el : set) {
            result = result.add(el);
        }
        return result;
    }

    public static <T> ImmutableSet<T> singleton(T obj) {
        DefaultImmutableSet<T> result = DefaultImmutableSet.nil();
        return result.add(obj);
    }

    public static <T> ImmutableSet<T> empty() {
        return DefaultImmutableSet.nil();
    }

    public static <T> ImmutableSet<T> fromCollection(@Nonnull Collection<? extends T> seq) {
        return ImmutableSet.fromSet(new HashSet<T>(seq));
    }

    public Set<T> toSet();

    public ImmutableSet<T> add(T var1);

    public ImmutableSet<T> union(ImmutableSet<? extends T> var1);

    public ImmutableSet<T> intersect(ImmutableSet<? extends T> var1);

    @Override
    public Iterator<T> iterator();

    public Stream<T> stream();

    public boolean exists(Predicate<T> var1);

    public boolean contains(T var1);

    public boolean subset(ImmutableSet<T> var1);

    public int size();

    public boolean isEmpty();

    public ImmutableSet<T> remove(T var1);

    public boolean equals(Object var1);

    public int hashCode();

    public ImmutableSet<T> addUnique(T var1) throws NotUniqueException;

    public <S> S[] toArray(S[] var1);

    default public ImmutableSet<T> add(Iterable<T> seq) {
        ImmutableSet<T> cur = this;
        for (T item : seq) {
            cur = cur.add(item);
        }
        return cur;
    }
}

