/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.collection;

import java.util.HashSet;
import org.key_project.util.collection.DefaultImmutableSet;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.collection.ImmutableSet;

public final class Immutables {
    private Immutables() {
        throw new Error();
    }

    public static <T> boolean isDuplicateFree(ImmutableList<T> list) {
        HashSet<T> set = new HashSet<T>();
        for (T element : list) {
            if (set.contains(element)) {
                return false;
            }
            set.add(element);
        }
        return true;
    }

    public static <T> ImmutableList<T> removeDuplicates(ImmutableList<T> list) {
        Object element;
        ImmutableList top;
        if (list.isEmpty()) {
            return list;
        }
        ImmutableList<Object> stack = ImmutableSLList.nil();
        while (!list.isEmpty()) {
            stack = stack.prepend(list);
            list = list.tail();
        }
        HashSet alreadySeen = new HashSet();
        ImmutableList result = ImmutableSLList.nil();
        while (!stack.isEmpty()) {
            top = (ImmutableList)stack.head();
            element = top.head();
            stack = stack.tail();
            if (alreadySeen.contains(element)) break;
            result = top;
            alreadySeen.add(element);
        }
        while (!stack.isEmpty()) {
            top = (ImmutableList)stack.head();
            element = top.head();
            stack = stack.tail();
            if (alreadySeen.contains(element)) continue;
            result = result.prepend(element);
            alreadySeen.add(element);
        }
        return result;
    }

    public static <T> ImmutableList<T> concatDuplicateFreeLists(ImmutableList<T> l1, ImmutableList<? extends T> l2) {
        HashSet<T> lookup = new HashSet<T>();
        for (T element : l1) {
            lookup.add(element);
        }
        ImmutableList<T> result = l1;
        for (T element : l2) {
            if (lookup.contains(element)) continue;
            result = result.prepend(element);
        }
        return result;
    }

    public static <T> ImmutableSet<T> createSetFrom(Iterable<T> iterable) {
        return DefaultImmutableSet.fromImmutableList(Immutables.createListFrom(iterable));
    }

    public static <T> ImmutableList<T> createListFrom(Iterable<T> iterable) {
        ImmutableList<T> result = ImmutableSLList.nil();
        for (T t : iterable) {
            result = result.prepend(t);
        }
        return result.reverse();
    }
}

