/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.collection;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class KeYCollections {
    public static <S, T extends S> S[] concat(S[] s1, T[] s2) {
        S[] res = Arrays.copyOf(s1, s1.length + s2.length);
        for (int i = 0; i < s2.length; ++i) {
            res[i + s1.length] = s2[i];
        }
        return res;
    }

    public static <S, T, U> Map<S, U> apply(Map<S, ? extends T> m0, Map<T, U> m1) {
        int size;
        AbstractMap res = null;
        int n = size = m0.size() < m1.size() ? m0.size() : m1.size();
        res = m0 instanceof TreeMap ? new TreeMap() : (m0 instanceof ConcurrentHashMap ? new ConcurrentHashMap(size) : (m0 instanceof IdentityHashMap ? new IdentityHashMap(size) : (m0 instanceof WeakHashMap ? new WeakHashMap(size) : new HashMap(size))));
        for (Map.Entry<S, T> e : m0.entrySet()) {
            U value = m1.get(e.getValue());
            if (value == null) continue;
            res.put(e.getKey(), value);
        }
        return res;
    }

    public static String join(Iterable<?> collection, String delimiter) {
        return StreamSupport.stream(collection.spliterator(), false).map(Objects::toString).collect(Collectors.joining(delimiter));
    }

    public static String join(Object[] collection, String delimiter) {
        return Arrays.stream(collection).map(Objects::toString).collect(Collectors.joining(delimiter));
    }

    public static String filterAlphabetic(String string) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((c < 'A' || c > 'Z') && (c < 'A' || c > 'Z')) continue;
            res.append(c);
        }
        return res.toString();
    }
}

