/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.collection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class PropertiesUtil {
    private PropertiesUtil() {
        throw new Error("do not instantiate");
    }

    public static void readLineBased(Properties properties, InputStream is) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        Object currentKey = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (line.startsWith(" ") || line.startsWith("\t")) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(line.trim());
                continue;
            }
            if (sb.length() <= 0) continue;
            if (currentKey == null) {
                throw new IOException("No key defined");
            }
            properties.put((Object)currentKey, sb.toString());
            sb.setLength(0);
        }
        if (sb.length() > 0) {
            if (currentKey == null) {
                throw new IOException("No key defined");
            }
            properties.put((Object)currentKey, sb.toString());
            sb.setLength(0);
        }
    }
}

