/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.helper;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class FindResources {
    public static <T> List<Path> getResources(String path, Class<T> clazz) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            File[] files = new File(dirURL.toURI()).listFiles();
            Objects.requireNonNull(files);
            return Arrays.stream(files).map(File::toPath).collect(Collectors.toList());
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL == null) {
            return null;
        }
        if ("jar".equals(dirURL.getProtocol())) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            FileSystem fs = FileSystems.newFileSystem(Paths.get(jarPath, new String[0]), clazz.getClassLoader());
            Path dir = fs.getPath(path, new String[0]);
            return Files.list(dir).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException("Cannot list files for URL $dirURL");
    }

    public static <T> List<Path> getResources(String path) throws URISyntaxException, IOException {
        return FindResources.getResources(path, FindResources.class);
    }

    public static <T> Path getResource(String path, Class<T> clazz) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).toPath();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL == null) {
            return null;
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            FileSystem fs = FileSystems.newFileSystem(Paths.get(jarPath, new String[0]), clazz.getClassLoader());
            Path dir = fs.getPath(path, new String[0]);
            return dir;
        }
        throw new UnsupportedOperationException("Cannot list files for URL $dirURL");
    }

    public static <T> Path getResource(String path) throws URISyntaxException, IOException {
        return FindResources.getResource(path, FindResources.class);
    }

    public static File findFolder(String property, String ... candidates) {
        return FindResources.findFolder(true, property, candidates);
    }

    public static File findFolder(boolean exists, String property, String ... candidates) {
        File f;
        if (System.getProperty(property) != null && ((f = new File(System.getProperty(property))).exists() || !exists)) {
            return f;
        }
        for (String c : candidates) {
            File f2 = new File(c);
            if (!f2.exists() && exists) continue;
            return f2;
        }
        return null;
    }

    public static File getExampleDirectory() {
        return FindResources.findFolder("KEY_EXAMPLES_DIR", "key.ui/examples", "../key.ui/examples", "examples");
    }

    public static File getTestResultForRunAllProofs() {
        return FindResources.findFolder(false, "KEY_TESTRESULT_RUNALLPROOFS", "build/reports/runallproofs");
    }

    public static File getTestCasesDirectory() {
        return FindResources.findFolder("TEST_CASES", "src/test/resources/testcase");
    }

    public static File getTestResourcesDirectory() {
        return FindResources.findFolder("TEST_RESOURCES", "src/test/resources/");
    }

    public static File getTacletProofsDirectory() {
        return FindResources.findFolder("TACLET_PROOFS", "key.core/tacletProofs", "../key.core/tacletProofs", "tacletProofs");
    }
}

