/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.java;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import org.key_project.util.java.IFilter;
import org.key_project.util.java.IntegerUtil;
import org.key_project.util.java.ObjectUtil;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> T search(T[] array, IFilter<T> filter) {
        T result = null;
        if (array != null && filter != null) {
            for (int i = 0; result == null && i < array.length; ++i) {
                if (!filter.select(array[i])) continue;
                result = array[i];
            }
        }
        return result;
    }

    public static <T> T[] addAll(T[] array, T[] toAdd) {
        if (array != null) {
            if (toAdd != null) {
                Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + toAdd.length);
                System.arraycopy(array, 0, result, 0, array.length);
                System.arraycopy(toAdd, 0, result, array.length, toAdd.length);
                return result;
            }
            Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length);
            System.arraycopy(array, 0, result, 0, array.length);
            return result;
        }
        if (toAdd != null) {
            Object[] result = (Object[])Array.newInstance(toAdd.getClass().getComponentType(), toAdd.length);
            System.arraycopy(toAdd, 0, result, 0, toAdd.length);
            return result;
        }
        throw new IllegalArgumentException("Can not create an array if both paramters are null.");
    }

    public static <T> T[] addAll(T[] array, T[] toAdd, Class<?> newArrayType) {
        if (array != null) {
            if (toAdd != null) {
                Object[] result = (Object[])Array.newInstance(newArrayType, array.length + toAdd.length);
                System.arraycopy(array, 0, result, 0, array.length);
                System.arraycopy(toAdd, 0, result, array.length, toAdd.length);
                return result;
            }
            Object[] result = (Object[])Array.newInstance(newArrayType, array.length);
            System.arraycopy(array, 0, result, 0, array.length);
            return result;
        }
        if (toAdd != null) {
            Object[] result = (Object[])Array.newInstance(newArrayType, toAdd.length);
            System.arraycopy(toAdd, 0, result, 0, toAdd.length);
            return result;
        }
        Object[] result = (Object[])Array.newInstance(newArrayType, 0);
        return result;
    }

    public static <T> T[] add(T[] array, T toAdd) {
        if (array != null) {
            Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
            System.arraycopy(array, 0, result, 0, array.length);
            result[array.length] = toAdd;
            return result;
        }
        if (toAdd != null) {
            Object[] result = (Object[])Array.newInstance(toAdd.getClass(), 1);
            result[0] = toAdd;
            return result;
        }
        throw new IllegalArgumentException("Can not create an array if both paramters are null.");
    }

    public static int[] add(int[] array, int toAdd) {
        if (array != null) {
            int[] result = new int[array.length + 1];
            System.arraycopy(array, 0, result, 0, array.length);
            result[array.length] = toAdd;
            return result;
        }
        return new int[]{toAdd};
    }

    public static <T> T[] insert(T[] array, T toInsert, int index) {
        if (array != null) {
            Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
            if (index >= 1) {
                System.arraycopy(array, 0, result, 0, index);
            }
            result[index] = toInsert;
            System.arraycopy(array, index, result, index + 1, array.length - index);
            return result;
        }
        if (toInsert != null) {
            Object[] result = (Object[])Array.newInstance(toInsert.getClass(), 1);
            result[0] = toInsert;
            return result;
        }
        throw new IllegalArgumentException("Can not create an array if array and element to insert are null.");
    }

    public static <T> boolean contains(T[] array, T toSearch) {
        return ArrayUtil.contains(array, toSearch, ObjectUtil.createEqualsComparator());
    }

    public static <T> boolean contains(T[] array, T toSearch, Comparator<T> comparator) {
        return ArrayUtil.indexOf(array, toSearch, comparator) >= 0;
    }

    public static <T> int indexOf(T[] array, T toSearch) {
        return ArrayUtil.indexOf(array, toSearch, ObjectUtil.createEqualsComparator());
    }

    public static <T> int indexOf(T[] array, T toSearch, Comparator<T> comparator) {
        int index = -1;
        if (array != null) {
            if (comparator == null) {
                throw new IllegalArgumentException("Comparator is null.");
            }
            for (int i = 0; i < array.length && index < 0; ++i) {
                if (comparator.compare(array[i], toSearch) != 0) continue;
                index = i;
            }
        }
        return index;
    }

    public static <T> T[] remove(T[] array, T toRemove) {
        return ArrayUtil.remove(array, toRemove, ObjectUtil.createEqualsComparator());
    }

    public static <T> T[] remove(T[] array, T toRemove, Comparator<T> comparator) {
        if (array != null) {
            if (comparator == null) {
                throw new IllegalArgumentException("Comparator is null.");
            }
            LinkedList<T> result = new LinkedList<T>();
            if (array != null) {
                for (T element : array) {
                    if (comparator.compare(element, toRemove) == 0) continue;
                    result.add(element);
                }
            }
            return result.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), result.size()));
        }
        return null;
    }

    public static <T> String toString(T ... array) {
        return ArrayUtil.toString(array, ", ");
    }

    public static <T> String toString(T[] array, String separator) {
        StringBuffer sb = new StringBuffer();
        if (array != null) {
            boolean afterFirst = false;
            for (T element : array) {
                if (afterFirst) {
                    sb.append(separator);
                } else {
                    afterFirst = true;
                }
                sb.append(ObjectUtil.toString(element));
            }
        }
        return sb.toString();
    }

    public static String toString(int[] array) {
        return ArrayUtil.toString(array, ", ");
    }

    public static String toString(int[] array, String separator) {
        StringBuffer sb = new StringBuffer();
        if (array != null) {
            boolean afterFirst = false;
            for (int element : array) {
                if (afterFirst) {
                    sb.append(separator);
                } else {
                    afterFirst = true;
                }
                sb.append(ObjectUtil.toString(element));
            }
        }
        return sb.toString();
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T getPrevious(T[] array, T toSearch) {
        return ArrayUtil.getPrevious(array, toSearch, ObjectUtil.createEqualsComparator());
    }

    public static <T> T getPrevious(T[] array, T toSearch, Comparator<T> comparator) throws IllegalArgumentException {
        int index = ArrayUtil.indexOf(array, toSearch, comparator);
        if (index >= 1) {
            return array[index - 1];
        }
        return null;
    }

    public static <T> T getFollowing(T[] array, T toSearch) {
        return ArrayUtil.getFollowing(array, toSearch, ObjectUtil.createEqualsComparator());
    }

    public static <T> T getFollowing(T[] array, T toSearch, Comparator<T> comparator) throws IllegalArgumentException {
        int index = ArrayUtil.indexOf(array, toSearch, comparator);
        if (index < array.length - 1) {
            return array[index + 1];
        }
        return null;
    }

    public static <T> boolean isLast(T[] array, T toSearch) {
        return ArrayUtil.isLast(array, toSearch, ObjectUtil.createEqualsComparator());
    }

    public static <T> boolean isLast(T[] array, T toSearch, Comparator<T> comparator) {
        if (array != null && array.length >= 1) {
            if (comparator == null) {
                throw new IllegalArgumentException("Comparator is null.");
            }
            return comparator.compare(array[array.length - 1], toSearch) == 0;
        }
        return false;
    }

    public static <T> boolean isFirst(T[] array, T toSearch) {
        return ArrayUtil.isFirst(array, toSearch, ObjectUtil.createEqualsComparator());
    }

    public static <T> boolean isFirst(T[] array, T toSearch, Comparator<T> comparator) {
        if (array != null && array.length >= 1) {
            if (comparator == null) {
                throw new IllegalArgumentException("Comparator is null.");
            }
            return comparator.compare(array[0], toSearch) == 0;
        }
        return false;
    }

    public static <T> T getFirst(T[] array) {
        if (!ArrayUtil.isEmpty(array)) {
            return array[0];
        }
        return null;
    }

    public static <T> T getLast(T[] array) {
        if (!ArrayUtil.isEmpty(array)) {
            return array[array.length - 1];
        }
        return null;
    }

    public static <T> T[][] generatePermutations(T[] array) {
        if (array != null) {
            Object[][] permutations = (Object[][])Array.newInstance(array.getClass(), array.length > 0 ? IntegerUtil.factorial(array.length) : 0);
            ArrayUtil.generatePermutations(array, array.length, permutations, 0);
            return permutations;
        }
        return null;
    }

    private static <T> int generatePermutations(T[] array, int n, T[][] permutations, int permutationsIndex) {
        if (n == 1) {
            T[] copy = Arrays.copyOf(array, array.length);
            permutations[permutationsIndex] = copy;
            ++permutationsIndex;
        } else {
            for (int i = 0; i < n; ++i) {
                T tmp;
                permutationsIndex = ArrayUtil.generatePermutations(array, n - 1, permutations, permutationsIndex);
                if (n % 2 != 0) {
                    tmp = array[i];
                    array[i] = array[n - 1];
                    array[n - 1] = tmp;
                    continue;
                }
                tmp = array[0];
                array[0] = array[n - 1];
                array[n - 1] = tmp;
            }
        }
        return permutationsIndex;
    }
}

