/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.key_project.util.java.IFilter;
import org.key_project.util.java.IFilterWithException;
import org.key_project.util.java.ObjectUtil;

public class CollectionUtil {
    public static final String SEPARATOR = ", ";

    private CollectionUtil() {
    }

    public static <T> int indexOf(Iterator<T> iter, T toSearch) {
        if (iter != null) {
            int i = 0;
            boolean found = false;
            while (!found && iter.hasNext()) {
                T next = iter.next();
                if (next != null ? next.equals(toSearch) : toSearch == null) {
                    found = true;
                    continue;
                }
                ++i;
            }
            if (found) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    public static String toString(Collection<?> collection) {
        return CollectionUtil.toString(collection, SEPARATOR);
    }

    public static String toString(Collection<?> collection, String separator) {
        StringBuffer sb = new StringBuffer();
        if (collection != null) {
            boolean afterFirst = false;
            for (Object object : collection) {
                if (afterFirst) {
                    if (separator != null) {
                        sb.append(separator);
                    }
                } else {
                    afterFirst = true;
                }
                sb.append(ObjectUtil.toString(object));
            }
        }
        return sb.toString();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T> List<T> toList(T ... objects) {
        if (objects != null) {
            ArrayList<T> result = new ArrayList<T>(objects.length);
            for (T obj : objects) {
                result.add(obj);
            }
            return result;
        }
        return new ArrayList(0);
    }

    public static <T> Set<T> toSet(T ... objects) {
        if (objects != null) {
            LinkedHashSet<T> result = new LinkedHashSet<T>(objects.length);
            for (T obj : objects) {
                result.add(obj);
            }
            return result;
        }
        return new LinkedHashSet(0);
    }

    public static <T> void addAll(Collection<T> collection, T ... elementsToAdd) {
        if (collection != null && elementsToAdd != null) {
            for (T toAdd : elementsToAdd) {
                collection.add(toAdd);
            }
        }
    }

    public static <T> void addAll(Collection<T> collection, Iterable<T> iterable) {
        if (collection != null && iterable != null) {
            for (T toAdd : iterable) {
                collection.add(toAdd);
            }
        }
    }

    public static <T> boolean removeAll(Collection<T> collection, T ... elementsToRemove) {
        if (collection != null && elementsToRemove != null) {
            boolean result = false;
            for (T toAdd : elementsToRemove) {
                result = collection.remove(toAdd) || result;
            }
            return result;
        }
        return false;
    }

    public static <T> boolean removeComplete(Collection<T> collection, T toRemove) {
        if (collection != null) {
            Iterator<T> iter = collection.iterator();
            boolean changed = false;
            while (iter.hasNext()) {
                if (!ObjectUtil.equals(iter.next(), toRemove)) continue;
                iter.remove();
                changed = true;
            }
            return changed;
        }
        return false;
    }

    public static <T> List<T> searchAll(Iterable<T> iterable, IFilter<T> filter) {
        LinkedList<T> result = new LinkedList<T>();
        if (iterable != null && filter != null) {
            for (T element : iterable) {
                if (!filter.select(element)) continue;
                result.add(element);
            }
        }
        return result;
    }

    public static <T> T search(Iterable<T> iterable, IFilter<T> filter) {
        Iterator<T> iter;
        T result = null;
        if (iterable != null && filter != null && (iter = iterable.iterator()) != null) {
            while (result == null && iter.hasNext()) {
                T next = iter.next();
                if (!filter.select(next)) continue;
                result = next;
            }
        }
        return result;
    }

    public static <T> T searchAndRemove(Iterable<T> iterable, IFilter<T> filter) {
        Iterator<T> iter;
        T result = null;
        if (iterable != null && filter != null && (iter = iterable.iterator()) != null) {
            while (result == null && iter.hasNext()) {
                T next = iter.next();
                if (!filter.select(next)) continue;
                result = next;
                iter.remove();
            }
        }
        return result;
    }

    public static <T, E extends Throwable> T searchAndRemoveWithException(Iterable<T> iterable, IFilterWithException<T, E> filter) throws E {
        Iterator<T> iter;
        T result = null;
        if (iterable != null && filter != null && (iter = iterable.iterator()) != null) {
            while (result == null && iter.hasNext()) {
                T next = iter.next();
                if (!filter.select(next)) continue;
                result = next;
                iter.remove();
            }
        }
        return result;
    }

    public static <T> boolean contains(Iterable<T> iterable, T element) {
        Iterator<T> iter;
        boolean found = false;
        if (iterable != null && (iter = iterable.iterator()) != null) {
            while (!found && iter.hasNext()) {
                found = ObjectUtil.equals(iter.next(), element);
            }
        }
        return found;
    }

    public static <T> int count(Iterable<T> iterable, IFilter<T> filter) {
        int count = 0;
        if (iterable != null && filter != null) {
            for (T element : iterable) {
                if (!filter.select(element)) continue;
                ++count;
            }
        }
        return count;
    }

    public static <T> boolean containsSame(Collection<T> first, Collection<T> second) {
        if (first != null) {
            if (second != null) {
                if (first.size() == second.size()) {
                    LinkedList<T> firstCopy = new LinkedList<T>(first);
                    boolean same = true;
                    Iterator<T> secondIter = second.iterator();
                    while (same && secondIter.hasNext()) {
                        T secondNext = secondIter.next();
                        same = firstCopy.remove(secondNext);
                    }
                    return same;
                }
                return false;
            }
            return first.size() == 0;
        }
        return second == null || second.size() == 0;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        try {
            if (iterable != null) {
                Iterator<T> iter = iterable.iterator();
                return iter.next();
            }
            return null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public static <T> T removeFirst(Iterable<T> iterable) {
        try {
            if (iterable != null) {
                Iterator<T> iter = iterable.iterator();
                T next = iter.next();
                iter.remove();
                return next;
            }
            return null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public static <T> List<T> arrayToList(T[] array) {
        LinkedList<T> list = new LinkedList<T>();
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    public static <T> void binaryInsert(List<T> list, T toInsert, Comparator<T> comparator) {
        if (list.isEmpty()) {
            list.add(toInsert);
        } else {
            int index = Collections.binarySearch(list, toInsert, comparator);
            if (index < 0) {
                index = index * -1 - 1;
            }
            list.add(index, toInsert);
        }
    }
}

