/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.java;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.key_project.util.java.IFilter;
import org.key_project.util.java.StringUtil;

public final class IOUtil {
    public static final int BUFFER_SIZE = 10240;
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static Pattern URL_JAR_FILE = Pattern.compile("jar:file:([^!]+)!/(.+)");

    private IOUtil() {
    }

    public static String computeMD5(File file) throws IOException {
        if (file == null) {
            throw new IOException("Can't compute MD5 without a File.");
        }
        if (!file.isFile()) {
            throw new IOException("Can't compute MD5, because \"" + file + "\" is not an existing file.");
        }
        return IOUtil.computeMD5(new FileInputStream(file));
    }

    public static String computeMD5(InputStream in) throws IOException {
        if (in == null) {
            throw new IOException("Can't compute MD5 without an InputStream.");
        }
        try {
            int read;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String string = bigInt.toString(16);
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Algorithm MD5 is not available.");
        }
        finally {
            in.close();
        }
    }

    public static File getHomeDirectory() {
        String path = System.getProperty("user.home");
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    public static String getFileExtension(File file) {
        if (file != null) {
            String name = file.getName();
            if (name != null) {
                int dotIndex = name.lastIndexOf(".");
                if (dotIndex >= 0) {
                    return name.substring(dotIndex + 1);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static String getFileNameWithoutExtension(String fileName) {
        if (fileName != null) {
            int dotIndex = fileName.lastIndexOf(46);
            if (dotIndex >= 0) {
                return fileName.substring(0, dotIndex);
            }
            return fileName;
        }
        return null;
    }

    public static void delete(File file) {
        if (file != null && file.exists()) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                for (File child : children) {
                    IOUtil.delete(child);
                }
            }
            file.delete();
        }
    }

    public static String readFrom(URL url) throws IOException {
        if (url != null) {
            return IOUtil.readFrom(url.openStream());
        }
        return null;
    }

    public static String readFrom(File file) throws IOException {
        if (file != null && file.isFile()) {
            return IOUtil.readFrom(new FileInputStream(file));
        }
        return null;
    }

    public static String readFrom(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader(in);){
            int read;
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[10240];
            while ((read = reader.read(buffer)) >= 1) {
                sb.append(buffer, 0, read);
            }
            String string = sb.toString();
            return string;
        }
    }

    public static void writeTo(OutputStream out, String content) throws IOException {
        IOUtil.writeTo(out, content, (String)null);
    }

    public static void writeTo(OutputStream out, String content, Charset encoding) throws IOException {
        IOUtil.writeTo(out, content, encoding != null ? encoding.displayName() : null);
    }

    public static void writeTo(OutputStream out, String content, String encoding) throws IOException {
        if (out == null || content == null) {
            return;
        }
        try (PrintStream printStream = encoding != null ? new PrintStream(out, false, encoding) : new PrintStream(out);){
            printStream.print(content);
        }
    }

    public static LineInformation[] computeLineInformation(File file) throws IOException {
        if (file != null) {
            return IOUtil.computeLineInformation(new FileInputStream(file));
        }
        return IOUtil.computeLineInformation((InputStream)null);
    }

    public static LineInformation[] computeLineInformation(InputStream in) throws IOException {
        if (in == null) {
            return new LineInformation[0];
        }
        try (InputStreamReader reader = new InputStreamReader(in);){
            int read;
            LinkedList<LineInformation> result = new LinkedList<LineInformation>();
            char[] buffer = new char[10240];
            int startIndex = 0;
            int lastSignWasRBreakIndex = -1;
            int lastIndex = 0;
            LinkedList<Integer> tabIndices = new LinkedList<Integer>();
            while ((read = reader.read(buffer)) >= 1) {
                for (int i = 0; i < read; ++i) {
                    if ('\n' == buffer[i]) {
                        if (lastSignWasRBreakIndex >= 0) {
                            result.add(new LineInformation(lastSignWasRBreakIndex, tabIndices));
                            lastSignWasRBreakIndex = -1;
                            tabIndices.clear();
                        } else {
                            result.add(new LineInformation(lastIndex, tabIndices));
                            tabIndices.clear();
                        }
                        lastIndex = startIndex + i + 1;
                        continue;
                    }
                    if ('\r' == buffer[i]) {
                        if (lastSignWasRBreakIndex >= 0) {
                            result.add(new LineInformation(lastSignWasRBreakIndex, tabIndices));
                            lastSignWasRBreakIndex = -1;
                            tabIndices.clear();
                        }
                        if (i < buffer.length - 1) {
                            if ('\n' == buffer[i + 1]) continue;
                            result.add(new LineInformation(lastIndex, tabIndices));
                            lastIndex = startIndex + i + 1;
                            tabIndices.clear();
                            continue;
                        }
                        lastSignWasRBreakIndex = lastIndex;
                        lastIndex = startIndex + i + 1;
                        continue;
                    }
                    if ('\t' != buffer[i]) continue;
                    tabIndices.add(i - lastIndex);
                }
                startIndex += read;
            }
            if (lastSignWasRBreakIndex >= 0) {
                result.add(new LineInformation(lastSignWasRBreakIndex, tabIndices));
                tabIndices.clear();
            }
            if (lastIndex >= 0) {
                result.add(new LineInformation(lastIndex, tabIndices));
                tabIndices.clear();
            }
            LineInformation[] lineInformationArray = result.toArray(new LineInformation[0]);
            return lineInformationArray;
        }
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        File tempFile = File.createTempFile(prefix, suffix);
        if (!tempFile.delete()) {
            throw new IOException("Can't delete temp file, reason is unknown.");
        }
        if (!tempFile.mkdir()) {
            throw new IOException("Can't create temp directory, reason is unknown.");
        }
        return tempFile;
    }

    public static List<File> search(File file, final IFilter<File> filter) throws IOException {
        final LinkedList<File> result = new LinkedList<File>();
        if (file != null) {
            IOUtil.visit(file, new IFileVisitor(){

                @Override
                public void visit(File visitedFile) {
                    if (filter == null || filter.select(visitedFile)) {
                        result.add(visitedFile);
                    }
                }
            });
        }
        return result;
    }

    public static void visit(File file, IFileVisitor visitor) throws IOException {
        if (file != null && visitor != null) {
            visitor.visit(file);
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    IOUtil.visit(child, visitor);
                }
            }
        }
    }

    public static InputStream unifyLineBreaks(InputStream in) throws IOException {
        if (in != null) {
            String text = IOUtil.readFrom(in);
            text = text.replace("\r\n", "\n");
            text = text.replace("\r", "\n");
            return new ByteArrayInputStream(text.getBytes());
        }
        return null;
    }

    public static boolean contains(Iterable<File> parents, File child) {
        boolean contains = false;
        if (parents != null) {
            Iterator<File> iter = parents.iterator();
            while (!contains && iter.hasNext()) {
                contains = IOUtil.contains(iter.next(), child);
            }
        }
        return contains;
    }

    public static boolean contains(File parent, File child) {
        boolean contains = false;
        if (parent != null && child != null) {
            while (!contains && child != null) {
                if (parent.equals(child)) {
                    contains = true;
                }
                child = child.getParentFile();
            }
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(Reader source, StringWriter target) throws IOException {
        try {
            if (source != null && target != null) {
                int read;
                char[] buffer = new char[10240];
                while ((read = source.read(buffer)) >= 1) {
                    target.write(buffer, 0, read);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (target != null) {
                target.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(InputStream source, OutputStream target) throws IOException {
        try {
            if (source != null && target != null) {
                int read;
                byte[] buffer = new byte[10240];
                while ((read = source.read(buffer)) >= 1) {
                    target.write(buffer, 0, read);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (target != null) {
                target.close();
            }
        }
    }

    public static boolean exists(File file) {
        return file != null && file.exists();
    }

    public static URL getClassLocationURL(Class<?> classInstance) {
        CodeSource cs = classInstance.getProtectionDomain().getCodeSource();
        return cs != null ? cs.getLocation() : null;
    }

    public static File getClassLocation(Class<?> classInstance) {
        if (classInstance != null) {
            return IOUtil.toFile(IOUtil.getClassLocationURL(classInstance));
        }
        return null;
    }

    public static File getProjectRoot(Class<?> classInstance) {
        File file = IOUtil.getClassLocation(classInstance);
        return file != null ? file.getParentFile() : null;
    }

    public static File toFile(URL url) {
        URI uri = IOUtil.toURI(url);
        return uri != null ? new File(uri) : null;
    }

    public static String toFileString(URL url) {
        File file = IOUtil.toFile(url);
        return file != null ? file.toString() : null;
    }

    public static URI toURI(URL url) {
        try {
            if (url != null) {
                String protocol = url.getProtocol();
                String userInfo = url.getUserInfo();
                String host = url.getHost();
                String path = URLDecoder.decode(url.getPath(), "UTF-8");
                String query = url.getQuery();
                String ref = url.getRef();
                return new URI(!StringUtil.isEmpty(protocol) ? protocol : null, !StringUtil.isEmpty(userInfo) ? userInfo : null, !StringUtil.isEmpty(host) ? host : null, url.getPort(), !StringUtil.isEmpty(path) ? path : null, !StringUtil.isEmpty(query) ? query : null, !StringUtil.isEmpty(ref) ? ref : null);
            }
            return null;
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            return null;
        }
    }

    public static File getCurrentDirectory() {
        return new File(".").getAbsoluteFile().getParentFile();
    }

    public static File getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static String validateOSIndependentFileName(String name) {
        if (name != null) {
            char[] latinBig = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
            char[] latinSmall = StringUtil.LATIN_ALPHABET_SMALL.toCharArray();
            char[] numerals = "0123456789".toCharArray();
            char[] content = name.toCharArray();
            for (int i = 0; i < content.length; ++i) {
                if (Arrays.binarySearch(latinBig, content[i]) >= 0 || Arrays.binarySearch(latinSmall, content[i]) >= 0 || Arrays.binarySearch(numerals, content[i]) >= 0 || Arrays.binarySearch(StringUtil.ADDITIONAL_ALLOWED_FILE_NAME_SYSTEM_CHARACTERS, content[i]) >= 0) continue;
                content[i] = 95;
            }
            return new String(content);
        }
        return name;
    }

    public static void extractZip(Path archive, Path targetDir) throws IOException {
        if (archive == null || targetDir == null) {
            return;
        }
        try (ZipFile zipFile = new ZipFile(archive.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    Files.createDirectories(targetDir.resolve(entry.getName()), new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(targetDir.resolve(entry.getName()).getParent(), new FileAttribute[0]);
                Files.copy(zipFile.getInputStream(entry), targetDir.resolve(entry.getName()), new CopyOption[0]);
            }
        }
    }

    public static InputStream openStream(String resourceLocation) throws IOException {
        Matcher matcher = URL_JAR_FILE.matcher(resourceLocation);
        if (matcher.matches()) {
            return IOUtil.openStreamFileInJar(matcher);
        }
        try {
            URL url = new URL(resourceLocation);
            return url.openStream();
        }
        catch (MalformedURLException e) {
            return new FileInputStream(resourceLocation);
        }
    }

    private static InputStream openStreamFileInJar(String fileName) throws IOException {
        Matcher matcher = URL_JAR_FILE.matcher(fileName);
        if (matcher.matches()) {
            return IOUtil.openStreamFileInJar(matcher);
        }
        throw new IllegalArgumentException("Given filename is not a file in jar file");
    }

    private static InputStream openStreamFileInJar(Matcher matcher) throws IOException {
        String jarFile = matcher.group(1);
        String file = matcher.group(2);
        try (ZipFile zipFile = new ZipFile(jarFile);){
            ZipEntry entry = zipFile.getEntry(file);
            InputStream inputStream = zipFile.getInputStream(entry);
            return inputStream;
        }
    }

    public static interface IFileVisitor {
        public void visit(File var1) throws IOException;
    }

    public static class LineInformation {
        private final int offset;
        private final int[] tabIndices;

        public LineInformation(int offset, List<Integer> tabIndices) {
            this.offset = offset;
            if (tabIndices != null) {
                this.tabIndices = new int[tabIndices.size()];
                int i = 0;
                for (Integer index : tabIndices) {
                    assert (index != null);
                    this.tabIndices[i] = index;
                    ++i;
                }
            } else {
                this.tabIndices = new int[0];
            }
        }

        public int getOffset() {
            return this.offset;
        }

        public int[] getTabIndices() {
            return this.tabIndices;
        }

        public int normalizeColumn(int column, int tabWidth) {
            if (column >= 0 && tabWidth >= 2) {
                int result = column;
                boolean goOn = true;
                int i = 0;
                while (goOn) {
                    goOn = i < this.tabIndices.length && this.tabIndices[i] < column - i * (tabWidth - 1);
                    if (!goOn) continue;
                    result -= tabWidth - 1;
                    ++i;
                }
                if (i - 1 >= 0 && i - 1 < this.tabIndices.length && column - (i - 1) * (tabWidth - 1) >= this.tabIndices[i - 1] && column - (i - 1) * (tabWidth - 1) < this.tabIndices[i - 1] + tabWidth - 1) {
                    result += column - (i - 1) * (tabWidth - 1) - this.tabIndices[i - 1];
                }
                return result;
            }
            return column;
        }
    }
}

