/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.java;

public class NumberUtil {
    public static final byte MAX_INT_DIGITS = NumberUtil.numberOfDigits(Integer.MAX_VALUE);
    public static final byte MAX_LONG_DIGITS = NumberUtil.numberOfDigits(Long.MAX_VALUE);

    private NumberUtil() {
    }

    public static String toFullString(int number) {
        byte numOfDigits = NumberUtil.numberOfDigits(number);
        StringBuilder sb = new StringBuilder();
        sb.append(NumberUtil.getAlgebraicSign(number));
        for (int i = 0; i < MAX_INT_DIGITS - numOfDigits; ++i) {
            sb.append("0");
        }
        String numberString = Integer.toString(number);
        if (numberString.startsWith("-")) {
            sb.append(numberString.substring(1));
        } else {
            sb.append(number);
        }
        return sb.toString();
    }

    public static String toFullString(long number) {
        byte numOfDigits = NumberUtil.numberOfDigits(number);
        StringBuilder sb = new StringBuilder();
        sb.append(NumberUtil.getAlgebraicSign(number));
        for (int i = 0; i < MAX_LONG_DIGITS - numOfDigits; ++i) {
            sb.append("0");
        }
        String numberString = Long.toString(number);
        if (numberString.startsWith("-")) {
            sb.append(numberString.substring(1));
        } else {
            sb.append(number);
        }
        return sb.toString();
    }

    public static char getAlgebraicSign(long number) {
        if (number < 0L) {
            return '-';
        }
        return '+';
    }

    public static char getAlgebraicSign(int number) {
        if (number < 0) {
            return '-';
        }
        return '+';
    }

    public static byte numberOfDigits(int number) {
        if (number == 0) {
            return 1;
        }
        byte digits = 0;
        while (number != 0) {
            digits = (byte)(digits + 1);
            number /= 10;
        }
        return digits;
    }

    public static byte numberOfDigits(long number) {
        if (number == 0L) {
            return 1;
        }
        byte digits = 0;
        while (number != 0L) {
            digits = (byte)(digits + 1);
            number /= 10L;
        }
        return digits;
    }

    public static int parseFullInt(String text) {
        if (text != null) {
            if (text.startsWith("+")) {
                text = text.substring(1);
            }
            return Integer.valueOf(text);
        }
        throw new NumberFormatException("Text not defined.");
    }

    public static long parseFullLong(String text) {
        if (text != null) {
            if (text.startsWith("+")) {
                text = text.substring(1);
            }
            return Long.valueOf(text);
        }
        throw new NumberFormatException("Text not defined.");
    }
}

