/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.java;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.LinkedList;
import org.key_project.util.java.StringUtil;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static <T> T get(Object obj, String fieldName) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("Object is undefined (null).");
        }
        return ObjectUtil.get(obj, obj.getClass(), fieldName);
    }

    public static <T> T get(Object obj, Class<?> classInstance, String fieldName) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = ObjectUtil.findField(classInstance, fieldName);
        return ObjectUtil.get(obj, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T get(Object obj, Field field) throws IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("Object is undefined (null).");
        }
        if (field == null) {
            throw new IllegalArgumentException("Field is undefined (null).");
        }
        boolean oldAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(obj);
            return (T)object;
        }
        finally {
            field.setAccessible(oldAccessible);
        }
    }

    public static void set(Object obj, String fieldName, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("Object is undefined (null).");
        }
        ObjectUtil.set(obj, obj.getClass(), fieldName, value);
    }

    public static void set(Object obj, Class<?> classInstance, String fieldName, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = ObjectUtil.findField(classInstance, fieldName);
        ObjectUtil.set(obj, field, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Object obj, Field field, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (field == null) {
            throw new IllegalArgumentException("Field is undefined (null).");
        }
        boolean oldAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        finally {
            field.setAccessible(oldAccessible);
        }
    }

    public static void set(Object obj, String fieldName, boolean value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("Object is undefined (null).");
        }
        ObjectUtil.set(obj, obj.getClass(), fieldName, value);
    }

    public static void set(Object obj, Class<?> classInstance, String fieldName, boolean value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = ObjectUtil.findField(classInstance, fieldName);
        ObjectUtil.set(obj, field, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Object obj, Field field, boolean value) throws IllegalArgumentException, IllegalAccessException {
        if (field == null) {
            throw new IllegalArgumentException("Field is undefined (null).");
        }
        boolean oldAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.setBoolean(obj, value);
        }
        finally {
            field.setAccessible(oldAccessible);
        }
    }

    public static void set(Object obj, String fieldName, int value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("Object is undefined (null).");
        }
        ObjectUtil.set(obj, obj.getClass(), fieldName, value);
    }

    public static void set(Object obj, Class<?> classInstance, String fieldName, int value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = ObjectUtil.findField(classInstance, fieldName);
        ObjectUtil.set(obj, field, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Object obj, Field field, int value) throws IllegalArgumentException, IllegalAccessException {
        if (field == null) {
            throw new IllegalArgumentException("Field is undefined (null).");
        }
        boolean oldAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.setInt(obj, value);
        }
        finally {
            field.setAccessible(oldAccessible);
        }
    }

    public static Field findField(Class<?> classInstance, String fieldName) throws SecurityException, NoSuchFieldException {
        if (classInstance != null) {
            try {
                if (!StringUtil.isEmpty(fieldName)) {
                    return classInstance.getDeclaredField(fieldName);
                }
                throw new IllegalArgumentException("Field is undefined (null).");
            }
            catch (NoSuchFieldException e) {
                if (classInstance.getSuperclass() != null) {
                    return ObjectUtil.findField(classInstance.getSuperclass(), fieldName);
                }
                throw e;
            }
        }
        throw new IllegalArgumentException("Class is undefined (null).");
    }

    public static <T> T invoke(Object obj, String methodName, Object ... parameters) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null) {
            throw new IllegalArgumentException("Object is undefined (null).");
        }
        LinkedList parameterClasses = new LinkedList();
        for (Object parameter : parameters) {
            parameterClasses.add(parameter.getClass());
        }
        Method method = ObjectUtil.findMethod(obj.getClass(), methodName, parameterClasses.toArray(new Class[parameterClasses.size()]));
        return ObjectUtil.invoke(obj, method, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invoke(Object obj, Method method, Object ... parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null) {
            throw new IllegalArgumentException("Object is undefined (null).");
        }
        if (method == null) {
            throw new IllegalArgumentException("Method is undefined (null).");
        }
        boolean oldAccessible = method.isAccessible();
        try {
            method.setAccessible(true);
            Object object = method.invoke(obj, parameters);
            return (T)object;
        }
        finally {
            method.setAccessible(oldAccessible);
        }
    }

    public static Method findMethod(Class<?> classInstance, String methodName, Class ... parameterClasses) throws NoSuchMethodException {
        if (classInstance != null) {
            try {
                if (!StringUtil.isEmpty(methodName)) {
                    return classInstance.getDeclaredMethod(methodName, parameterClasses);
                }
                throw new IllegalArgumentException("Method is undefined (null).");
            }
            catch (NoSuchMethodException e) {
                if (classInstance.getSuperclass() != null) {
                    return ObjectUtil.findMethod(classInstance.getSuperclass(), methodName, parameterClasses);
                }
                throw e;
            }
        }
        throw new IllegalArgumentException("Class is undefined (null).");
    }

    public static boolean equals(Object first, Object second) {
        if (first != null) {
            if (second != null) {
                return first.equals(second);
            }
            return false;
        }
        return second == null;
    }

    public static String toString(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public static int hashCode(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public static <T> Comparator<T> createEqualsComparator() {
        return (arg0, arg1) -> ObjectUtil.equals(arg0, arg1) ? 0 : 1;
    }

    public static Class<?> getClass(Object obj) {
        return obj != null ? obj.getClass() : null;
    }

    public static void waitForThreads(Thread[] threads) {
        if (threads != null) {
            for (Thread thread : threads) {
                while (thread.isAlive()) {
                    ObjectUtil.sleep(100);
                }
            }
        }
    }

    public static void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

