/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.java;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.key_project.util.java.WrapUtils;

public final class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String LATIN_ALPHABET_BIG = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LATIN_ALPHABET_SMALL = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase();
    public static final char[] ADDITIONAL_ALLOWED_FILE_NAME_SYSTEM_CHARACTERS = new char[]{'(', ')', '[', ']', '-', '+', '_', '$', ',', '%'};
    public static final String NUMERALS = "0123456789";
    public static final String WHITESPACE = " \n\r\t";

    private StringUtil() {
    }

    public static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static boolean isTrimmedEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static String trim(String text) {
        return text != null ? text.trim() : null;
    }

    public static String toLowerCase(String text) {
        return text != null ? text.toLowerCase() : null;
    }

    public static Comparator<String> createIgnoreCaseComparator() {
        return (o1, o2) -> {
            if (o1 != null && o2 != null) {
                return o1.compareToIgnoreCase((String)o2);
            }
            return o1 == null && o2 == null ? 0 : 1;
        };
    }

    public static String repeat(String text, int repetitions) {
        return text.repeat(repetitions);
    }

    public static boolean contains(String string, CharSequence substring) {
        return string != null && substring != null && string.contains(substring);
    }

    public static String wrapLines(String string, int length) {
        char[] c = string.toCharArray();
        WrapUtils.wrapLines(c, length);
        return new String(c);
    }

    public static String wrapLines(String string) {
        return StringUtil.wrapLines(string, 100);
    }

    public static String toSingleLinedString(String text) {
        return StringUtil.replaceAll(text, new char[]{'\n', '\r', '\t'}, ' ');
    }

    public static String replaceAll(String text, char[] toSearch, char toReplace) {
        if (text != null && toSearch != null) {
            Arrays.sort(toSearch);
            char[] signs = text.toCharArray();
            for (int i = 0; i < signs.length; ++i) {
                int index = Arrays.binarySearch(toSearch, signs[i]);
                if (index < 0) continue;
                signs[i] = toReplace;
            }
            return new String(signs);
        }
        return text;
    }

    public static boolean equalIgnoreWhiteSpace(String first, String second) {
        if (first != null) {
            if (second != null) {
                int firstIndex;
                char[] firstContent = first.toCharArray();
                char[] secondContent = second.toCharArray();
                int secondIndex = 0;
                for (firstIndex = 0; firstIndex < firstContent.length && StringUtil.contains(WHITESPACE, EMPTY_STRING + firstContent[firstIndex]); ++firstIndex) {
                }
                while (secondIndex < secondContent.length && StringUtil.contains(WHITESPACE, EMPTY_STRING + secondContent[secondIndex])) {
                    ++secondIndex;
                }
                boolean equal = true;
                while (equal && firstIndex < firstContent.length && secondIndex < secondContent.length) {
                    if (firstIndex < firstContent.length && secondIndex < secondContent.length) {
                        if (firstContent[firstIndex] != secondContent[secondIndex]) {
                            equal = false;
                        }
                    } else if (firstIndex < firstContent.length - 1 || secondIndex < secondContent.length - 1) {
                        equal = false;
                    }
                    ++firstIndex;
                    ++secondIndex;
                    while (firstIndex < firstContent.length && StringUtil.contains(WHITESPACE, EMPTY_STRING + firstContent[firstIndex])) {
                        ++firstIndex;
                    }
                    while (secondIndex < secondContent.length && StringUtil.contains(WHITESPACE, EMPTY_STRING + secondContent[secondIndex])) {
                        ++secondIndex;
                    }
                }
                return equal && firstIndex >= firstContent.length && secondIndex >= secondContent.length;
            }
            return false;
        }
        return second == null;
    }

    public static String fillString(String text, char leadingCharacter, int length) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        if (text != null) {
            if (text.length() > length) {
                throw new IllegalArgumentException(String.format("Text \"%s\" with length %d is longer as %d.", text, text.length(), length));
            }
            for (int i = 0; i < length - text.length(); ++i) {
                sb.append(leadingCharacter);
            }
            sb.append(text);
        } else {
            for (int i = 0; i < length; ++i) {
                sb.append(leadingCharacter);
            }
        }
        return sb.toString();
    }

    public static String trimRight(String text) {
        if (text != null) {
            int newLength;
            char[] content = text.toCharArray();
            for (newLength = content.length; newLength >= 1 && Character.isWhitespace(content[newLength - 1]); --newLength) {
            }
            return newLength == text.length() ? text : text.substring(0, newLength);
        }
        return null;
    }

    public static String chop(String text, int maxLength) {
        if (text != null && text.length() > maxLength) {
            if (maxLength <= 0) {
                return EMPTY_STRING;
            }
            if (maxLength == 1) {
                return ".";
            }
            if (maxLength == 2) {
                return "..";
            }
            if (maxLength == 3) {
                return "...";
            }
            return text.substring(0, maxLength - 3) + "...";
        }
        return text;
    }

    public static boolean startsWith(Object obj, String prefix) {
        return obj instanceof String && prefix != null && ((String)obj).startsWith(prefix);
    }

    public static boolean isNumber(String val) {
        try {
            Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Nonnull
    public static String trim(@Nonnull String text, @Nonnull Predicate<Character> predicate) {
        int first;
        int last = text.length() - 1;
        char[] value = text.toCharArray();
        for (first = 0; first < last && predicate.test(Character.valueOf(value[first])); ++first) {
        }
        while (first <= last && predicate.test(Character.valueOf(value[last]))) {
            --last;
        }
        return first < last ? new String(Arrays.copyOfRange(value, first, last + 1)) : EMPTY_STRING;
    }

    @Nonnull
    public static String trim(String text, char c) {
        return StringUtil.trim(text, (Character it) -> it.charValue() == c);
    }

    @Nonnull
    public static String trim(String text, String chars) {
        return StringUtil.trim(text, (Character it) -> chars.indexOf(it.charValue()) >= 0);
    }

    static {
        Arrays.sort(ADDITIONAL_ALLOWED_FILE_NAME_SYSTEM_CHARACTERS);
    }
}

