/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.java;

import java.util.Map;
import org.key_project.util.java.StringUtil;

public final class XMLUtil {
    public static final String ATTRIBUTE_ENCODING = "encoding";
    public static final String LEADING_WHITE_SPACE_PER_LEVEL = "   ";

    private XMLUtil() {
    }

    public static String replaceTags(String text, ITagReplacer replacer) {
        if (text != null && replacer != null) {
            StringBuffer sb = new StringBuffer();
            char[] signs = text.toCharArray();
            boolean inTag = false;
            boolean inAttribute = false;
            StringBuffer tagSB = null;
            for (char sign : signs) {
                if (!inTag) {
                    if (sign == '<') {
                        inTag = true;
                        tagSB = new StringBuffer();
                        tagSB.append(sign);
                        continue;
                    }
                    sb.append(sign);
                    continue;
                }
                tagSB.append(sign);
                if (sign == '>' && !inAttribute) {
                    inTag = false;
                    inAttribute = false;
                    String replacement = replacer.replaceTag(tagSB.toString());
                    if (replacement == null) continue;
                    sb.append(replacement);
                    continue;
                }
                if (sign != '\'' && sign != '\"') continue;
                inAttribute = !inAttribute;
            }
            return sb.toString();
        }
        return null;
    }

    public static String removeTags(String text) {
        if (text != null) {
            StringBuffer sb = new StringBuffer();
            char[] signs = text.toCharArray();
            boolean inTag = false;
            boolean inAttribute = false;
            for (char sign : signs) {
                if (!inTag) {
                    if (sign == '<') {
                        inTag = true;
                        continue;
                    }
                    sb.append(sign);
                    continue;
                }
                if (sign == '>' && !inAttribute) {
                    inTag = false;
                    inAttribute = false;
                    continue;
                }
                if (sign != '\'' && sign != '\"') continue;
                inAttribute = !inAttribute;
            }
            return sb.toString();
        }
        return null;
    }

    public static String encodeText(String text) {
        if (text != null) {
            char[] signs = text.toCharArray();
            StringBuffer sb = new StringBuffer();
            block7: for (char sign : signs) {
                switch (sign) {
                    case '\"': {
                        sb.append("&quot;");
                        continue block7;
                    }
                    case '&': {
                        sb.append("&amp;");
                        continue block7;
                    }
                    case '\'': {
                        sb.append("&apos;");
                        continue block7;
                    }
                    case '<': {
                        sb.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block7;
                    }
                    default: {
                        sb.append(sign);
                    }
                }
            }
            return sb.toString();
        }
        return null;
    }

    public static boolean isEntityNameCharacter(char character) {
        return '#' == character || "ABCDEFGHIJKLMNOPQRSTUVWXYZ".contains("" + character) || StringUtil.LATIN_ALPHABET_SMALL.contains("" + character) || "0123456789".contains("" + character);
    }

    public static void appendEmptyTag(int level, String tagName, Map<String, String> attributeValues, StringBuffer sb) {
        XMLUtil.appendWhiteSpace(level, sb);
        sb.append("<");
        sb.append(tagName);
        for (Map.Entry<String, String> entry : attributeValues.entrySet()) {
            XMLUtil.appendAttribute(entry.getKey(), entry.getValue(), sb);
        }
        sb.append("/>");
        XMLUtil.appendNewLine(sb);
    }

    public static void appendStartTag(int level, String tagName, Map<String, String> attributeValues, StringBuffer sb) {
        XMLUtil.appendWhiteSpace(level, sb);
        sb.append("<");
        sb.append(tagName);
        if (attributeValues != null) {
            for (Map.Entry<String, String> entry : attributeValues.entrySet()) {
                XMLUtil.appendAttribute(entry.getKey(), entry.getValue(), sb);
            }
        }
        sb.append(">");
        XMLUtil.appendNewLine(sb);
    }

    public static void appendEndTag(int level, String tagName, StringBuffer sb) {
        XMLUtil.appendWhiteSpace(level, sb);
        sb.append("</");
        sb.append(tagName);
        sb.append(">");
        XMLUtil.appendNewLine(sb);
    }

    public static void appendWhiteSpace(int level, StringBuffer sb) {
        for (int i = 0; i < level; ++i) {
            sb.append(LEADING_WHITE_SPACE_PER_LEVEL);
        }
    }

    public static void appendAttribute(String attributeName, String value, StringBuffer sb) {
        if (attributeName != null && value != null) {
            sb.append(" ");
            sb.append(attributeName);
            sb.append("=\"");
            sb.append(XMLUtil.encodeText(value));
            sb.append("\"");
        }
    }

    public static void appendXmlHeader(String encoding, StringBuffer sb) {
        sb.append("<?xml version=\"1.0\"");
        XMLUtil.appendAttribute(ATTRIBUTE_ENCODING, encoding, sb);
        sb.append("?>");
        XMLUtil.appendNewLine(sb);
    }

    public static void appendNewLine(StringBuffer sb) {
        sb.append(StringUtil.NEW_LINE);
    }

    public static class HTMLRendererReplacer
    implements ITagReplacer {
        @Override
        public String replaceTag(String tag) {
            if (tag.startsWith("<br")) {
                return StringUtil.NEW_LINE.toString();
            }
            if (tag.startsWith("<li")) {
                return StringUtil.NEW_LINE + "- ";
            }
            if (tag.startsWith("</ol")) {
                return StringUtil.NEW_LINE.toString();
            }
            if (tag.startsWith("</ul")) {
                return StringUtil.NEW_LINE.toString();
            }
            if (tag.startsWith("<center")) {
                return StringUtil.NEW_LINE.toString();
            }
            if (tag.startsWith("</center")) {
                return StringUtil.NEW_LINE.toString();
            }
            return null;
        }
    }

    public static interface ITagReplacer {
        public String replaceTag(String var1);
    }
}

