/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.util.lookup;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.key_project.util.lookup.Inject;
import org.key_project.util.lookup.InjectionException;
import org.key_project.util.lookup.LookupListener;

public class Lookup {
    public static Lookup DEFAULT = new Lookup();
    private final Lookup parent;
    private final HashMap<Class<?>, LinkedList<?>> serviceMap = new HashMap();
    private final List<WeakReference<Lookup>> children = new ArrayList<WeakReference<Lookup>>();
    private HashMap<Class<?>, List<LookupListener>> propertyListener = new HashMap();

    public Lookup() {
        this(null);
    }

    public Lookup(Lookup parent) {
        this.parent = parent;
        if (parent != null) {
            parent.children.add(new WeakReference<Lookup>(this));
        }
    }

    public <T> Collection<T> lookupAll(Class<T> service) {
        ArrayList<T> t = new ArrayList<T>(this.getList(service));
        if (this.parent != null) {
            t.addAll(this.parent.lookupAll(service));
        }
        return t;
    }

    public <T> T get(Class<T> service) {
        List<T> t = this.getList(service);
        if (t.isEmpty()) {
            if (this.parent != null) {
                return this.parent.get(service);
            }
            throw new IllegalStateException("Service $service not registered");
        }
        return t.get(0);
    }

    public <T> void register(T obj, Class<T> service) {
        List<T> list = this.getList(service);
        list.add(0, obj);
        this.firePropertyChange(service);
    }

    public <T> void deregister(T obj, Class<T> service) {
        boolean b = this.getList(service).remove(obj);
        if (b) {
            this.firePropertyChange(service);
        }
        if (this.parent != null) {
            this.parent.deregister(obj, service);
        }
    }

    public <T> void deregister(Class<T> service) {
        this.getList(service).clear();
        this.firePropertyChange(service);
        if (this.parent != null) {
            this.parent.deregister(service);
        }
    }

    public void dispose() {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
    }

    public <T> List<LookupListener> getListeners(Class<?> name) {
        return this.propertyListener.computeIfAbsent(name, a -> new LinkedList());
    }

    public void addChangeListener(LookupListener listener) {
        this.addChangeListener(ALL.class, listener);
    }

    public <T> void addChangeListener(Class<T> name, LookupListener listener) {
        this.getListeners(name).add(listener);
    }

    public <T> void removeChangeListener(Class<?> name, LookupListener listener) {
        this.getListeners(name).remove(listener);
    }

    public void removeChangeListener(LookupListener listener) {
        this.removeChangeListener(ALL.class, listener);
    }

    protected void firePropertyChange(Class<?> name) {
        this.getListeners(name).forEach(it -> it.update(name, this));
        this.children.forEach(it -> {
            Lookup child = (Lookup)it.get();
            if (child != null) {
                child.firePropertyChange(name);
            }
        });
        this.getListeners(ALL.class).forEach(it -> it.update(name, this));
        this.children.forEach(it -> {
            Lookup child = (Lookup)it.get();
            if (child != null) {
                child.firePropertyChange(ALL.class);
            }
        });
    }

    public <T> void register(T o) {
        this.register(o, o.getClass());
    }

    private <T> List<T> getList(Class<T> service) {
        return this.serviceMap.computeIfAbsent(service, k -> new LinkedList());
    }

    public <T> T createInstance(Class<T> clazz) throws InjectionException {
        for (Constructor<?> ctor : clazz.getConstructors()) {
            Object instance;
            if (ctor.getAnnotation(Inject.class) == null || (instance = this.tryToInject(ctor)) == null) continue;
            return (T)instance;
        }
        return null;
    }

    protected <T> T tryToInject(Constructor<T> ctor) throws InjectionException {
        List services = Arrays.stream(ctor.getParameterTypes()).map(this::get).collect(Collectors.toList());
        if (services.stream().allMatch(Objects::nonNull)) {
            try {
                return ctor.newInstance(services.toArray());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new InjectionException(e);
            }
        }
        return null;
    }

    public void inject(Object instance) throws InjectionException {
        Class<?> clazz = instance.getClass();
        for (Method setter : clazz.getMethods()) {
            if (setter.getAnnotation(Inject.class) == null) continue;
            this.inject(instance, setter);
        }
    }

    protected void inject(Object instance, Method setter) throws InjectionException {
        if (setter.getParameterCount() != 1) {
            throw new IllegalStateException();
        }
        Class<?> pClazz = setter.getParameters()[0].getType();
        Object o = this.get(pClazz);
        if (o == null) {
            throw new IllegalStateException("Implementation for X not registered.");
        }
        try {
            setter.invoke(instance, o);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InjectionException(e);
        }
    }

    private static class ALL {
        private ALL() {
        }
    }
}

