/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import java.util.List;
import recoder.ModelException;
import recoder.abstraction.AnnotationUse;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.Type;
import recoder.convenience.Naming;
import recoder.service.ProgramModelInfo;

public abstract class ImplicitEnumMethod
implements Method {
    protected ProgramModelInfo service;
    protected ClassType ownerClass;
    protected String name;

    public ImplicitEnumMethod(ClassType ownerClass) {
        if (ownerClass == null) {
            throw new NullPointerException();
        }
        this.ownerClass = ownerClass;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public boolean isVarArgMethod() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isStrictFp() {
        return false;
    }

    @Override
    public ClassType getContainingClassType() {
        return this.ownerClass;
    }

    @Override
    public List<? extends AnnotationUse> getAnnotations() {
        return null;
    }

    @Override
    public String getFullName() {
        return Naming.getFullName(this);
    }

    @Override
    public ProgramModelInfo getProgramModelInfo() {
        return this.service;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo pmi) {
        this.service = pmi;
    }

    @Override
    public void validate() throws ModelException {
    }

    public List<ClassType> getTypes() {
        return null;
    }

    @Override
    public Package getPackage() {
        return this.service.getPackage(this);
    }

    @Override
    public ClassTypeContainer getContainer() {
        return this.getContainingClassType();
    }

    @Override
    public List<ClassType> getExceptions() {
        return this.service.getExceptions(this);
    }

    @Override
    public Type getReturnType() {
        return this.service.getReturnType(this);
    }

    @Override
    public List<Type> getSignature() {
        return this.service.getSignature(this);
    }
}

