/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import java.util.ArrayList;
import java.util.List;
import recoder.ModelException;
import recoder.abstraction.AnnotationUse;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.Type;
import recoder.abstraction.TypeParameter;
import recoder.service.ProgramModelInfo;

public class IntersectionType
implements ClassType {
    private final List<Type> types;
    private ProgramModelInfo pmi;

    public IntersectionType(List<Type> types, ProgramModelInfo pmi) {
        this.types = types;
        this.pmi = pmi;
    }

    @Override
    public String getFullName() {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < this.types.size(); ++i) {
            if (i != 0) {
                res.append(" & ");
            }
            res.append(this.types.get(i).getFullName());
        }
        return res.toString();
    }

    @Override
    public ProgramModelInfo getProgramModelInfo() {
        return this.pmi;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo pmi) {
        this.pmi = pmi;
    }

    @Override
    public String getName() {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < this.types.size(); ++i) {
            if (i != 0) {
                res.append(" & ");
            }
            res.append(this.types.get(i).getName());
        }
        return res.toString();
    }

    @Override
    public void validate() throws ModelException {
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isOrdinaryInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnumType() {
        return false;
    }

    @Override
    public boolean isOrdinaryClass() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public List<ClassType> getSupertypes() {
        ArrayList<ClassType> res = new ArrayList<ClassType>();
        boolean addedObject = false;
        for (int i = 0; i < this.types.size(); ++i) {
            Type t = this.types.get(i);
            if (t instanceof ClassType) {
                res.add((ClassType)t);
                if (t.getFullName().equals("java.lang.Object")) {
                    addedObject = true;
                }
            }
            if (!(t instanceof ArrayType) || addedObject) continue;
            res.add(this.pmi.getServiceConfiguration().getNameInfo().getJavaLangObject());
            addedObject = true;
        }
        return res;
    }

    @Override
    public List<ClassType> getAllSupertypes() {
        return this.pmi.getAllSubtypes(this);
    }

    @Override
    public List<? extends Field> getFields() {
        return null;
    }

    @Override
    public List<Field> getAllFields() {
        return this.pmi.getAllFields(this);
    }

    @Override
    public List<Method> getMethods() {
        return null;
    }

    @Override
    public List<Method> getAllMethods() {
        return this.pmi.getAllMethods(this);
    }

    public List<Constructor> getConstructors() {
        return null;
    }

    @Override
    public List<ClassType> getAllTypes() {
        return null;
    }

    @Override
    public List<? extends TypeParameter> getTypeParameters() {
        return null;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isStrictFp() {
        return false;
    }

    @Override
    public ClassType getContainingClassType() {
        return null;
    }

    @Override
    public List<? extends AnnotationUse> getAnnotations() {
        return null;
    }

    @Override
    public List<? extends ClassType> getTypes() {
        return null;
    }

    @Override
    public Package getPackage() {
        return null;
    }

    @Override
    public ClassTypeContainer getContainer() {
        return null;
    }
}

