/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import recoder.NamedModelElement;
import recoder.bytecode.AccessFlags;
import recoder.convenience.Format;
import recoder.service.ProgramModelInfo;
import recoder.util.Order;

public interface ProgramModelElement
extends NamedModelElement,
AccessFlags {
    public static final Order LEXICAL_ORDER = new LexicalOrder();

    public String getFullName();

    public ProgramModelInfo getProgramModelInfo();

    public void setProgramModelInfo(ProgramModelInfo var1);

    public static class LexicalOrder
    implements Order {
        public final int hashCode(Object x) {
            if (x == null) {
                return 0;
            }
            String name = Format.toString("%N|%p|%u", (ProgramModelElement)x);
            if (name == null) {
                return 0;
            }
            return name.hashCode();
        }

        @Override
        public final boolean isComparable(Object x, Object y) {
            return true;
        }

        private int diff(ProgramModelElement n1, ProgramModelElement n2) {
            String s2;
            if (n1 == n2) {
                return 0;
            }
            String s1 = n1 == null ? "" : Format.toString("%N", n1);
            int res = this.diff(s1, s2 = n2 == null ? "" : Format.toString("%N", n2));
            if (res == 0) {
                s1 = Format.toString("%p|%u", n1);
                s2 = Format.toString("%p|%u", n2);
                res = this.diff(s1, s2);
            }
            return res;
        }

        private int diff(String s1, String s2) {
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            int len1 = s1.length();
            int len2 = s2.length();
            int m = Math.min(len1, len2);
            for (int i = 0; i < m; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i))) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }

        @Override
        public final boolean equals(Object x, Object y) {
            return this.diff((ProgramModelElement)x, (ProgramModelElement)y) == 0;
        }

        @Override
        public final boolean less(Object x, Object y) {
            return this.diff((ProgramModelElement)x, (ProgramModelElement)y) < 0;
        }

        @Override
        public final boolean greater(Object x, Object y) {
            return this.diff((ProgramModelElement)x, (ProgramModelElement)y) > 0;
        }

        @Override
        public final boolean lessOrEquals(Object x, Object y) {
            return this.diff((ProgramModelElement)x, (ProgramModelElement)y) <= 0;
        }

        @Override
        public final boolean greaterOrEquals(Object x, Object y) {
            return this.diff((ProgramModelElement)x, (ProgramModelElement)y) >= 0;
        }
    }
}

