/*
 * Decompiled with CFR 0.152.
 */
package recoder.bytecode;

import java.util.List;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.Type;
import recoder.bytecode.AnnotationUseInfo;
import recoder.bytecode.ClassFile;
import recoder.bytecode.MemberInfo;
import recoder.bytecode.TypeArgumentInfo;
import recoder.bytecode.TypeParameterInfo;
import recoder.convenience.Naming;

public class MethodInfo
extends MemberInfo
implements Method {
    protected String[] paramtypes;
    protected String returntype;
    protected String[] exceptions;
    protected AnnotationUseInfo[][] paramAnnotations;
    protected List<TypeArgumentInfo>[] paramTypeArgs;
    protected List<TypeParameterInfo> typeParms;

    public MethodInfo(int accessFlags, String returntype, String name, String[] paramtypes, String[] exceptions, ClassFile cf) {
        super(accessFlags, name, cf);
        int i;
        if (returntype != null) {
            this.returntype = returntype.intern();
        }
        this.paramtypes = paramtypes;
        for (i = 0; i < paramtypes.length; ++i) {
            paramtypes[i] = paramtypes[i].intern();
        }
        this.exceptions = exceptions;
        if (exceptions != null) {
            for (i = 0; i < exceptions.length; ++i) {
                exceptions[i] = exceptions[i].intern();
            }
        }
    }

    public final String[] getParameterTypeNames() {
        return this.paramtypes;
    }

    public final AnnotationUseInfo[] getAnnotationsForParam(int paramNum) {
        if (this.paramAnnotations == null) {
            return null;
        }
        return this.paramAnnotations[paramNum];
    }

    public final List<TypeArgumentInfo> getTypeArgumentsForParam(int paramNum) {
        if (this.paramTypeArgs == null) {
            return null;
        }
        return this.paramTypeArgs[paramNum];
    }

    public final List<TypeArgumentInfo> getTypeArgumentsForReturnType() {
        if (this.paramTypeArgs == null) {
            return null;
        }
        return this.paramTypeArgs[this.paramTypeArgs.length - 1];
    }

    public final String[] getExceptionsInfo() {
        return this.exceptions;
    }

    @Override
    public final String getTypeName() {
        return this.returntype;
    }

    @Override
    public Type getReturnType() {
        return this.service.getReturnType(this);
    }

    @Override
    public List<Type> getSignature() {
        return this.service.getSignature(this);
    }

    @Override
    public List<ClassType> getExceptions() {
        return this.service.getExceptions(this);
    }

    @Override
    public ClassTypeContainer getContainer() {
        return this.getContainingClassType();
    }

    @Override
    public Package getPackage() {
        return this.service.getPackage(this);
    }

    @Override
    public List<? extends ClassType> getTypes() {
        return this.service.getTypes(this);
    }

    @Override
    public String getFullName() {
        return Naming.getFullName(this);
    }

    @Override
    public boolean isVarArgMethod() {
        return (this.accessFlags & 0x80) != 0;
    }

    public List<TypeParameterInfo> getTypeParameters() {
        return this.typeParms;
    }
}

