/*
 * Decompiled with CFR 0.152.
 */
package recoder.bytecode;

import java.util.List;
import recoder.abstraction.TypeArgument;
import recoder.bytecode.ByteCodeElement;
import recoder.bytecode.ClassFile;
import recoder.bytecode.MethodInfo;

public class TypeArgumentInfo
implements TypeArgument {
    final TypeArgument.WildcardMode wildcardMode;
    final String typeName;
    final List<? extends TypeArgument> typeArgs;
    final boolean isTypeVariable;
    ByteCodeElement parent;

    public TypeArgumentInfo(TypeArgument.WildcardMode wildcardMode, String typeName, List<? extends TypeArgument> typeArgs, ByteCodeElement parent, boolean isTypeVariable) {
        if (typeName == null && wildcardMode != TypeArgument.WildcardMode.Any || wildcardMode == null || parent == null) {
            throw new NullPointerException();
        }
        this.wildcardMode = wildcardMode;
        this.typeName = typeName;
        this.typeArgs = typeArgs;
        this.isTypeVariable = isTypeVariable;
        this.parent = parent;
    }

    @Override
    public TypeArgument.WildcardMode getWildcardMode() {
        return this.wildcardMode;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public List<? extends TypeArgument> getTypeArguments() {
        return this.typeArgs;
    }

    public boolean isTypeVariable() {
        return this.isTypeVariable;
    }

    public ClassFile getContainingClassFile() {
        if (this.parent instanceof ClassFile) {
            return (ClassFile)this.parent;
        }
        return (ClassFile)((MethodInfo)this.parent).getContainingClassType();
    }

    public MethodInfo getContainingMethodInfo() {
        if (this.parent instanceof MethodInfo) {
            return (MethodInfo)this.parent;
        }
        return null;
    }
}

