/*
 * Decompiled with CFR 0.152.
 */
package recoder.convenience;

import java.util.List;
import recoder.ModelElement;
import recoder.NamedModelElement;
import recoder.abstraction.Method;
import recoder.abstraction.ProgramModelElement;
import recoder.convenience.Naming;
import recoder.java.CompilationUnit;
import recoder.java.Identifier;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.reference.ReferencePrefix;
import recoder.kit.UnitKit;
import recoder.util.Debug;

public class Format {
    private Format() {
    }

    public static String toString(String formatText, ModelElement e) {
        Debug.assertNonnull(formatText);
        StringBuffer res = new StringBuffer();
        int len = formatText.length();
        block14: for (int i = 0; i < len; ++i) {
            char c = formatText.charAt(i);
            if (c != '%' || i == len - 1) {
                res.append(c);
                continue;
            }
            int columns = 1;
            if ((c = formatText.charAt(++i)) >= '0' && c <= '9' && i < len - 1) {
                columns = Math.max(1, c - 48);
                c = formatText.charAt(++i);
            }
            switch (c) {
                case 'n': {
                    if (e instanceof NamedModelElement) {
                        res.append(((NamedModelElement)e).getName());
                        continue block14;
                    }
                    if (e instanceof Identifier) {
                        res.append(((Identifier)e).getText());
                        continue block14;
                    }
                    if (!(e instanceof CompilationUnit)) continue block14;
                    res.append(((CompilationUnit)e).getPrimaryTypeDeclaration().getName());
                    continue block14;
                }
                case 'N': {
                    if (e instanceof NamedModelElement) {
                        if (e instanceof ProgramModelElement) {
                            res.append(((ProgramModelElement)e).getFullName());
                            if (!(e instanceof Method)) continue block14;
                            res.append(Format.toString("%N", ((Method)e).getSignature()));
                            continue block14;
                        }
                        if (e instanceof ReferencePrefix) {
                            res.append(Naming.toPathName((ReferencePrefix)e));
                            continue block14;
                        }
                        res.append(((NamedModelElement)e).getName());
                        continue block14;
                    }
                    if (e instanceof Identifier) {
                        res.append(((Identifier)e).getText());
                        continue block14;
                    }
                    if (!(e instanceof CompilationUnit)) continue block14;
                    res.append(Naming.toCanonicalName((CompilationUnit)e));
                    continue block14;
                }
                case 'm': {
                    if (e instanceof NamedModelElement) {
                        res.append(((NamedModelElement)e).getName());
                        if (!(e instanceof Method)) continue block14;
                        res.append(Format.toString("%N", ((Method)e).getSignature()));
                        continue block14;
                    }
                    if (e instanceof Identifier) {
                        res.append(((Identifier)e).getText());
                        continue block14;
                    }
                    if (!(e instanceof CompilationUnit)) continue block14;
                    res.append(((CompilationUnit)e).getPrimaryTypeDeclaration().getName());
                    continue block14;
                }
                case 's': {
                    if (!(e instanceof SourceElement)) continue block14;
                    res.append(((SourceElement)((Object)e)).toSource().trim());
                    continue block14;
                }
                case 'c': {
                    if (e == null) {
                        res.append("null");
                        continue block14;
                    }
                    String name = e.getClass().getName();
                    res.append(name.substring(name.lastIndexOf(46) + 1));
                    continue block14;
                }
                case 'C': {
                    if (e == null) {
                        res.append("null");
                        continue block14;
                    }
                    res.append(e.getClass().getName());
                    continue block14;
                }
                case 'i': {
                    if (e == null) continue block14;
                    int id = System.identityHashCode(e);
                    if (id < 0) {
                        res.append(Long.toString((long)(id & Integer.MAX_VALUE) | 0x80000000L, 16));
                        continue block14;
                    }
                    res.append(Integer.toString(id, 16));
                    continue block14;
                }
                case 'p': {
                    if (!(e instanceof SourceElement)) continue block14;
                    SourceElement se = (SourceElement)((Object)e);
                    if ((se = se.getFirstElement()) == null) continue block14;
                    Format.append(se.getStartPosition(), columns, res);
                    continue block14;
                }
                case 'P': {
                    SourceElement se2;
                    SourceElement se;
                    if (!(e instanceof SourceElement) || (se2 = (se = (SourceElement)((Object)e)).getFirstElement()) == null) continue block14;
                    Format.append(se2.getStartPosition(), columns, res);
                    res.append('-');
                    se2 = se.getLastElement();
                    Format.append(se2.getEndPosition(), columns, res);
                    continue block14;
                }
                case 'r': {
                    if (!(e instanceof SourceElement)) continue block14;
                    SourceElement se = (SourceElement)((Object)e);
                    if ((se = se.getFirstElement()) == null) continue block14;
                    Format.append(se.getRelativePosition(), columns, res);
                    continue block14;
                }
                case 'u': {
                    CompilationUnit cu;
                    if (!(e instanceof ProgramElement) || (cu = UnitKit.getCompilationUnit((ProgramElement)e)) == null) continue block14;
                    res.append(Naming.toCanonicalName(cu));
                    continue block14;
                }
                case 'f': {
                    CompilationUnit cu;
                    if (!(e instanceof ProgramElement) || (cu = UnitKit.getCompilationUnit((ProgramElement)e)) == null) continue block14;
                    res.append(cu.getDataLocation());
                    continue block14;
                }
                default: {
                    res.append('%').append(c);
                }
            }
        }
        return res.toString();
    }

    private static void append(SourceElement.Position pos, int columns, StringBuffer buf) {
        int j;
        int k = 1;
        int i = columns;
        while (i > 1) {
            --i;
            k *= 10;
        }
        int line = -1;
        int col = -1;
        if (pos != SourceElement.Position.UNDEFINED) {
            line = pos.getLine();
            col = pos.getColumn();
        }
        for (j = Math.max(1, line); j < k; j *= 10) {
            buf.append(' ');
        }
        if (line == -1) {
            buf.append('?');
        } else {
            buf.append(line);
        }
        buf.append('/');
        for (j = Math.max(1, col); j < k; j *= 10) {
            buf.append(' ');
        }
        if (col == -1) {
            buf.append('?');
        } else {
            buf.append(col);
        }
    }

    public static String toString(String formatText, List<? extends ModelElement> l) {
        return Format.toString(formatText, "(", ", ", ")", l);
    }

    public static String toString(String formatText, String header, String separator, String footer, List<? extends ModelElement> l) {
        if (l == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(64);
        sb.append(header);
        int s = l.size();
        if (s > 0) {
            sb.append(Format.toString(formatText, l.get(0)));
            for (int i = 1; i < s; ++i) {
                sb.append(separator);
                sb.append(Format.toString(formatText, l.get(i)));
            }
        }
        sb.append(footer);
        return sb.toString();
    }

    public static String toString(ProgramElement se) {
        return Format.toString("\"%s\" @%p [%f]", se);
    }

    public static String toString(List<? extends ModelElement> l) {
        return Format.toString("\"%s\" @%p", l);
    }
}

