/*
 * Decompiled with CFR 0.152.
 */
package recoder.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import recoder.io.DataLocation;

public class ArchiveDataLocation
implements DataLocation {
    public static final String LOCATION_TYPE_ARCHIVE = "ARCHIVE";
    ZipFile archiveFile;
    String itemName;

    public ArchiveDataLocation(ZipFile archive, String itemname) {
        this.archiveFile = archive;
        this.itemName = itemname;
    }

    public ArchiveDataLocation(String archivename, String itemname) throws IOException {
        this(new ZipFile(archivename), itemname);
    }

    @Override
    public String getType() {
        return LOCATION_TYPE_ARCHIVE;
    }

    public ZipFile getFile() {
        return this.archiveFile;
    }

    @Override
    public String toString() {
        return this.getType() + ":" + this.archiveFile.getName() + "?" + this.itemName;
    }

    @Override
    public boolean hasReaderSupport() {
        return true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        BufferedInputStream result = null;
        ZipEntry ze = this.archiveFile.getEntry(this.itemName);
        result = new BufferedInputStream(this.archiveFile.getInputStream(ze));
        return result;
    }

    @Override
    public void inputStreamClosed() {
    }

    @Override
    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    @Override
    public void readerClosed() {
        this.inputStreamClosed();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean hasWriterSupport() {
        return false;
    }

    @Override
    public OutputStream getOutputStream() {
        return null;
    }

    @Override
    public void outputStreamClosed() {
    }

    @Override
    public Writer getWriter() {
        return null;
    }

    @Override
    public void writerClosed() {
    }

    public boolean equals(Object ob) {
        if (ob instanceof ArchiveDataLocation) {
            return this.archiveFile.equals(((ArchiveDataLocation)ob).archiveFile);
        }
        return false;
    }

    public int hashCode() {
        return this.archiveFile.hashCode();
    }
}

