/*
 * Decompiled with CFR 0.152.
 */
package recoder.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import recoder.io.DataLocation;

public class DataFileLocation
implements DataLocation {
    public static final String LOCATION_TYPE_FILE = "FILE";
    File file;
    String canonicalPath;

    public DataFileLocation(File f) {
        this.setFile(f);
    }

    public DataFileLocation(String filename) {
        this.setFile(new File(filename));
    }

    @Override
    public String getType() {
        return LOCATION_TYPE_FILE;
    }

    public File getFile() {
        return this.file;
    }

    private void setFile(File f) {
        this.file = f;
        try {
            this.canonicalPath = this.file.getCanonicalPath();
        }
        catch (IOException ioe) {
            this.canonicalPath = this.file.getAbsolutePath();
        }
    }

    @Override
    public String toString() {
        return this.getType() + ":" + this.file.getPath();
    }

    @Override
    public boolean hasReaderSupport() {
        return true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public void inputStreamClosed() {
    }

    @Override
    public Reader getReader() throws IOException {
        return new FileReader(this.file);
    }

    @Override
    public void readerClosed() {
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean hasWriterSupport() {
        return true;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public void outputStreamClosed() {
    }

    @Override
    public Writer getWriter() throws IOException {
        return new FileWriter(this.file);
    }

    @Override
    public void writerClosed() {
    }

    public boolean equals(Object ob) {
        if (ob instanceof DataFileLocation) {
            return this.canonicalPath.equals(((DataFileLocation)ob).canonicalPath);
        }
        return false;
    }

    public int hashCode() {
        return this.canonicalPath.hashCode();
    }
}

