/*
 * Decompiled with CFR 0.152.
 */
package recoder.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import recoder.DefaultServiceConfiguration;
import recoder.ParserException;
import recoder.ProgramFactory;
import recoder.ServiceConfiguration;
import recoder.convenience.TreeWalker;
import recoder.io.ProjectSettings;
import recoder.java.Comment;
import recoder.java.CompilationUnit;
import recoder.java.DocComment;
import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.Import;
import recoder.java.JavaSourceElement;
import recoder.java.LoopInitializer;
import recoder.java.NonTerminalProgramElement;
import recoder.java.PackageSpecification;
import recoder.java.PrettyPrinter;
import recoder.java.ProgramElement;
import recoder.java.SingleLineComment;
import recoder.java.SourceElement;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.declaration.AnnotationDeclaration;
import recoder.java.declaration.AnnotationPropertyDeclaration;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ClassInitializer;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.Extends;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.Implements;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.LocalVariableDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.declaration.Throws;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.declaration.modifier.Abstract;
import recoder.java.declaration.modifier.Final;
import recoder.java.declaration.modifier.Native;
import recoder.java.declaration.modifier.Private;
import recoder.java.declaration.modifier.Protected;
import recoder.java.declaration.modifier.Public;
import recoder.java.declaration.modifier.Static;
import recoder.java.declaration.modifier.StrictFp;
import recoder.java.declaration.modifier.Synchronized;
import recoder.java.declaration.modifier.Transient;
import recoder.java.declaration.modifier.VisibilityModifier;
import recoder.java.declaration.modifier.Volatile;
import recoder.java.expression.ArrayInitializer;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.expression.literal.BooleanLiteral;
import recoder.java.expression.literal.CharLiteral;
import recoder.java.expression.literal.DoubleLiteral;
import recoder.java.expression.literal.FloatLiteral;
import recoder.java.expression.literal.IntLiteral;
import recoder.java.expression.literal.LongLiteral;
import recoder.java.expression.literal.NullLiteral;
import recoder.java.expression.literal.StringLiteral;
import recoder.java.expression.operator.BinaryAnd;
import recoder.java.expression.operator.BinaryAndAssignment;
import recoder.java.expression.operator.BinaryNot;
import recoder.java.expression.operator.BinaryOr;
import recoder.java.expression.operator.BinaryOrAssignment;
import recoder.java.expression.operator.BinaryXOr;
import recoder.java.expression.operator.BinaryXOrAssignment;
import recoder.java.expression.operator.Conditional;
import recoder.java.expression.operator.CopyAssignment;
import recoder.java.expression.operator.Divide;
import recoder.java.expression.operator.DivideAssignment;
import recoder.java.expression.operator.Equals;
import recoder.java.expression.operator.GreaterOrEquals;
import recoder.java.expression.operator.GreaterThan;
import recoder.java.expression.operator.Instanceof;
import recoder.java.expression.operator.LessOrEquals;
import recoder.java.expression.operator.LessThan;
import recoder.java.expression.operator.LogicalAnd;
import recoder.java.expression.operator.LogicalNot;
import recoder.java.expression.operator.LogicalOr;
import recoder.java.expression.operator.Minus;
import recoder.java.expression.operator.MinusAssignment;
import recoder.java.expression.operator.Modulo;
import recoder.java.expression.operator.ModuloAssignment;
import recoder.java.expression.operator.Negative;
import recoder.java.expression.operator.New;
import recoder.java.expression.operator.NewArray;
import recoder.java.expression.operator.NotEquals;
import recoder.java.expression.operator.Plus;
import recoder.java.expression.operator.PlusAssignment;
import recoder.java.expression.operator.Positive;
import recoder.java.expression.operator.PostDecrement;
import recoder.java.expression.operator.PostIncrement;
import recoder.java.expression.operator.PreDecrement;
import recoder.java.expression.operator.PreIncrement;
import recoder.java.expression.operator.ShiftLeft;
import recoder.java.expression.operator.ShiftLeftAssignment;
import recoder.java.expression.operator.ShiftRight;
import recoder.java.expression.operator.ShiftRightAssignment;
import recoder.java.expression.operator.Times;
import recoder.java.expression.operator.TimesAssignment;
import recoder.java.expression.operator.TypeCast;
import recoder.java.expression.operator.UnsignedShiftRight;
import recoder.java.expression.operator.UnsignedShiftRightAssignment;
import recoder.java.reference.AnnotationPropertyReference;
import recoder.java.reference.ArrayLengthReference;
import recoder.java.reference.ArrayReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MetaClassReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.SuperConstructorReference;
import recoder.java.reference.SuperReference;
import recoder.java.reference.ThisConstructorReference;
import recoder.java.reference.ThisReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.java.reference.VariableReference;
import recoder.java.statement.Assert;
import recoder.java.statement.Branch;
import recoder.java.statement.Break;
import recoder.java.statement.Case;
import recoder.java.statement.Catch;
import recoder.java.statement.Continue;
import recoder.java.statement.Default;
import recoder.java.statement.Do;
import recoder.java.statement.Else;
import recoder.java.statement.EmptyStatement;
import recoder.java.statement.EnhancedFor;
import recoder.java.statement.Finally;
import recoder.java.statement.For;
import recoder.java.statement.If;
import recoder.java.statement.LabeledStatement;
import recoder.java.statement.Return;
import recoder.java.statement.Switch;
import recoder.java.statement.SynchronizedBlock;
import recoder.java.statement.Then;
import recoder.java.statement.Throw;
import recoder.java.statement.Try;
import recoder.java.statement.While;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.parser.JavaCCParser;
import recoder.util.StringUtils;

public class JavaProgramFactory
implements ProgramFactory,
PropertyChangeListener {
    private static final SourceElement.Position ZERO_POSITION = new SourceElement.Position(0, 0);
    private static final JavaProgramFactory theFactory = new JavaProgramFactory();
    private static final JavaCCParser parser = new JavaCCParser(System.in);
    private static ServiceConfiguration serviceConfiguration;
    private static StringWriter writer;
    private static PrettyPrinter sourcePrinter;
    private static boolean useAddNewlineReader;

    protected JavaProgramFactory() {
    }

    public static JavaProgramFactory getInstance() {
        return theFactory;
    }

    private static void attachComment(Comment c, ProgramElement pe) {
        ASTList<Comment> cml;
        SourceElement.Position p;
        int distPost;
        int distPre;
        int idx;
        NonTerminalProgramElement npe;
        ProgramElement dest = pe;
        if (c.isPrefixed() && pe instanceof CompilationUnit && ((CompilationUnit)pe).getChildCount() > 0) {
            ProgramElement fc = ((CompilationUnit)pe).getChildAt(0);
            int distcu = c.getStartPosition().getLine();
            int distfc = fc.getStartPosition().getLine() - c.getEndPosition().getLine();
            if (c instanceof SingleLineComment) {
                --distcu;
            }
            if (distcu >= distfc) {
                dest = fc;
            }
        } else if (!c.isPrefixed()) {
            NonTerminalProgramElement ppe = dest.getASTParent();
            int i = 0;
            if (ppe != null) {
                while (ppe.getChildAt(i) != dest) {
                    ++i;
                }
            }
            if (i == 0) {
                c.setPrefixed(true);
            } else {
                dest = ppe.getChildAt(i - 1);
                while (dest instanceof NonTerminalProgramElement && (i = (ppe = (NonTerminalProgramElement)dest).getChildCount()) != 0) {
                    dest = ppe.getChildAt(i - 1);
                }
                boolean doChange = false;
                for (ppe = dest.getASTParent(); ppe != null && ppe.getASTParent() != null && ppe.getEndPosition().compareTo(dest.getEndPosition()) >= 0 && ppe.getASTParent().getEndPosition().compareTo(c.getStartPosition()) <= 0; ppe = ppe.getASTParent()) {
                    doChange = true;
                }
                if (ppe != null && doChange) {
                    dest = ppe;
                }
                if (dest instanceof NonTerminalProgramElement && (ppe = (NonTerminalProgramElement)dest).getEndPosition().compareTo(c.getStartPosition()) >= 0) {
                    while (ppe.getChildCount() > 0 && ppe.getChildAt(ppe.getChildCount() - 1).getEndPosition().compareTo(ppe.getEndPosition()) == 0 && ppe.getChildAt(ppe.getChildCount() - 1) instanceof NonTerminalProgramElement) {
                        ppe = (NonTerminalProgramElement)ppe.getChildAt(ppe.getChildCount() - 1);
                        dest = ppe;
                    }
                    c.setContainerComment(true);
                }
                if (!c.isContainerComment() && pe != dest && pe.getFirstElement().getStartPosition().getLine() == dest.getLastElement().getEndPosition().getLine()) {
                    int before = c.getStartPosition().getColumn() - dest.getLastElement().getEndPosition().getColumn();
                    int after = pe.getFirstElement().getStartPosition().getColumn() - c.getEndPosition().getColumn();
                    if (after <= before) {
                        dest = pe;
                        c.setPrefixed(true);
                    }
                }
            }
        }
        if (c.isPrefixed()) {
            for (npe = dest.getASTParent(); npe != null && npe.getStartPosition().equals(dest.getStartPosition()); npe = npe.getASTParent()) {
                dest = npe;
            }
        } else {
            for (npe = dest.getASTParent(); npe != null && npe.getEndPosition().equals(dest.getEndPosition()); npe = npe.getASTParent()) {
                dest = npe;
            }
        }
        if (c.isPrefixed() && c.getEndPosition().getLine() < dest.getStartPosition().getLine()) {
            npe = dest.getASTParent();
            if (npe != null && (idx = npe.getIndexOfChild(dest)) > 0) {
                distPre = dest.getStartPosition().getLine() - c.getEndPosition().getLine();
                distPost = c.getStartPosition().getLine() - npe.getChildAt(idx - 1).getEndPosition().getLine();
                if (c instanceof SingleLineComment) {
                    --distPost;
                }
                if (distPost < distPre) {
                    dest = npe.getChildAt(idx - 1);
                    c.setPrefixed(false);
                }
            }
        } else if (!c.isPrefixed() && c.getStartPosition().getLine() > dest.getEndPosition().getLine() && (npe = dest.getASTParent()) != null && (idx = npe.getIndexOfChild(dest)) + 1 < npe.getChildCount()) {
            distPre = npe.getChildAt(idx + 1).getStartPosition().getLine() - c.getEndPosition().getLine();
            distPost = c.getStartPosition().getLine() - dest.getEndPosition().getLine();
            if (c instanceof SingleLineComment) {
                --distPost;
            }
            if (distPre <= distPost) {
                dest = npe.getChildAt(idx + 1);
                c.setPrefixed(true);
            }
        }
        if (c instanceof SingleLineComment && c.isPrefixed() && (p = dest.getFirstElement().getRelativePosition()).getLine() < 1) {
            p.setLine(1);
            dest.getFirstElement().setRelativePosition(p);
        }
        if ((cml = dest.getComments()) == null) {
            cml = new ASTArrayList<Comment>();
            dest.setComments(cml);
        }
        cml.add(c);
    }

    private static void postWork(ProgramElement pe) {
        List<Comment> comments = JavaCCParser.getComments();
        int commentIndex = 0;
        int commentCount = comments.size();
        SourceElement.Position cpos = ZERO_POSITION;
        Comment current = null;
        if (commentIndex < commentCount) {
            current = comments.get(commentIndex);
            cpos = current.getFirstElement().getStartPosition();
        }
        TreeWalker tw = new TreeWalker(pe);
        while (tw.next()) {
            pe = tw.getProgramElement();
            if (pe instanceof NonTerminalProgramElement) {
                ((NonTerminalProgramElement)pe).makeParentRoleValid();
            }
            SourceElement.Position pos = pe.getFirstElement().getStartPosition();
            while (commentIndex < commentCount && pos.compareTo(cpos) > 0) {
                JavaProgramFactory.attachComment(current, pe);
                if (++commentIndex >= commentCount) continue;
                current = comments.get(commentIndex);
                cpos = current.getFirstElement().getStartPosition();
            }
        }
        if (commentIndex < commentCount) {
            while (pe.getASTParent() != null) {
                pe = pe.getASTParent();
            }
            do {
                ASTList<Comment> cml;
                NonTerminalProgramElement npe;
                current = comments.get(commentIndex);
                ProgramElement dest = pe;
                ProgramElement newDest = null;
                while (dest instanceof NonTerminalProgramElement && (npe = (NonTerminalProgramElement)dest).getChildCount() != 0) {
                    newDest = npe.getChildAt(npe.getChildCount() - 1);
                    if (npe.getEndPosition().compareTo(current.getStartPosition()) <= 0 && (npe.getEndPosition().compareTo(current.getStartPosition()) != 0 || newDest.getEndPosition().compareTo(current.getStartPosition()) > 0) || dest == newDest) break;
                    dest = newDest;
                }
                if ((cml = dest.getComments()) == null) {
                    cml = new ASTArrayList<Comment>();
                    dest.setComments(cml);
                }
                current.setPrefixed(false);
                cml.add(current);
            } while (++commentIndex < commentCount);
        }
    }

    public static int parseInt(String nm) throws NumberFormatException {
        int radix;
        boolean negative = false;
        int index = 0;
        if (nm.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            ++index;
            radix = 8;
        } else {
            radix = 10;
        }
        if (nm.startsWith("-", index)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        int len = nm.length() - index;
        if (radix == 16 && len == 8) {
            char first = nm.charAt(index);
            int result = Integer.valueOf(nm.substring(++index), radix);
            return negative ? -result : (result |= Character.digit(first, 16) << 28);
        }
        if (radix == 8 && len == 11) {
            char first = nm.charAt(index);
            int result = Integer.valueOf(nm.substring(++index), radix);
            return negative ? -result : (result |= Character.digit(first, 8) << 30);
        }
        if (!negative && radix == 10 && len == 10 && nm.indexOf("2147483648", index) == index) {
            return Integer.MIN_VALUE;
        }
        int result = Integer.valueOf(nm.substring(index), radix);
        return negative ? -result : result;
    }

    public static long parseLong(String nm) throws NumberFormatException {
        int radix;
        if (nm.equalsIgnoreCase("0L")) {
            return 0L;
        }
        boolean negative = false;
        int index = 0;
        if (nm.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            ++index;
            radix = 8;
        } else {
            radix = 10;
        }
        if (nm.startsWith("-", index)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        int endIndex = nm.length();
        if (nm.endsWith("L") || nm.endsWith("l")) {
            --endIndex;
        }
        int len = endIndex - index;
        if (radix == 16 && len == 16) {
            char first = nm.charAt(index);
            long result = Long.valueOf(nm.substring(++index, endIndex), radix);
            return negative ? -result : (result |= (long)Character.digit(first, 16) << 60);
        }
        if (radix == 8 && len == 21) {
            char first = nm.charAt(index);
            long result = Long.valueOf(nm.substring(++index, endIndex), radix);
            return negative ? -result : (result |= (long)(Character.digit(first, 8) << 63));
        }
        if (!negative && radix == 10 && len == 19 && nm.indexOf("9223372036854775808", index) == index) {
            return Long.MIN_VALUE;
        }
        long result = Long.valueOf(nm.substring(index, endIndex), radix);
        return negative ? -result : result;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Requires a java source file as argument");
            System.exit(1);
        }
        try {
            CompilationUnit cu = new DefaultServiceConfiguration().getProgramFactory().parseCompilationUnit(new FileReader(args[0]));
            System.out.println(cu.toSource());
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            ioe.printStackTrace();
        }
        catch (ParserException pe) {
            System.err.println(pe);
            pe.printStackTrace();
        }
    }

    @Override
    public void initialize(ServiceConfiguration cfg) {
        serviceConfiguration = cfg;
        ProjectSettings settings = serviceConfiguration.getProjectSettings();
        settings.addPropertyChangeListener(this);
        writer = new StringWriter();
        sourcePrinter = new PrettyPrinter(writer, settings.getProperties());
        JavaCCParser.setAwareOfAssert(StringUtils.parseBooleanProperty(settings.getProperties().getProperty("jdk1.4")));
        JavaCCParser.setJava5(StringUtils.parseBooleanProperty(settings.getProperties().getProperty("java5")));
    }

    @Override
    public ServiceConfiguration getServiceConfiguration() {
        return serviceConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilationUnit parseCompilationUnit(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = parser;
        synchronized (javaCCParser) {
            JavaCCParser.initialize(useAddNewlineReader ? new AddNewlineReader(in) : in);
            CompilationUnit res = JavaCCParser.CompilationUnit();
            JavaProgramFactory.postWork(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDeclaration parseTypeDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = parser;
        synchronized (javaCCParser) {
            JavaCCParser.initialize(in);
            TypeDeclaration res = JavaCCParser.TypeDeclaration();
            JavaProgramFactory.postWork(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldDeclaration parseFieldDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = parser;
        synchronized (javaCCParser) {
            JavaCCParser.initialize(in);
            FieldDeclaration res = JavaCCParser.FieldDeclaration();
            JavaProgramFactory.postWork(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodDeclaration parseMethodDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = parser;
        synchronized (javaCCParser) {
            JavaCCParser.initialize(in);
            MethodDeclaration res = JavaCCParser.MethodDeclaration();
            JavaProgramFactory.postWork(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemberDeclaration parseMemberDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = parser;
        synchronized (javaCCParser) {
            JavaCCParser.initialize(in);
            MemberDeclaration res = JavaCCParser.ClassBodyDeclaration();
            JavaProgramFactory.postWork(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDeclaration parseParameterDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = parser;
        synchronized (javaCCParser) {
            JavaCCParser.initialize(in);
            ParameterDeclaration res = JavaCCParser.FormalParameter();
            JavaProgramFactory.postWork(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConstructorDeclaration parseConstructorDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = parser;
        synchronized (javaCCParser) {
            JavaCCParser.initialize(in);
            ConstructorDeclaration res = JavaCCParser.ConstructorDeclaration();
            JavaProgramFactory.postWork(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeReference parseTypeReference(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = parser;
        synchronized (javaCCParser) {
            JavaCCParser.initialize(in);
            TypeReference res = JavaCCParser.ResultType();
            JavaProgramFactory.postWork(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression parseExpression(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = parser;
        synchronized (javaCCParser) {
            JavaCCParser.initialize(in);
            Expression res = JavaCCParser.Expression();
            JavaProgramFactory.postWork(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ASTList<Statement> parseStatements(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = parser;
        synchronized (javaCCParser) {
            JavaCCParser.initialize(in);
            ASTList<Statement> res = JavaCCParser.GeneralizedStatements();
            for (int i = 0; i < res.size(); ++i) {
                JavaProgramFactory.postWork((ProgramElement)res.get(i));
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementBlock parseStatementBlock(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = parser;
        synchronized (javaCCParser) {
            JavaCCParser.initialize(in);
            StatementBlock res = JavaCCParser.Block();
            JavaProgramFactory.postWork(res);
            return res;
        }
    }

    @Override
    public CompilationUnit parseCompilationUnit(String in) throws ParserException {
        try {
            return this.parseCompilationUnit(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public List<CompilationUnit> parseCompilationUnits(String[] ins) throws ParserException {
        try {
            ArrayList<CompilationUnit> cus = new ArrayList<CompilationUnit>();
            for (int i = 0; i < ins.length; ++i) {
                CompilationUnit cu = this.parseCompilationUnit(new FileReader(ins[i]));
                cus.add(cu);
            }
            return cus;
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public TypeDeclaration parseTypeDeclaration(String in) throws ParserException {
        try {
            return this.parseTypeDeclaration(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public MemberDeclaration parseMemberDeclaration(String in) throws ParserException {
        try {
            return this.parseMemberDeclaration(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public FieldDeclaration parseFieldDeclaration(String in) throws ParserException {
        try {
            return this.parseFieldDeclaration(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public MethodDeclaration parseMethodDeclaration(String in) throws ParserException {
        try {
            return this.parseMethodDeclaration(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public ParameterDeclaration parseParameterDeclaration(String in) throws ParserException {
        try {
            return this.parseParameterDeclaration(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public ConstructorDeclaration parseConstructorDeclaration(String in) throws ParserException {
        try {
            return this.parseConstructorDeclaration(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public TypeReference parseTypeReference(String in) throws ParserException {
        try {
            return this.parseTypeReference(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public Expression parseExpression(String in) throws ParserException {
        try {
            return this.parseExpression(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public ASTList<Statement> parseStatements(String in) throws ParserException {
        try {
            return this.parseStatements(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toSource(JavaSourceElement jse) {
        StringWriter stringWriter = writer;
        synchronized (stringWriter) {
            sourcePrinter.setIndentationLevel(0);
            jse.accept(sourcePrinter);
            StringBuffer buf = writer.getBuffer();
            String str = buf.toString();
            buf.setLength(0);
            return str;
        }
    }

    @Override
    public PrettyPrinter getPrettyPrinter(Writer out) {
        return new PrettyPrinter(out, serviceConfiguration.getProjectSettings().getProperties());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        sourcePrinter = new PrettyPrinter(writer, serviceConfiguration.getProjectSettings().getProperties());
        String changedProp = evt.getPropertyName();
        if (changedProp.equals("jdk1.4")) {
            JavaCCParser.setAwareOfAssert(StringUtils.parseBooleanProperty(evt.getNewValue().toString()));
        }
        if (changedProp.equals("java5")) {
            JavaCCParser.setJava5(StringUtils.parseBooleanProperty(evt.getNewValue().toString()));
        }
        if (changedProp.equals("extra_newline_at_end_of_file")) {
            useAddNewlineReader = StringUtils.parseBooleanProperty(evt.getNewValue().toString());
        }
    }

    @Override
    public Comment createComment() {
        return new Comment();
    }

    @Override
    public Comment createComment(String text) {
        return new Comment(text);
    }

    @Override
    public Comment createComment(String text, boolean prefixed) {
        return new Comment(text, prefixed);
    }

    @Override
    public CompilationUnit createCompilationUnit() {
        return new CompilationUnit();
    }

    @Override
    public CompilationUnit createCompilationUnit(PackageSpecification pkg, ASTList<Import> imports, ASTList<TypeDeclaration> typeDeclarations) {
        return new CompilationUnit(pkg, imports, typeDeclarations);
    }

    @Override
    public DocComment createDocComment() {
        return new DocComment();
    }

    @Override
    public DocComment createDocComment(String text) {
        return new DocComment(text);
    }

    @Override
    public Identifier createIdentifier() {
        return new Identifier();
    }

    @Override
    public Identifier createIdentifier(String text) {
        return new Identifier(text);
    }

    @Override
    public Import createImport() {
        return new Import();
    }

    @Override
    public Import createImport(TypeReference t, boolean multi) {
        return new Import(t, multi);
    }

    @Override
    public Import createImport(PackageReference t) {
        return new Import(t);
    }

    @Override
    public Import createStaticImport(TypeReference t) {
        return new Import(t, true, true);
    }

    @Override
    public Import createStaticImport(TypeReference t, Identifier id) {
        return new Import(t, id);
    }

    @Override
    public PackageSpecification createPackageSpecification() {
        return new PackageSpecification();
    }

    @Override
    public PackageSpecification createPackageSpecification(PackageReference pkg) {
        return new PackageSpecification(pkg);
    }

    @Override
    public SingleLineComment createSingleLineComment() {
        return new SingleLineComment();
    }

    @Override
    public SingleLineComment createSingleLineComment(String text) {
        return new SingleLineComment(text);
    }

    @Override
    public TypeReference createTypeReference() {
        return new TypeReference();
    }

    @Override
    public TypeReference createTypeReference(Identifier name) {
        return new TypeReference(name);
    }

    @Override
    public TypeReference createTypeReference(ReferencePrefix prefix, Identifier name) {
        return new TypeReference(prefix, name);
    }

    @Override
    public TypeReference createTypeReference(Identifier name, int dim) {
        return new TypeReference(name, dim);
    }

    @Override
    public PackageReference createPackageReference() {
        return new PackageReference();
    }

    @Override
    public PackageReference createPackageReference(Identifier id) {
        return new PackageReference(id);
    }

    @Override
    public PackageReference createPackageReference(PackageReference path, Identifier id) {
        return new PackageReference(path, id);
    }

    @Override
    public UncollatedReferenceQualifier createUncollatedReferenceQualifier() {
        return new UncollatedReferenceQualifier();
    }

    @Override
    public UncollatedReferenceQualifier createUncollatedReferenceQualifier(Identifier id) {
        return new UncollatedReferenceQualifier(id);
    }

    @Override
    public UncollatedReferenceQualifier createUncollatedReferenceQualifier(ReferencePrefix prefix, Identifier id) {
        return new UncollatedReferenceQualifier(prefix, id);
    }

    @Override
    public ClassDeclaration createClassDeclaration() {
        return new ClassDeclaration();
    }

    @Override
    public ClassDeclaration createClassDeclaration(ASTList<DeclarationSpecifier> declSpecs, Identifier name, Extends extended, Implements implemented, ASTList<MemberDeclaration> members) {
        return new ClassDeclaration(declSpecs, name, extended, implemented, members);
    }

    @Override
    public ClassDeclaration createClassDeclaration(ASTList<MemberDeclaration> members) {
        return new ClassDeclaration(members);
    }

    @Override
    public ClassInitializer createClassInitializer() {
        return new ClassInitializer();
    }

    @Override
    public ClassInitializer createClassInitializer(StatementBlock body) {
        return new ClassInitializer(body);
    }

    @Override
    public ClassInitializer createClassInitializer(Static modifier, StatementBlock body) {
        return new ClassInitializer(modifier, body);
    }

    @Override
    public ConstructorDeclaration createConstructorDeclaration() {
        return new ConstructorDeclaration();
    }

    @Override
    public ConstructorDeclaration createConstructorDeclaration(VisibilityModifier modifier, Identifier name, ASTList<ParameterDeclaration> parameters, Throws exceptions, StatementBlock body) {
        return new ConstructorDeclaration(modifier, name, parameters, exceptions, body);
    }

    @Override
    public Throws createThrows() {
        return new Throws();
    }

    @Override
    public Throws createThrows(TypeReference exception) {
        return new Throws(exception);
    }

    @Override
    public Throws createThrows(ASTList<TypeReference> list) {
        return new Throws(list);
    }

    @Override
    public FieldDeclaration createFieldDeclaration() {
        return new FieldDeclaration();
    }

    @Override
    public FieldDeclaration createFieldDeclaration(TypeReference typeRef, Identifier name) {
        return new FieldDeclaration(typeRef, name);
    }

    @Override
    public FieldDeclaration createFieldDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, Identifier name, Expression init) {
        return new FieldDeclaration(mods, typeRef, name, init);
    }

    @Override
    public FieldDeclaration createFieldDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, ASTList<FieldSpecification> vars) {
        return new FieldDeclaration(mods, typeRef, vars);
    }

    @Override
    public Extends createExtends() {
        return new Extends();
    }

    @Override
    public Extends createExtends(TypeReference supertype) {
        return new Extends(supertype);
    }

    @Override
    public Extends createExtends(ASTList<TypeReference> list) {
        return new Extends(list);
    }

    @Override
    public Implements createImplements() {
        return new Implements();
    }

    @Override
    public Implements createImplements(TypeReference supertype) {
        return new Implements(supertype);
    }

    @Override
    public Implements createImplements(ASTList<TypeReference> list) {
        return new Implements(list);
    }

    @Override
    public InterfaceDeclaration createInterfaceDeclaration() {
        return new InterfaceDeclaration();
    }

    @Override
    public InterfaceDeclaration createInterfaceDeclaration(ASTList<DeclarationSpecifier> modifiers, Identifier name, Extends extended, ASTList<MemberDeclaration> members) {
        return new InterfaceDeclaration(modifiers, name, extended, members);
    }

    @Override
    public AnnotationDeclaration createAnnotationDeclaration() {
        return new AnnotationDeclaration();
    }

    @Override
    public AnnotationDeclaration createAnnotationDeclaration(ASTList<DeclarationSpecifier> modifiers, Identifier name, ASTList<MemberDeclaration> members) {
        return new AnnotationDeclaration(modifiers, name, members);
    }

    @Override
    public LocalVariableDeclaration createLocalVariableDeclaration() {
        return new LocalVariableDeclaration();
    }

    @Override
    public LocalVariableDeclaration createLocalVariableDeclaration(TypeReference typeRef, Identifier name) {
        return new LocalVariableDeclaration(typeRef, name);
    }

    @Override
    public LocalVariableDeclaration createLocalVariableDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, ASTList<VariableSpecification> vars) {
        return new LocalVariableDeclaration(mods, typeRef, vars);
    }

    @Override
    public LocalVariableDeclaration createLocalVariableDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, Identifier name, Expression init) {
        return new LocalVariableDeclaration(mods, typeRef, name, init);
    }

    @Override
    public MethodDeclaration createMethodDeclaration() {
        return new MethodDeclaration();
    }

    @Override
    public MethodDeclaration createMethodDeclaration(ASTList<DeclarationSpecifier> modifiers, TypeReference returnType, Identifier name, ASTList<ParameterDeclaration> parameters, Throws exceptions) {
        return new MethodDeclaration(modifiers, returnType, name, parameters, exceptions);
    }

    @Override
    public MethodDeclaration createMethodDeclaration(ASTList<DeclarationSpecifier> modifiers, TypeReference returnType, Identifier name, ASTList<ParameterDeclaration> parameters, Throws exceptions, StatementBlock body) {
        return new MethodDeclaration(modifiers, returnType, name, parameters, exceptions, body);
    }

    @Override
    public AnnotationPropertyDeclaration createAnnotationPropertyDeclaration(ASTList<DeclarationSpecifier> modifiers, TypeReference returnType, Identifier name, Expression defaultValue) {
        return new AnnotationPropertyDeclaration(modifiers, returnType, name, defaultValue);
    }

    @Override
    public ParameterDeclaration createParameterDeclaration() {
        return new ParameterDeclaration();
    }

    @Override
    public ParameterDeclaration createParameterDeclaration(TypeReference typeRef, Identifier name) {
        return new ParameterDeclaration(typeRef, name);
    }

    @Override
    public ParameterDeclaration createParameterDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, Identifier name) {
        return new ParameterDeclaration(mods, typeRef, name);
    }

    @Override
    public VariableSpecification createVariableSpecification() {
        return new VariableSpecification();
    }

    @Override
    public VariableSpecification createVariableSpecification(Identifier name) {
        return new VariableSpecification(name);
    }

    @Override
    public VariableSpecification createVariableSpecification(Identifier name, Expression init) {
        return new VariableSpecification(name, init);
    }

    @Override
    public VariableSpecification createVariableSpecification(Identifier name, int dimensions, Expression init) {
        return new VariableSpecification(name, dimensions, init);
    }

    @Override
    public FieldSpecification createFieldSpecification() {
        return new FieldSpecification();
    }

    @Override
    public FieldSpecification createFieldSpecification(Identifier name) {
        return new FieldSpecification(name);
    }

    @Override
    public FieldSpecification createFieldSpecification(Identifier name, Expression init) {
        return new FieldSpecification(name, init);
    }

    @Override
    public FieldSpecification createFieldSpecification(Identifier name, int dimensions, Expression init) {
        return new FieldSpecification(name, dimensions, init);
    }

    @Override
    public ArrayInitializer createArrayInitializer() {
        return new ArrayInitializer();
    }

    @Override
    public ArrayInitializer createArrayInitializer(ASTList<Expression> args) {
        return new ArrayInitializer(args);
    }

    @Override
    public ParenthesizedExpression createParenthesizedExpression() {
        return new ParenthesizedExpression();
    }

    @Override
    public ParenthesizedExpression createParenthesizedExpression(Expression child) {
        return new ParenthesizedExpression(child);
    }

    @Override
    public BooleanLiteral createBooleanLiteral() {
        return new BooleanLiteral();
    }

    @Override
    public BooleanLiteral createBooleanLiteral(boolean value) {
        return new BooleanLiteral(value);
    }

    @Override
    public CharLiteral createCharLiteral() {
        return new CharLiteral();
    }

    @Override
    public CharLiteral createCharLiteral(char value) {
        return new CharLiteral(value);
    }

    @Override
    public CharLiteral createCharLiteral(String value) {
        return new CharLiteral(value);
    }

    @Override
    public DoubleLiteral createDoubleLiteral() {
        return new DoubleLiteral();
    }

    @Override
    public DoubleLiteral createDoubleLiteral(double value) {
        return new DoubleLiteral(value);
    }

    @Override
    public DoubleLiteral createDoubleLiteral(String value) {
        return new DoubleLiteral(value);
    }

    @Override
    public FloatLiteral createFloatLiteral() {
        return new FloatLiteral();
    }

    @Override
    public FloatLiteral createFloatLiteral(float value) {
        return new FloatLiteral(value);
    }

    @Override
    public FloatLiteral createFloatLiteral(String value) {
        return new FloatLiteral(value);
    }

    @Override
    public IntLiteral createIntLiteral() {
        return new IntLiteral();
    }

    @Override
    public IntLiteral createIntLiteral(int value) {
        return new IntLiteral(value);
    }

    @Override
    public IntLiteral createIntLiteral(String value) {
        return new IntLiteral(value);
    }

    @Override
    public LongLiteral createLongLiteral() {
        return new LongLiteral();
    }

    @Override
    public LongLiteral createLongLiteral(long value) {
        return new LongLiteral(value);
    }

    @Override
    public LongLiteral createLongLiteral(String value) {
        return new LongLiteral(value);
    }

    @Override
    public NullLiteral createNullLiteral() {
        return new NullLiteral();
    }

    @Override
    public StringLiteral createStringLiteral() {
        return new StringLiteral();
    }

    @Override
    public StringLiteral createStringLiteral(String value) {
        return new StringLiteral(value);
    }

    @Override
    public ArrayReference createArrayReference() {
        return new ArrayReference();
    }

    @Override
    public ArrayReference createArrayReference(ReferencePrefix accessPath, ASTList<Expression> initializers) {
        return new ArrayReference(accessPath, initializers);
    }

    @Override
    public FieldReference createFieldReference() {
        return new FieldReference();
    }

    @Override
    public FieldReference createFieldReference(Identifier id) {
        return new FieldReference(id);
    }

    @Override
    public FieldReference createFieldReference(ReferencePrefix prefix, Identifier id) {
        return new FieldReference(prefix, id);
    }

    @Override
    public MetaClassReference createMetaClassReference() {
        return new MetaClassReference();
    }

    @Override
    public MetaClassReference createMetaClassReference(TypeReference reference) {
        return new MetaClassReference(reference);
    }

    @Override
    public MethodReference createMethodReference() {
        return new MethodReference();
    }

    @Override
    public MethodReference createMethodReference(Identifier name) {
        return new MethodReference(name);
    }

    @Override
    public MethodReference createMethodReference(ReferencePrefix accessPath, Identifier name) {
        return new MethodReference(accessPath, name);
    }

    @Override
    public MethodReference createMethodReference(Identifier name, ASTList<Expression> args) {
        return new MethodReference(name, args);
    }

    @Override
    public MethodReference createMethodReference(ReferencePrefix accessPath, Identifier name, ASTList<Expression> args) {
        return new MethodReference(accessPath, name, args);
    }

    @Override
    public MethodReference createMethodReference(ReferencePrefix accessPath, Identifier name, ASTList<Expression> args, ASTList<TypeArgumentDeclaration> typeArgs) {
        return new MethodReference(accessPath, name, args, typeArgs);
    }

    @Override
    public AnnotationPropertyReference createAnnotationPropertyReference(String id) {
        Identifier ident = new Identifier(id);
        return new AnnotationPropertyReference(ident);
    }

    @Override
    public AnnotationPropertyReference createAnnotationPropertyReference(Identifier id) {
        return new AnnotationPropertyReference(id);
    }

    @Override
    public SuperConstructorReference createSuperConstructorReference() {
        return new SuperConstructorReference();
    }

    @Override
    public SuperConstructorReference createSuperConstructorReference(ASTList<Expression> arguments) {
        return new SuperConstructorReference(arguments);
    }

    @Override
    public SuperConstructorReference createSuperConstructorReference(ReferencePrefix path, ASTList<Expression> arguments) {
        return new SuperConstructorReference(path, arguments);
    }

    @Override
    public SuperReference createSuperReference() {
        return new SuperReference();
    }

    @Override
    public SuperReference createSuperReference(ReferencePrefix accessPath) {
        return new SuperReference(accessPath);
    }

    @Override
    public ThisConstructorReference createThisConstructorReference() {
        return new ThisConstructorReference();
    }

    @Override
    public ThisConstructorReference createThisConstructorReference(ASTList<Expression> arguments) {
        return new ThisConstructorReference(arguments);
    }

    @Override
    public ThisReference createThisReference() {
        return new ThisReference();
    }

    @Override
    public ThisReference createThisReference(TypeReference outer) {
        return new ThisReference(outer);
    }

    @Override
    public VariableReference createVariableReference() {
        return new VariableReference();
    }

    @Override
    public VariableReference createVariableReference(Identifier id) {
        return new VariableReference(id);
    }

    @Override
    public ArrayLengthReference createArrayLengthReference() {
        return new ArrayLengthReference();
    }

    @Override
    public ArrayLengthReference createArrayLengthReference(ReferencePrefix prefix) {
        return new ArrayLengthReference(prefix);
    }

    @Override
    public BinaryAnd createBinaryAnd() {
        return new BinaryAnd();
    }

    @Override
    public BinaryAnd createBinaryAnd(Expression lhs, Expression rhs) {
        return new BinaryAnd(lhs, rhs);
    }

    @Override
    public BinaryAndAssignment createBinaryAndAssignment() {
        return new BinaryAndAssignment();
    }

    @Override
    public BinaryAndAssignment createBinaryAndAssignment(Expression lhs, Expression rhs) {
        return new BinaryAndAssignment(lhs, rhs);
    }

    @Override
    public BinaryNot createBinaryNot() {
        return new BinaryNot();
    }

    @Override
    public BinaryNot createBinaryNot(Expression child) {
        return new BinaryNot(child);
    }

    @Override
    public BinaryOr createBinaryOr() {
        return new BinaryOr();
    }

    @Override
    public BinaryOr createBinaryOr(Expression lhs, Expression rhs) {
        return new BinaryOr(lhs, rhs);
    }

    @Override
    public BinaryOrAssignment createBinaryOrAssignment() {
        return new BinaryOrAssignment();
    }

    @Override
    public BinaryOrAssignment createBinaryOrAssignment(Expression lhs, Expression rhs) {
        return new BinaryOrAssignment(lhs, rhs);
    }

    @Override
    public BinaryXOr createBinaryXOr() {
        return new BinaryXOr();
    }

    @Override
    public BinaryXOr createBinaryXOr(Expression lhs, Expression rhs) {
        return new BinaryXOr(lhs, rhs);
    }

    @Override
    public BinaryXOrAssignment createBinaryXOrAssignment() {
        return new BinaryXOrAssignment();
    }

    @Override
    public BinaryXOrAssignment createBinaryXOrAssignment(Expression lhs, Expression rhs) {
        return new BinaryXOrAssignment(lhs, rhs);
    }

    @Override
    public Conditional createConditional() {
        return new Conditional();
    }

    @Override
    public Conditional createConditional(Expression guard, Expression thenExpr, Expression elseExpr) {
        return new Conditional(guard, thenExpr, elseExpr);
    }

    @Override
    public CopyAssignment createCopyAssignment() {
        return new CopyAssignment();
    }

    @Override
    public CopyAssignment createCopyAssignment(Expression lhs, Expression rhs) {
        return new CopyAssignment(lhs, rhs);
    }

    @Override
    public Divide createDivide() {
        return new Divide();
    }

    @Override
    public Divide createDivide(Expression lhs, Expression rhs) {
        return new Divide(lhs, rhs);
    }

    @Override
    public DivideAssignment createDivideAssignment() {
        return new DivideAssignment();
    }

    @Override
    public DivideAssignment createDivideAssignment(Expression lhs, Expression rhs) {
        return new DivideAssignment(lhs, rhs);
    }

    @Override
    public Equals createEquals() {
        return new Equals();
    }

    @Override
    public Equals createEquals(Expression lhs, Expression rhs) {
        return new Equals(lhs, rhs);
    }

    @Override
    public GreaterOrEquals createGreaterOrEquals() {
        return new GreaterOrEquals();
    }

    @Override
    public GreaterOrEquals createGreaterOrEquals(Expression lhs, Expression rhs) {
        return new GreaterOrEquals(lhs, rhs);
    }

    @Override
    public GreaterThan createGreaterThan() {
        return new GreaterThan();
    }

    @Override
    public GreaterThan createGreaterThan(Expression lhs, Expression rhs) {
        return new GreaterThan(lhs, rhs);
    }

    @Override
    public Instanceof createInstanceof() {
        return new Instanceof();
    }

    @Override
    public Instanceof createInstanceof(Expression child, TypeReference typeref) {
        return new Instanceof(child, typeref);
    }

    @Override
    public LessOrEquals createLessOrEquals() {
        return new LessOrEquals();
    }

    @Override
    public LessOrEquals createLessOrEquals(Expression lhs, Expression rhs) {
        return new LessOrEquals(lhs, rhs);
    }

    @Override
    public LessThan createLessThan() {
        return new LessThan();
    }

    @Override
    public LessThan createLessThan(Expression lhs, Expression rhs) {
        return new LessThan(lhs, rhs);
    }

    @Override
    public LogicalAnd createLogicalAnd() {
        return new LogicalAnd();
    }

    @Override
    public LogicalAnd createLogicalAnd(Expression lhs, Expression rhs) {
        return new LogicalAnd(lhs, rhs);
    }

    @Override
    public LogicalNot createLogicalNot() {
        return new LogicalNot();
    }

    @Override
    public LogicalNot createLogicalNot(Expression child) {
        return new LogicalNot(child);
    }

    @Override
    public LogicalOr createLogicalOr() {
        return new LogicalOr();
    }

    @Override
    public LogicalOr createLogicalOr(Expression lhs, Expression rhs) {
        return new LogicalOr(lhs, rhs);
    }

    @Override
    public Minus createMinus() {
        return new Minus();
    }

    @Override
    public Minus createMinus(Expression lhs, Expression rhs) {
        return new Minus(lhs, rhs);
    }

    @Override
    public MinusAssignment createMinusAssignment() {
        return new MinusAssignment();
    }

    @Override
    public MinusAssignment createMinusAssignment(Expression lhs, Expression rhs) {
        return new MinusAssignment(lhs, rhs);
    }

    @Override
    public Modulo createModulo() {
        return new Modulo();
    }

    @Override
    public Modulo createModulo(Expression lhs, Expression rhs) {
        return new Modulo(lhs, rhs);
    }

    @Override
    public ModuloAssignment createModuloAssignment() {
        return new ModuloAssignment();
    }

    @Override
    public ModuloAssignment createModuloAssignment(Expression lhs, Expression rhs) {
        return new ModuloAssignment(lhs, rhs);
    }

    @Override
    public Negative createNegative() {
        return new Negative();
    }

    @Override
    public Negative createNegative(Expression child) {
        return new Negative(child);
    }

    @Override
    public New createNew() {
        return new New();
    }

    @Override
    public New createNew(ReferencePrefix accessPath, TypeReference constructorName, ASTList<Expression> arguments) {
        return new New(accessPath, constructorName, arguments);
    }

    @Override
    public New createNew(ReferencePrefix accessPath, TypeReference constructorName, ASTList<Expression> arguments, ClassDeclaration anonymousClass) {
        return new New(accessPath, constructorName, arguments, anonymousClass);
    }

    @Override
    public NewArray createNewArray() {
        return new NewArray();
    }

    @Override
    public NewArray createNewArray(TypeReference arrayName, ASTList<Expression> dimExpr) {
        return new NewArray(arrayName, dimExpr);
    }

    @Override
    public NewArray createNewArray(TypeReference arrayName, int dimensions, ArrayInitializer initializer) {
        return new NewArray(arrayName, dimensions, initializer);
    }

    @Override
    public NotEquals createNotEquals() {
        return new NotEquals();
    }

    @Override
    public NotEquals createNotEquals(Expression lhs, Expression rhs) {
        return new NotEquals(lhs, rhs);
    }

    @Override
    public Plus createPlus() {
        return new Plus();
    }

    @Override
    public Plus createPlus(Expression lhs, Expression rhs) {
        return new Plus(lhs, rhs);
    }

    @Override
    public PlusAssignment createPlusAssignment() {
        return new PlusAssignment();
    }

    @Override
    public PlusAssignment createPlusAssignment(Expression lhs, Expression rhs) {
        return new PlusAssignment(lhs, rhs);
    }

    @Override
    public Positive createPositive() {
        return new Positive();
    }

    @Override
    public Positive createPositive(Expression child) {
        return new Positive(child);
    }

    @Override
    public PostDecrement createPostDecrement() {
        return new PostDecrement();
    }

    @Override
    public PostDecrement createPostDecrement(Expression child) {
        return new PostDecrement(child);
    }

    @Override
    public PostIncrement createPostIncrement() {
        return new PostIncrement();
    }

    @Override
    public PostIncrement createPostIncrement(Expression child) {
        return new PostIncrement(child);
    }

    @Override
    public PreDecrement createPreDecrement() {
        return new PreDecrement();
    }

    @Override
    public PreDecrement createPreDecrement(Expression child) {
        return new PreDecrement(child);
    }

    @Override
    public PreIncrement createPreIncrement() {
        return new PreIncrement();
    }

    @Override
    public PreIncrement createPreIncrement(Expression child) {
        return new PreIncrement(child);
    }

    @Override
    public ShiftLeft createShiftLeft() {
        return new ShiftLeft();
    }

    @Override
    public ShiftLeft createShiftLeft(Expression lhs, Expression rhs) {
        return new ShiftLeft(lhs, rhs);
    }

    @Override
    public ShiftLeftAssignment createShiftLeftAssignment() {
        return new ShiftLeftAssignment();
    }

    @Override
    public ShiftLeftAssignment createShiftLeftAssignment(Expression lhs, Expression rhs) {
        return new ShiftLeftAssignment(lhs, rhs);
    }

    @Override
    public ShiftRight createShiftRight() {
        return new ShiftRight();
    }

    @Override
    public ShiftRight createShiftRight(Expression lhs, Expression rhs) {
        return new ShiftRight(lhs, rhs);
    }

    @Override
    public ShiftRightAssignment createShiftRightAssignment() {
        return new ShiftRightAssignment();
    }

    @Override
    public ShiftRightAssignment createShiftRightAssignment(Expression lhs, Expression rhs) {
        return new ShiftRightAssignment(lhs, rhs);
    }

    @Override
    public Times createTimes() {
        return new Times();
    }

    @Override
    public Times createTimes(Expression lhs, Expression rhs) {
        return new Times(lhs, rhs);
    }

    @Override
    public TimesAssignment createTimesAssignment() {
        return new TimesAssignment();
    }

    @Override
    public TimesAssignment createTimesAssignment(Expression lhs, Expression rhs) {
        return new TimesAssignment(lhs, rhs);
    }

    @Override
    public TypeCast createTypeCast() {
        return new TypeCast();
    }

    @Override
    public TypeCast createTypeCast(Expression child, TypeReference typeref) {
        return new TypeCast(child, typeref);
    }

    @Override
    public UnsignedShiftRight createUnsignedShiftRight() {
        return new UnsignedShiftRight();
    }

    @Override
    public UnsignedShiftRight createUnsignedShiftRight(Expression lhs, Expression rhs) {
        return new UnsignedShiftRight(lhs, rhs);
    }

    @Override
    public UnsignedShiftRightAssignment createUnsignedShiftRightAssignment() {
        return new UnsignedShiftRightAssignment();
    }

    @Override
    public UnsignedShiftRightAssignment createUnsignedShiftRightAssignment(Expression lhs, Expression rhs) {
        return new UnsignedShiftRightAssignment(lhs, rhs);
    }

    @Override
    public Abstract createAbstract() {
        return new Abstract();
    }

    @Override
    public Final createFinal() {
        return new Final();
    }

    @Override
    public Native createNative() {
        return new Native();
    }

    @Override
    public Private createPrivate() {
        return new Private();
    }

    @Override
    public Protected createProtected() {
        return new Protected();
    }

    @Override
    public Public createPublic() {
        return new Public();
    }

    @Override
    public Static createStatic() {
        return new Static();
    }

    @Override
    public Synchronized createSynchronized() {
        return new Synchronized();
    }

    @Override
    public Transient createTransient() {
        return new Transient();
    }

    @Override
    public StrictFp createStrictFp() {
        return new StrictFp();
    }

    @Override
    public Volatile createVolatile() {
        return new Volatile();
    }

    @Override
    public AnnotationUseSpecification createAnnotationUseSpecification() {
        return new AnnotationUseSpecification();
    }

    @Override
    public Break createBreak() {
        return new Break();
    }

    @Override
    public Break createBreak(Identifier label) {
        return new Break(label);
    }

    @Override
    public Case createCase() {
        return new Case();
    }

    @Override
    public Case createCase(Expression e) {
        return new Case(e);
    }

    @Override
    public Case createCase(Expression e, ASTList<Statement> body) {
        return new Case(e, body);
    }

    @Override
    public Catch createCatch() {
        return new Catch();
    }

    @Override
    public Catch createCatch(ParameterDeclaration e, StatementBlock body) {
        return new Catch(e, body);
    }

    @Override
    public Continue createContinue() {
        return new Continue();
    }

    @Override
    public Continue createContinue(Identifier label) {
        return new Continue(label);
    }

    @Override
    public Default createDefault() {
        return new Default();
    }

    @Override
    public Default createDefault(ASTList<Statement> body) {
        return new Default(body);
    }

    @Override
    public Do createDo() {
        return new Do();
    }

    @Override
    public Do createDo(Expression guard) {
        return new Do(guard);
    }

    @Override
    public Do createDo(Expression guard, Statement body) {
        return new Do(guard, body);
    }

    @Override
    public Else createElse() {
        return new Else();
    }

    @Override
    public Else createElse(Statement body) {
        return new Else(body);
    }

    @Override
    public EmptyStatement createEmptyStatement() {
        return new EmptyStatement();
    }

    @Override
    public Finally createFinally() {
        return new Finally();
    }

    @Override
    public Finally createFinally(StatementBlock body) {
        return new Finally(body);
    }

    @Override
    public For createFor() {
        return new For();
    }

    @Override
    public For createFor(ASTList<LoopInitializer> inits, Expression guard, ASTList<Expression> updates, Statement body) {
        return new For(inits, guard, updates, body);
    }

    @Override
    public EnhancedFor createEnhancedFor() {
        return new EnhancedFor();
    }

    @Override
    public Assert createAssert() {
        return new Assert();
    }

    @Override
    public Assert createAssert(Expression cond) {
        return new Assert(cond);
    }

    @Override
    public Assert createAssert(Expression cond, Expression msg) {
        return new Assert(cond, msg);
    }

    @Override
    public If createIf() {
        return new If();
    }

    @Override
    public If createIf(Expression e, Statement thenStatement) {
        return new If(e, thenStatement);
    }

    @Override
    public If createIf(Expression e, Then thenBranch) {
        return new If(e, thenBranch);
    }

    @Override
    public If createIf(Expression e, Then thenBranch, Else elseBranch) {
        return new If(e, thenBranch, elseBranch);
    }

    @Override
    public If createIf(Expression e, Statement thenStatement, Statement elseStatement) {
        return new If(e, thenStatement, elseStatement);
    }

    @Override
    public LabeledStatement createLabeledStatement() {
        return new LabeledStatement();
    }

    @Override
    public LabeledStatement createLabeledStatement(Identifier id) {
        return new LabeledStatement(id);
    }

    @Override
    public LabeledStatement createLabeledStatement(Identifier id, Statement statement) {
        return new LabeledStatement(id, statement);
    }

    @Override
    public Return createReturn() {
        return new Return();
    }

    @Override
    public Return createReturn(Expression expr) {
        return new Return(expr);
    }

    @Override
    public StatementBlock createStatementBlock() {
        return new StatementBlock();
    }

    @Override
    public StatementBlock createStatementBlock(ASTList<Statement> block) {
        return new StatementBlock(block);
    }

    @Override
    public Switch createSwitch() {
        return new Switch();
    }

    @Override
    public Switch createSwitch(Expression e) {
        return new Switch(e);
    }

    @Override
    public Switch createSwitch(Expression e, ASTList<Branch> branches) {
        return new Switch(e, branches);
    }

    @Override
    public SynchronizedBlock createSynchronizedBlock() {
        return new SynchronizedBlock();
    }

    @Override
    public SynchronizedBlock createSynchronizedBlock(StatementBlock body) {
        return new SynchronizedBlock(body);
    }

    @Override
    public SynchronizedBlock createSynchronizedBlock(Expression e, StatementBlock body) {
        return new SynchronizedBlock(e, body);
    }

    @Override
    public Then createThen() {
        return new Then();
    }

    @Override
    public Then createThen(Statement body) {
        return new Then(body);
    }

    @Override
    public Throw createThrow() {
        return new Throw();
    }

    @Override
    public Throw createThrow(Expression expr) {
        return new Throw(expr);
    }

    @Override
    public Try createTry() {
        return new Try();
    }

    @Override
    public Try createTry(StatementBlock body) {
        return new Try(body);
    }

    @Override
    public Try createTry(StatementBlock body, ASTList<Branch> branches) {
        return new Try(body, branches);
    }

    @Override
    public While createWhile() {
        return new While();
    }

    @Override
    public While createWhile(Expression guard) {
        return new While(guard);
    }

    @Override
    public While createWhile(Expression guard, Statement body) {
        return new While(guard, body);
    }

    static {
        writer = new StringWriter();
        useAddNewlineReader = true;
    }

    private class AddNewlineReader
    extends Reader {
        private final Reader reader;
        private boolean added = false;

        AddNewlineReader(Reader reader) {
            this.reader = reader;
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.reader.mark(readAheadLimit);
        }

        @Override
        public boolean markSupported() {
            return this.reader.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.reader.read();
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            return this.reader.read(cbuf);
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            return this.reader.read(target);
        }

        @Override
        public boolean ready() throws IOException {
            return this.reader.ready();
        }

        @Override
        public void reset() throws IOException {
            this.reader.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.reader.skip(n);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.added) {
                return -1;
            }
            int result = this.reader.read(cbuf, off, len);
            if (!this.added && result < len) {
                if (result == -1) {
                    // empty if block
                }
                int n = ++result;
                ++result;
                cbuf[off + n] = 10;
                this.added = true;
            }
            return result;
        }
    }
}

