/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import java.util.ArrayList;
import java.util.List;
import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceVisitor;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.VariableDeclaration;
import recoder.java.reference.TypeReference;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;

public class FieldDeclaration
extends VariableDeclaration
implements MemberDeclaration {
    private static final long serialVersionUID = 2577966836277961911L;
    protected TypeDeclaration parent;
    protected ASTList<FieldSpecification> fieldSpecs;

    public FieldDeclaration() {
    }

    public FieldDeclaration(TypeReference typeRef, Identifier name) {
        this.setTypeReference(typeRef);
        ASTArrayList<boolean> list = new ASTArrayList<boolean>(true);
        list.add((boolean)this.getFactory().createFieldSpecification(name));
        this.setFieldSpecifications(list);
        this.makeParentRoleValid();
    }

    public FieldDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, Identifier name, Expression init) {
        this.setDeclarationSpecifiers(mods);
        this.setTypeReference(typeRef);
        ASTArrayList<boolean> list = new ASTArrayList<boolean>(true);
        list.add((boolean)this.getFactory().createFieldSpecification(name, init));
        this.setFieldSpecifications(list);
        this.makeParentRoleValid();
    }

    public FieldDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, ASTList<FieldSpecification> vars) {
        this.setDeclarationSpecifiers(mods);
        this.setTypeReference(typeRef);
        this.setFieldSpecifications(vars);
        this.makeParentRoleValid();
    }

    protected FieldDeclaration(FieldDeclaration proto) {
        super(proto);
        if (proto.fieldSpecs != null) {
            this.fieldSpecs = proto.fieldSpecs.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public FieldDeclaration deepClone() {
        return new FieldDeclaration(this);
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    @Override
    public TypeDeclaration getMemberParent() {
        return this.parent;
    }

    @Override
    public void setMemberParent(TypeDeclaration p) {
        this.parent = p;
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.fieldSpecs != null) {
            for (int i = this.fieldSpecs.size() - 1; i >= 0; --i) {
                ((FieldSpecification)this.fieldSpecs.get(i)).setParent(this);
            }
        }
    }

    public ASTList<FieldSpecification> getFieldSpecifications() {
        return this.fieldSpecs;
    }

    public void setFieldSpecifications(ASTList<FieldSpecification> l) {
        this.fieldSpecs = l;
    }

    public List<FieldSpecification> getVariables() {
        return new ArrayList<FieldSpecification>(this.fieldSpecs);
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.declarationSpecifiers != null) {
            result += this.declarationSpecifiers.size();
        }
        if (this.typeReference != null) {
            ++result;
        }
        if (this.fieldSpecs != null) {
            result += this.fieldSpecs.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.declarationSpecifiers != null) {
            int len = this.declarationSpecifiers.size();
            if (len > index) {
                return (ProgramElement)this.declarationSpecifiers.get(index);
            }
            index -= len;
        }
        if (this.typeReference != null) {
            if (index == 0) {
                return this.typeReference;
            }
            --index;
        }
        if (this.fieldSpecs != null) {
            return (ProgramElement)this.fieldSpecs.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.declarationSpecifiers != null && (index = this.declarationSpecifiers.indexOf(child)) >= 0) {
            return index << 4 | 0;
        }
        if (this.typeReference == child) {
            return 1;
        }
        if (this.fieldSpecs != null && (index = this.fieldSpecs.indexOf(child)) >= 0) {
            return index << 4 | 2;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        int i;
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.declarationSpecifiers == null ? 0 : this.declarationSpecifiers.size();
        for (i = 0; i < count; ++i) {
            if (this.declarationSpecifiers.get(i) != p) continue;
            if (q == null) {
                this.declarationSpecifiers.remove(i);
            } else {
                DeclarationSpecifier r = (DeclarationSpecifier)q;
                this.declarationSpecifiers.set(i, r);
                r.setParent(this);
            }
            return true;
        }
        if (this.typeReference == p) {
            TypeReference r;
            this.typeReference = r = (TypeReference)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        count = this.fieldSpecs == null ? 0 : this.fieldSpecs.size();
        for (i = 0; i < count; ++i) {
            if (this.fieldSpecs.get(i) != p) continue;
            if (q == null) {
                this.fieldSpecs.remove(i);
            } else {
                FieldSpecification r = (FieldSpecification)q;
                this.fieldSpecs.set(i, r);
                r.setParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isFinal() {
        return this.getASTParent() instanceof InterfaceDeclaration || super.isFinal();
    }

    @Override
    public boolean isPrivate() {
        return super.isPrivate();
    }

    @Override
    public boolean isProtected() {
        return super.isProtected();
    }

    @Override
    public boolean isPublic() {
        return this.getASTParent() instanceof InterfaceDeclaration || super.isPublic();
    }

    @Override
    public boolean isStatic() {
        return this.getASTParent() instanceof InterfaceDeclaration || super.isStatic();
    }

    @Override
    public boolean isTransient() {
        return !(this.getASTParent() instanceof InterfaceDeclaration) && super.isTransient();
    }

    @Override
    public boolean isStrictFp() {
        return super.isStrictFp();
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitFieldDeclaration(this);
    }
}

