/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import java.util.ArrayList;
import java.util.List;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.Type;
import recoder.convenience.Naming;
import recoder.java.Identifier;
import recoder.java.NamedProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ParameterContainer;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.TypeScope;
import recoder.java.VariableScope;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.JavaDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.declaration.Throws;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeDeclarationContainer;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.list.generic.ASTList;
import recoder.service.ProgramModelInfo;
import recoder.util.Debug;

public class MethodDeclaration
extends JavaDeclaration
implements MemberDeclaration,
TypeReferenceContainer,
NamedProgramElement,
ParameterContainer,
Method,
VariableScope,
TypeDeclarationContainer,
TypeScope {
    private static final long serialVersionUID = -5270980702156620518L;
    protected TypeDeclaration parent;
    protected TypeReference returnType;
    protected Identifier name;
    protected ASTList<ParameterDeclaration> parameters;
    protected Throws exceptions;
    protected StatementBlock body;
    protected ProgramModelInfo service;
    protected ASTList<TypeParameterDeclaration> typeParameters;

    public MethodDeclaration() {
    }

    public MethodDeclaration(ASTList<DeclarationSpecifier> modifiers, TypeReference returnType, Identifier name, ASTList<ParameterDeclaration> parameters, Throws exceptions) {
        super(modifiers);
        this.setTypeReference(returnType);
        this.setIdentifier(name);
        this.setParameters(parameters);
        this.setThrown(exceptions);
        this.makeParentRoleValid();
    }

    public MethodDeclaration(ASTList<DeclarationSpecifier> modifiers, TypeReference returnType, Identifier name, ASTList<ParameterDeclaration> parameters, Throws exceptions, StatementBlock body) {
        super(modifiers);
        this.setTypeReference(returnType);
        this.setIdentifier(name);
        this.setParameters(parameters);
        this.setThrown(exceptions);
        this.setBody(body);
        this.makeParentRoleValid();
    }

    protected MethodDeclaration(MethodDeclaration proto) {
        super(proto);
        if (proto.returnType != null) {
            this.returnType = proto.returnType.deepClone();
        }
        if (proto.name != null) {
            this.name = proto.name.deepClone();
        }
        if (proto.parameters != null) {
            this.parameters = proto.parameters.deepClone();
        }
        if (proto.exceptions != null) {
            this.exceptions = proto.exceptions.deepClone();
        }
        if (proto.body != null) {
            this.body = proto.body.deepClone();
        }
        if (proto.typeParameters != null) {
            this.typeParameters = proto.typeParameters.deepClone();
        }
        this.makeParentRoleValid();
    }

    private static void updateModel() {
        factory.getServiceConfiguration().getChangeHistory().updateModel();
    }

    @Override
    public MethodDeclaration deepClone() {
        return new MethodDeclaration(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.returnType != null) {
            this.returnType.setParent(this);
        }
        if (this.name != null) {
            this.name.setParent(this);
        }
        if (this.exceptions != null) {
            this.exceptions.setParent(this);
        }
        if (this.parameters != null) {
            for (int i = this.parameters.size() - 1; i >= 0; --i) {
                ((ParameterDeclaration)this.parameters.get(i)).setParameterContainer(this);
            }
        }
        if (this.body != null) {
            this.body.setStatementContainer(this);
        }
        if (this.typeParameters != null) {
            for (TypeParameterDeclaration tpd : this.typeParameters) {
                tpd.setParent(this);
            }
        }
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.declarationSpecifiers != null && (index = this.declarationSpecifiers.indexOf(child)) >= 0) {
            return index << 4 | 0;
        }
        if (this.returnType == child) {
            return 1;
        }
        if (this.name == child) {
            return 2;
        }
        if (this.parameters != null && (index = this.parameters.indexOf(child)) >= 0) {
            return index << 4 | 3;
        }
        if (this.exceptions == child) {
            return 4;
        }
        if (this.body == child) {
            return 5;
        }
        if (this.typeParameters != null && (index = this.typeParameters.indexOf(child)) != -1) {
            return index << 4 | 7;
        }
        return -1;
    }

    @Override
    public SourceElement getFirstElement() {
        ProgramElement ch = this.getChildAt(0);
        return ch instanceof TypeParameterDeclaration ? this : ch.getFirstElement();
    }

    @Override
    public SourceElement getLastElement() {
        return this.getChildAt(this.getChildCount() - 1).getLastElement();
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    @Override
    public TypeDeclaration getMemberParent() {
        return this.parent;
    }

    @Override
    public void setMemberParent(TypeDeclaration decl) {
        this.parent = decl;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.declarationSpecifiers != null) {
            result += this.declarationSpecifiers.size();
        }
        if (this.returnType != null) {
            ++result;
        }
        if (this.name != null) {
            ++result;
        }
        if (this.parameters != null) {
            result += this.parameters.size();
        }
        if (this.exceptions != null) {
            ++result;
        }
        if (this.body != null) {
            ++result;
        }
        if (this.typeParameters != null) {
            result += this.typeParameters.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        int len;
        if (this.declarationSpecifiers != null) {
            len = this.declarationSpecifiers.size();
            if (len > index) {
                return (ProgramElement)this.declarationSpecifiers.get(index);
            }
            index -= len;
        }
        if (this.typeParameters != null) {
            len = this.typeParameters.size();
            if (len > index) {
                return (ProgramElement)this.typeParameters.get(index);
            }
            index -= len;
        }
        if (this.returnType != null) {
            if (index == 0) {
                return this.returnType;
            }
            --index;
        }
        if (this.name != null) {
            if (index == 0) {
                return this.name;
            }
            --index;
        }
        if (this.parameters != null) {
            len = this.parameters.size();
            if (len > index) {
                return (ProgramElement)this.parameters.get(index);
            }
            index -= len;
        }
        if (this.exceptions != null) {
            if (index == 0) {
                return this.exceptions;
            }
            --index;
        }
        if (this.body != null) {
            if (index == 0) {
                return this.body;
            }
            --index;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getStatementCount() {
        return this.body != null ? 1 : 0;
    }

    @Override
    public Statement getStatementAt(int index) {
        if (this.body != null && index == 0) {
            return this.body;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        int i;
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.declarationSpecifiers == null ? 0 : this.declarationSpecifiers.size();
        for (i = 0; i < count; ++i) {
            if (this.declarationSpecifiers.get(i) != p) continue;
            if (q == null) {
                this.declarationSpecifiers.remove(i);
            } else {
                DeclarationSpecifier r = (DeclarationSpecifier)q;
                this.declarationSpecifiers.set(i, r);
                r.setParent(this);
            }
            return true;
        }
        if (this.returnType == p) {
            TypeReference r;
            this.returnType = r = (TypeReference)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.name == p) {
            Identifier r;
            this.name = r = (Identifier)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        count = this.parameters == null ? 0 : this.parameters.size();
        for (i = 0; i < count; ++i) {
            if (this.parameters.get(i) != p) continue;
            if (q == null) {
                this.parameters.remove(i);
            } else {
                ParameterDeclaration r = (ParameterDeclaration)q;
                this.parameters.set(i, r);
                r.setParameterContainer(this);
            }
            return true;
        }
        if (this.exceptions == p) {
            Throws r;
            this.exceptions = r = (Throws)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.body == p) {
            StatementBlock r;
            this.body = r = (StatementBlock)q;
            if (r != null) {
                r.setStatementContainer(this);
            }
            return true;
        }
        if (this.typeParameters != null && (i = this.typeParameters.indexOf(p)) != -1) {
            if (q == null) {
                this.typeParameters.remove(i);
            } else {
                this.typeParameters.set(i, (TypeParameterDeclaration)q);
                ((TypeParameterDeclaration)q).setParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getTypeReferenceCount() {
        return this.returnType != null ? 1 : 0;
    }

    @Override
    public TypeReference getTypeReferenceAt(int index) {
        if (this.returnType != null && index == 0) {
            return this.returnType;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getParameterDeclarationCount() {
        return this.parameters != null ? this.parameters.size() : 0;
    }

    @Override
    public ParameterDeclaration getParameterDeclarationAt(int index) {
        if (this.parameters != null) {
            return (ParameterDeclaration)this.parameters.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public TypeReference getTypeReference() {
        return this.returnType;
    }

    public void setTypeReference(TypeReference type) {
        this.returnType = type;
    }

    @Override
    public final String getName() {
        return this.name == null ? null : this.name.getText();
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    @Override
    public void setIdentifier(Identifier id) {
        this.name = id;
    }

    public ASTList<ParameterDeclaration> getParameters() {
        return this.parameters;
    }

    public void setParameters(ASTList<ParameterDeclaration> list) {
        this.parameters = list;
    }

    public Throws getThrown() {
        return this.exceptions;
    }

    public void setThrown(Throws exceptions) {
        this.exceptions = exceptions;
    }

    public StatementBlock getBody() {
        return this.body;
    }

    public void setBody(StatementBlock body) {
        this.body = body;
    }

    @Override
    public boolean isFinal() {
        return super.isFinal();
    }

    @Override
    public boolean isPrivate() {
        return super.isPrivate();
    }

    @Override
    public boolean isProtected() {
        return super.isProtected();
    }

    @Override
    public boolean isPublic() {
        return this.getASTParent() instanceof InterfaceDeclaration || super.isPublic();
    }

    @Override
    public boolean isStatic() {
        return super.isStatic();
    }

    @Override
    public boolean isStrictFp() {
        return super.isStrictFp();
    }

    @Override
    public boolean isAbstract() {
        return this.getASTParent() instanceof InterfaceDeclaration || super.isAbstract();
    }

    @Override
    public boolean isNative() {
        return super.isNative();
    }

    @Override
    public boolean isSynchronized() {
        return super.isSynchronized();
    }

    @Override
    public ProgramModelInfo getProgramModelInfo() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            MethodDeclaration.updateModel();
        }
        return this.service;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo service) {
        this.service = service;
    }

    @Override
    public ClassType getContainingClassType() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            MethodDeclaration.updateModel();
        }
        return this.service.getContainingClassType(this);
    }

    @Override
    public Type getReturnType() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            MethodDeclaration.updateModel();
        }
        return this.service.getReturnType(this);
    }

    @Override
    public List<Type> getSignature() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            MethodDeclaration.updateModel();
        }
        return this.service.getSignature(this);
    }

    @Override
    public List<ClassType> getExceptions() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            MethodDeclaration.updateModel();
        }
        return this.service.getExceptions(this);
    }

    @Override
    public ClassTypeContainer getContainer() {
        return this.getContainingClassType();
    }

    @Override
    public Package getPackage() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            MethodDeclaration.updateModel();
        }
        return this.service.getPackage(this);
    }

    public List<TypeDeclaration> getTypes() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            MethodDeclaration.updateModel();
        }
        return this.getBody() == null ? new ArrayList(0) : this.getBody().getTypesInScope();
    }

    @Override
    public String getFullName() {
        return Naming.getFullName(this);
    }

    @Override
    public boolean isDefinedScope() {
        return true;
    }

    @Override
    public void setDefinedScope(boolean defined) {
    }

    public List<VariableSpecification> getVariablesInScope() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return new ArrayList<VariableSpecification>(0);
        }
        int s = this.parameters.size();
        ArrayList<VariableSpecification> res = new ArrayList<VariableSpecification>(s);
        for (int i = 0; i < s; ++i) {
            res.add(((ParameterDeclaration)this.parameters.get(i)).getVariableSpecification());
        }
        return res;
    }

    @Override
    public VariableSpecification getVariableInScope(String tname) {
        Debug.assertNonnull(tname);
        if (this.parameters == null) {
            return null;
        }
        int s = this.parameters.size();
        for (int i = 0; i < s; ++i) {
            VariableSpecification res = ((ParameterDeclaration)this.parameters.get(i)).getVariableSpecification();
            if (!tname.equals(res.getName())) continue;
            return res;
        }
        return null;
    }

    @Override
    public void addVariableToScope(VariableSpecification var) {
        Debug.assertNonnull(var);
    }

    @Override
    public void removeVariableFromScope(String tname) {
        Debug.assertNonnull(tname);
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitMethodDeclaration(this);
    }

    @Override
    public boolean isVarArgMethod() {
        if (this.parameters == null || this.parameters.size() == 0) {
            return false;
        }
        return ((ParameterDeclaration)this.parameters.get(this.parameters.size() - 1)).isVarArg();
    }

    public ASTList<TypeParameterDeclaration> getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(ASTList<TypeParameterDeclaration> typeParameters) {
        this.typeParameters = typeParameters;
    }

    @Override
    public int getTypeDeclarationCount() {
        return this.typeParameters == null ? 0 : this.typeParameters.size();
    }

    @Override
    public TypeDeclaration getTypeDeclarationAt(int index) {
        if (this.typeParameters == null) {
            throw new IndexOutOfBoundsException();
        }
        return (TypeDeclaration)this.typeParameters.get(index);
    }

    public List<TypeDeclaration> getTypesInScope() {
        if (this.typeParameters == null || this.typeParameters.isEmpty()) {
            return new ArrayList<TypeDeclaration>(0);
        }
        ArrayList<TypeDeclaration> ctl = new ArrayList<TypeDeclaration>(this.typeParameters.size());
        for (TypeParameterDeclaration t : this.typeParameters) {
            ctl.add(t);
        }
        return ctl;
    }

    @Override
    public ClassType getTypeInScope(String typename) {
        if (this.typeParameters == null) {
            return null;
        }
        for (TypeParameterDeclaration tpd : this.typeParameters) {
            if (!typename.equals(tpd.getName())) continue;
            return tpd;
        }
        return null;
    }

    @Override
    public void addTypeToScope(ClassType type, String name) {
    }

    @Override
    public void removeTypeFromScope(String name) {
    }
}

