/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.expression;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceVisitor;
import recoder.list.generic.ASTList;

public class ElementValueArrayInitializer
extends JavaNonTerminalProgramElement
implements Expression,
ExpressionContainer {
    private static final long serialVersionUID = -3857746318263472090L;
    protected ExpressionContainer parent;
    protected ASTList<Expression> elementValues;

    public ElementValueArrayInitializer() {
    }

    protected ElementValueArrayInitializer(ElementValueArrayInitializer proto) {
        super(proto);
        if (proto.elementValues != null) {
            this.elementValues = proto.elementValues.deepClone();
        }
    }

    @Override
    public ExpressionContainer getExpressionContainer() {
        return this.parent;
    }

    @Override
    public void setExpressionContainer(ExpressionContainer c) {
        this.parent = c;
    }

    @Override
    public ElementValueArrayInitializer deepClone() {
        return new ElementValueArrayInitializer(this);
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitElementValueArrayInitializer(this);
    }

    @Override
    public int getExpressionCount() {
        return this.elementValues == null ? 0 : this.elementValues.size();
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.elementValues != null) {
            return (Expression)this.elementValues.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildCount() {
        return this.getExpressionCount();
    }

    @Override
    public ProgramElement getChildAt(int index) {
        return this.getExpressionAt(index);
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (this.elementValues == null) {
            return -1;
        }
        int idx = this.elementValues.indexOf(child);
        if (idx != -1) {
            return idx << 4;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.elementValues == null ? 0 : this.elementValues.size();
        for (int i = 0; i < count; ++i) {
            if (this.elementValues.get(i) != p) continue;
            if (q == null) {
                this.elementValues.remove(i);
            } else {
                Expression r = (Expression)q;
                this.elementValues.set(i, r);
                r.setExpressionContainer(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.elementValues != null) {
            for (Expression e : this.elementValues) {
                e.setExpressionContainer(this);
            }
        }
    }

    public ASTList<Expression> getElementValues() {
        return this.elementValues;
    }

    public void setElementValues(ASTList<Expression> elementValues) {
        this.elementValues = elementValues;
    }
}

