/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.expression.operator;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.expression.ArrayInitializer;
import recoder.java.expression.operator.TypeOperator;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.TypeReference;
import recoder.list.generic.ASTList;

public class NewArray
extends TypeOperator
implements Reference,
ReferencePrefix {
    private static final long serialVersionUID = 836360320945022449L;
    protected int dimensions;
    protected ArrayInitializer arrayInitializer;
    protected ReferenceSuffix referenceParent;

    public NewArray() {
    }

    public NewArray(TypeReference arrayName, ASTList<Expression> dimExpr) {
        this.setTypeReference(arrayName);
        this.setArguments(dimExpr);
        this.makeParentRoleValid();
    }

    public NewArray(TypeReference arrayName, int dimensions, ArrayInitializer initializer) {
        this.setTypeReference(arrayName);
        this.setDimensions(dimensions);
        this.setArrayInitializer(initializer);
        this.makeParentRoleValid();
    }

    protected NewArray(NewArray proto) {
        super(proto);
        if (proto.arrayInitializer != null) {
            this.arrayInitializer = proto.arrayInitializer.deepClone();
        }
        this.dimensions = proto.dimensions;
        this.makeParentRoleValid();
    }

    @Override
    public NewArray deepClone() {
        return new NewArray(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.arrayInitializer != null) {
            this.arrayInitializer.setExpressionContainer(this);
        }
    }

    @Override
    public SourceElement getLastElement() {
        if (this.arrayInitializer != null) {
            return this.arrayInitializer.getLastElement();
        }
        return this;
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.children != null && (index = this.children.indexOf(child)) >= 0) {
            return index << 4 | 0;
        }
        if (this.typeReference == child) {
            return 1;
        }
        if (this.arrayInitializer == child) {
            return 3;
        }
        return -1;
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        if (this.expressionParent != null) {
            return this.expressionParent;
        }
        return this.referenceParent;
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public int getNotation() {
        return 0;
    }

    @Override
    public ReferenceSuffix getReferenceSuffix() {
        return this.referenceParent;
    }

    @Override
    public void setReferenceSuffix(ReferenceSuffix path) {
        this.referenceParent = path;
    }

    @Override
    public ExpressionContainer getExpressionContainer() {
        return this.expressionParent;
    }

    @Override
    public void setExpressionContainer(ExpressionContainer parent) {
        this.expressionParent = parent;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int dim) {
        this.dimensions = dim;
    }

    public ArrayInitializer getArrayInitializer() {
        return this.arrayInitializer;
    }

    public void setArrayInitializer(ArrayInitializer init) {
        this.arrayInitializer = init;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.typeReference != null) {
            ++result;
        }
        if (this.children != null) {
            result += this.children.size();
        }
        if (this.arrayInitializer != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.typeReference != null) {
            if (index == 0) {
                return this.typeReference;
            }
            --index;
        }
        if (this.children != null) {
            int len = this.children.size();
            if (len > index) {
                return (ProgramElement)this.children.get(index);
            }
            index -= len;
        }
        if (this.arrayInitializer != null && index == 0) {
            return this.arrayInitializer;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getExpressionCount() {
        int result = 0;
        if (this.children != null) {
            result += this.children.size();
        }
        if (this.arrayInitializer != null) {
            ++result;
        }
        return result;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.children != null) {
            int len = this.children.size();
            if (len > index) {
                return (Expression)this.children.get(index);
            }
            index -= len;
        }
        if (this.arrayInitializer != null && index == 0) {
            return this.arrayInitializer;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.children == null ? 0 : this.children.size();
        for (int i = 0; i < count; ++i) {
            if (this.children.get(i) != p) continue;
            if (q == null) {
                this.children.remove(i);
            } else {
                Expression r = (Expression)q;
                this.children.set(i, r);
                r.setExpressionContainer(this);
            }
            return true;
        }
        if (this.typeReference == p) {
            TypeReference r;
            this.typeReference = r = (TypeReference)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.arrayInitializer == p) {
            ArrayInitializer r;
            this.arrayInitializer = r = (ArrayInitializer)q;
            if (r != null) {
                r.setExpressionContainer(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitNewArray(this);
    }
}

