/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.statement;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.Statement;
import recoder.java.statement.Branch;
import recoder.java.statement.Switch;
import recoder.list.generic.ASTList;

public class Case
extends Branch
implements ExpressionContainer {
    private static final long serialVersionUID = 4344680443480425524L;
    protected Expression expression;
    protected ASTList<Statement> body;

    public Case() {
    }

    public Case(Expression e) {
        this.setExpression(e);
        this.makeParentRoleValid();
    }

    public Case(Expression e, ASTList<Statement> body) {
        this.setBody(body);
        this.setExpression(e);
        this.makeParentRoleValid();
    }

    protected Case(Case proto) {
        super(proto);
        if (proto.expression != null) {
            this.expression = proto.expression.deepClone();
        }
        if (proto.body != null) {
            this.body = proto.body.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public Case deepClone() {
        return new Case(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.expression != null) {
            this.expression.setExpressionContainer(this);
        }
        if (this.body != null) {
            for (int i = 0; i < this.body.size(); ++i) {
                ((Statement)this.body.get(i)).setStatementContainer(this);
            }
        }
    }

    @Override
    public Switch getParent() {
        return (Switch)this.parent;
    }

    public void setParent(Switch parent) {
        this.parent = parent;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.expression != null) {
            ++result;
        }
        if (this.body != null) {
            result += this.body.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.expression != null) {
            if (index == 0) {
                return this.expression;
            }
            --index;
        }
        if (this.body != null) {
            int len = this.body.size();
            if (len > index) {
                return (ProgramElement)this.body.get(index);
            }
            index -= len;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.expression == child) {
            return 0;
        }
        if (this.body != null && (index = this.body.indexOf(child)) >= 0) {
            return index << 4 | 1;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.expression == p) {
            Expression r;
            this.expression = r = (Expression)q;
            if (r != null) {
                r.setExpressionContainer(this);
            }
            return true;
        }
        int count = this.body == null ? 0 : this.body.size();
        for (int i = 0; i < count; ++i) {
            if (this.body.get(i) != p) continue;
            if (q == null) {
                this.body.remove(i);
            } else {
                Statement r = (Statement)q;
                this.body.set(i, r);
                r.setStatementContainer(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getExpressionCount() {
        return this.expression != null ? 1 : 0;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.expression != null && index == 0) {
            return this.expression;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getStatementCount() {
        return this.body != null ? this.body.size() : 0;
    }

    @Override
    public Statement getStatementAt(int index) {
        if (this.body != null) {
            return (Statement)this.body.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression e) {
        if (e == null) {
            throw new NullPointerException("Cases must have an expression");
        }
        this.expression = e;
    }

    public ASTList<Statement> getBody() {
        return this.body;
    }

    public void setBody(ASTList<Statement> list) {
        this.body = list;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitCase(this);
    }

    @Override
    public SourceElement getLastElement() {
        if (this.body == null || this.body.size() == 0) {
            return this;
        }
        return ((Statement)this.body.get(this.body.size() - 1)).getLastElement();
    }
}

