/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.statement;

import recoder.java.Identifier;
import recoder.java.NamedProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.Statement;
import recoder.java.StatementContainer;
import recoder.java.statement.JavaStatement;

public class LabeledStatement
extends JavaStatement
implements StatementContainer,
NamedProgramElement {
    private static final long serialVersionUID = -4621689270408033058L;
    protected Identifier name;
    protected Statement body;

    public LabeledStatement() {
    }

    public LabeledStatement(Identifier id) {
        this.setIdentifier(id);
        this.setBody(this.getFactory().createEmptyStatement());
        this.makeParentRoleValid();
    }

    public LabeledStatement(Identifier id, Statement statement) {
        this.setIdentifier(id);
        this.setBody(statement);
        this.makeParentRoleValid();
    }

    protected LabeledStatement(LabeledStatement proto) {
        super(proto);
        if (proto.name != null) {
            this.name = proto.name.deepClone();
        }
        if (proto.body != null) {
            this.body = proto.body.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public LabeledStatement deepClone() {
        return new LabeledStatement(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.name != null) {
            this.name.setParent(this);
        }
        if (this.body != null) {
            this.body.setStatementContainer(this);
        }
    }

    @Override
    public SourceElement getFirstElement() {
        return this.getChildAt(0).getFirstElement();
    }

    @Override
    public SourceElement getLastElement() {
        return this.body.getLastElement();
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.name == p) {
            Identifier r;
            this.name = r = (Identifier)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.body == p) {
            Statement r;
            this.body = r = (Statement)q;
            if (r != null) {
                r.setStatementContainer(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public final String getName() {
        return this.name == null ? null : this.name.getText();
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    @Override
    public void setIdentifier(Identifier id) {
        this.name = id;
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(Statement s) {
        this.body = s;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.name != null) {
            ++result;
        }
        if (this.body != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.name != null) {
            if (index == 0) {
                return this.name;
            }
            --index;
        }
        if (this.body != null) {
            if (index == 0) {
                return this.body;
            }
            --index;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (this.name == child) {
            return 0;
        }
        if (this.body == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getStatementCount() {
        return this.body != null ? 1 : 0;
    }

    @Override
    public Statement getStatementAt(int index) {
        if (this.body != null && index == 0) {
            return this.body;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitLabeledStatement(this);
    }
}

