/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.statement;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.LoopInitializer;
import recoder.java.ProgramElement;
import recoder.java.Statement;
import recoder.java.StatementContainer;
import recoder.java.expression.ExpressionStatement;
import recoder.java.statement.JavaStatement;
import recoder.list.generic.ASTList;

public abstract class LoopStatement
extends JavaStatement
implements StatementContainer,
ExpressionContainer {
    protected Expression guard;
    protected ASTList<LoopInitializer> inits;
    protected ASTList<Expression> updates;
    protected Statement body;

    public LoopStatement() {
    }

    public LoopStatement(Statement body) {
        this.setBody(body);
    }

    protected LoopStatement(LoopStatement proto) {
        super(proto);
        if (proto.guard != null) {
            this.guard = proto.guard.deepClone();
        }
        if (proto.inits != null) {
            this.inits = proto.inits.deepClone();
        }
        if (proto.updates != null) {
            this.updates = proto.updates.deepClone();
        }
        if (proto.body != null) {
            this.body = proto.body.deepClone();
        }
    }

    @Override
    public void makeParentRoleValid() {
        int i;
        super.makeParentRoleValid();
        if (this.inits != null) {
            for (i = this.inits.size() - 1; i >= 0; --i) {
                LoopInitializer li = (LoopInitializer)this.inits.get(i);
                if (li instanceof ExpressionStatement) {
                    ((ExpressionStatement)li).setExpressionContainer(this);
                    continue;
                }
                li.setStatementContainer(this);
            }
        }
        if (this.guard != null) {
            this.guard.setExpressionContainer(this);
        }
        if (this.updates != null) {
            for (i = this.updates.size() - 1; i >= 0; --i) {
                ((Expression)this.updates.get(i)).setExpressionContainer(this);
            }
        }
        if (this.body != null) {
            this.body.setStatementContainer(this);
        }
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.inits != null) {
            result += this.inits.size();
        }
        if (this.guard != null) {
            ++result;
        }
        if (this.updates != null) {
            result += this.updates.size();
        }
        if (this.body != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        int len;
        if (this.inits != null) {
            len = this.inits.size();
            if (len > index) {
                return (ProgramElement)this.inits.get(index);
            }
            index -= len;
        }
        if (this.isCheckedBeforeIteration() && this.guard != null) {
            if (index == 0) {
                return this.guard;
            }
            --index;
        }
        if (this.updates != null) {
            len = this.updates.size();
            if (len > index) {
                return (ProgramElement)this.updates.get(index);
            }
            index -= len;
        }
        if (this.body != null) {
            if (index == 0) {
                return this.body;
            }
            --index;
        }
        if (!this.isCheckedBeforeIteration() && this.guard != null) {
            if (index == 0) {
                return this.guard;
            }
            --index;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.inits != null && (index = this.inits.indexOf(child)) >= 0) {
            return index << 4 | 0;
        }
        if (this.guard == child) {
            return 1;
        }
        if (this.updates != null && (index = this.updates.indexOf(child)) >= 0) {
            return index << 4 | 2;
        }
        if (this.body == child) {
            return 3;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        int i;
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.inits == null ? 0 : this.inits.size();
        for (i = 0; i < count; ++i) {
            if (this.inits.get(i) != p) continue;
            if (q == null) {
                this.inits.remove(i);
            } else {
                LoopInitializer r = (LoopInitializer)q;
                this.inits.set(i, r);
                if (r instanceof ExpressionStatement) {
                    ((ExpressionStatement)r).setExpressionContainer(this);
                } else {
                    r.setStatementContainer(this);
                }
            }
            return true;
        }
        if (this.guard == p) {
            Expression r;
            this.guard = r = (Expression)q;
            if (r != null) {
                r.setExpressionContainer(this);
            }
            return true;
        }
        count = this.updates == null ? 0 : this.updates.size();
        for (i = 0; i < count; ++i) {
            if (this.updates.get(i) != p) continue;
            if (q == null) {
                this.updates.remove(i);
            } else {
                Expression r = (Expression)q;
                this.updates.set(i, r);
                r.setExpressionContainer(this);
            }
            return true;
        }
        if (this.body == p) {
            Statement r;
            this.body = r = (Statement)q;
            if (r != null) {
                r.setStatementContainer(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getExpressionCount() {
        int result = 0;
        if (this.guard != null) {
            ++result;
        }
        if (this.inits != null) {
            for (int i = this.inits.size() - 1; i >= 0; --i) {
                if (!(this.inits.get(i) instanceof Expression)) continue;
                ++result;
            }
        }
        if (this.updates != null) {
            result += this.updates.size();
        }
        return result;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.guard != null) {
            if (index == 0) {
                return this.guard;
            }
            --index;
        }
        if (this.inits != null) {
            int s = this.inits.size();
            for (int i = 0; i < s && index >= 0; ++i) {
                LoopInitializer ii = (LoopInitializer)this.inits.get(i);
                if (!(ii instanceof Expression)) continue;
                if (index == 0) {
                    return (Expression)((Object)ii);
                }
                --index;
            }
        }
        if (this.updates != null) {
            return (Expression)this.updates.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Expression getGuard() {
        return this.guard;
    }

    public void setGuard(Expression expr) {
        this.guard = expr;
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(Statement statement) {
        this.body = statement;
    }

    @Override
    public int getStatementCount() {
        return this.body != null ? 1 : 0;
    }

    @Override
    public Statement getStatementAt(int index) {
        if (this.body != null && index == 0) {
            return this.body;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public ASTList<LoopInitializer> getInitializers() {
        return this.inits;
    }

    public void setInitializers(ASTList<LoopInitializer> list) {
        this.inits = list;
    }

    public ASTList<Expression> getUpdates() {
        return this.updates;
    }

    public void setUpdates(ASTList<Expression> list) {
        this.updates = list;
    }

    public abstract boolean isExitCondition();

    public abstract boolean isCheckedBeforeIteration();
}

