/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.statement;

import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.StatementContainer;
import recoder.java.statement.Branch;
import recoder.java.statement.BranchStatement;
import recoder.java.statement.Catch;
import recoder.java.statement.Finally;
import recoder.list.generic.ASTList;

public class Try
extends BranchStatement
implements StatementContainer {
    private static final long serialVersionUID = -6939974882487466260L;
    protected StatementBlock body;
    protected ASTList<Branch> branches;

    public Try() {
    }

    public Try(StatementBlock body) {
        this.setBody(body);
        this.makeParentRoleValid();
    }

    public Try(StatementBlock body, ASTList<Branch> branches) {
        this.setBranchList(branches);
        this.setBody(body);
        this.makeParentRoleValid();
    }

    protected Try(Try proto) {
        super(proto);
        if (proto.body != null) {
            this.body = proto.body.deepClone();
        }
        if (proto.branches != null) {
            this.branches = proto.branches.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public Try deepClone() {
        return new Try(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.body != null) {
            this.body.setStatementContainer(this);
        }
        if (this.branches != null) {
            for (int i = this.branches.size() - 1; i >= 0; --i) {
                Branch b = (Branch)this.branches.get(i);
                if (b instanceof Catch) {
                    ((Catch)b).setParent(this);
                    continue;
                }
                ((Finally)b).setParent(this);
            }
        }
    }

    @Override
    public SourceElement getLastElement() {
        return this.getChildAt(this.getChildCount() - 1).getLastElement();
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.body != null) {
            ++result;
        }
        if (this.branches != null) {
            result += this.branches.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.body != null) {
            if (index == 0) {
                return this.body;
            }
            --index;
        }
        if (this.branches != null) {
            return (ProgramElement)this.branches.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.body == child) {
            return 0;
        }
        if (this.branches != null && (index = this.branches.indexOf(child)) >= 0) {
            return index << 4 | 1;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.body == p) {
            StatementBlock r;
            this.body = r = (StatementBlock)q;
            if (r != null) {
                r.setStatementContainer(this);
            }
            return true;
        }
        int count = this.branches == null ? 0 : this.branches.size();
        for (int i = 0; i < count; ++i) {
            if (this.branches.get(i) != p) continue;
            if (q == null) {
                this.branches.remove(i);
            } else if (q instanceof Catch) {
                this.branches.set(i, (Catch)q);
                ((Catch)q).setParent(this);
            } else {
                this.branches.set(i, (Finally)q);
                ((Finally)q).setParent(this);
            }
            return true;
        }
        return false;
    }

    public StatementBlock getBody() {
        return this.body;
    }

    public void setBody(StatementBlock body) {
        this.body = body;
    }

    @Override
    public int getStatementCount() {
        return this.body != null ? 1 : 0;
    }

    @Override
    public Statement getStatementAt(int index) {
        if (this.body != null && index == 0) {
            return this.body;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public ASTList<Branch> getBranchList() {
        return this.branches;
    }

    public void setBranchList(ASTList<Branch> branches) {
        this.branches = branches;
    }

    @Override
    public int getBranchCount() {
        return this.branches != null ? this.branches.size() : 0;
    }

    @Override
    public Branch getBranchAt(int index) {
        if (this.branches != null) {
            return (Branch)this.branches.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitTry(this);
    }
}

