/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import recoder.ProgramFactory;
import recoder.java.DocComment;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.declaration.Throws;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.reference.TypeReference;
import recoder.kit.MiscKit;
import recoder.list.generic.ASTList;
import recoder.service.NameInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public class CommentKit {
    private CommentKit() {
    }

    public static DocComment createDoc(MethodDeclaration method, boolean dummy) {
        Throws th;
        Debug.assertNonnull(method);
        StringBuffer text = new StringBuffer("/**\n");
        if (dummy) {
            text.append("  ");
            text.append(CommentKit.guessDocumentation(method.getName(), true));
            text.append("\n");
        }
        int c = method.getParameterDeclarationCount();
        for (int i = 0; i < c; ++i) {
            ParameterDeclaration param = method.getParameterDeclarationAt(i);
            text.append("  @param " + param.getVariables().get(0).getName() + " ");
            if (dummy) {
                text.append(CommentKit.guessDocumentation(param.getTypeReference(), false));
            }
            text.append('\n');
        }
        TypeReference ret = method.getTypeReference();
        if (ret != null && !"void".equals(ret.getName())) {
            text.append("  @return ");
            if (dummy) {
                text.append(CommentKit.guessDocumentation(ret, true));
            }
            text.append('\n');
        }
        if ((th = method.getThrown()) != null) {
            ASTList<TypeReference> excepts = th.getExceptions();
            for (int i = 0; i < excepts.size(); ++i) {
                TypeReference tr = (TypeReference)excepts.get(i);
                text.append("  @exception " + tr.getName());
                if (!dummy) continue;
                text.append(" occasionally thrown.\n");
            }
        }
        text.append("*/");
        return method.getFactory().createDocComment(text.toString());
    }

    public static DocComment createDoc(FieldDeclaration field, boolean dummy) {
        Debug.assertNonnull(field);
        ProgramFactory factory = field.getFactory();
        if (dummy) {
            String name = field.getVariables().get(0).getName();
            return factory.createDocComment("/**\n  " + CommentKit.guessDocumentation(name, true) + "\n*/");
        }
        return factory.createDocComment("/**\n  \n*/");
    }

    public static DocComment createDoc(SourceInfo si, NameInfo ni, FieldDeclaration field, boolean dummy) {
        Debug.assertNonnull(field);
        TypeDeclaration td = MiscKit.getParentTypeDeclaration(field);
        boolean isSerial = td instanceof ClassDeclaration ? si.isSubtype(td, ni.getJavaIoSerializable()) : false;
        ProgramFactory factory = field.getFactory();
        if (dummy) {
            String name = field.getVariables().get(0).getName();
            return factory.createDocComment("/**\n  " + CommentKit.guessDocumentation(name, true) + (isSerial ? "\n  @serial" : "") + "\n*/");
        }
        return factory.createDocComment("/**\n  " + (isSerial ? "\n  @serial" : "") + "n*/");
    }

    public static DocComment createDoc(TypeDeclaration type, boolean dummy) {
        Debug.assertNonnull(type);
        ProgramFactory factory = type.getFactory();
        if (dummy) {
            String name = type.getName();
            return factory.createDocComment("/**\n  " + CommentKit.guessDocumentation(name, true) + "\n  @author \n*/");
        }
        return factory.createDocComment("/**\n  \n*/");
    }

    static String guessDocumentation(TypeReference tr, boolean returned) {
        Object tn = tr.getName();
        if (tr.getDimensions() == 0 && (((String)tn).equals("int") || ((String)tn).equals("boolean") || ((String)tn).equals("short") || ((String)tn).equals("long") || ((String)tn).equals("byte") || ((String)tn).equals("char") || ((String)tn).equals("float") || ((String)tn).equals("double"))) {
            tn = (String)tn + " value";
        }
        String ty = CommentKit.guessDocumentation((String)tn, false);
        switch (tr.getDimensions()) {
            case 0: {
                if (returned) {
                    return "the " + ty;
                }
                if ("aeiouAEIOU".indexOf(ty.charAt(0)) >= 0) {
                    return "an " + ty;
                }
                return "a " + ty;
            }
            case 1: {
                return (returned ? "the" : "an") + " array of " + ty;
            }
            case 2: {
                return (returned ? "the" : "a") + " matrix of " + ty;
            }
        }
        return (returned ? "the" : "a") + " multi-dimensional array of " + ty;
    }

    static String guessDocumentation(String name, boolean capital) {
        int len = name.length();
        StringBuffer res = new StringBuffer(len + 6);
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i < len - 1 && Character.isUpperCase(name.charAt(i + 1))) {
                    if (i > 0 && !Character.isUpperCase(name.charAt(i - 1))) {
                        res.append(' ');
                    }
                    res.append(ch);
                    continue;
                }
                if (i > 0) {
                    res.append(' ');
                }
                res.append(Character.toLowerCase(ch));
                continue;
            }
            res.append(ch);
        }
        if (capital) {
            res.setCharAt(0, Character.toUpperCase(res.charAt(0)));
        }
        res.append('.');
        return res.toString();
    }
}

