/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import recoder.ProgramFactory;
import recoder.abstraction.ClassType;
import recoder.abstraction.Constructor;
import recoder.abstraction.Method;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.convenience.Naming;
import recoder.convenience.TreeWalker;
import recoder.java.Comment;
import recoder.java.DocComment;
import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.JavaProgramFactory;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ParameterContainer;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.modifier.Abstract;
import recoder.java.declaration.modifier.VisibilityModifier;
import recoder.java.expression.operator.CopyAssignment;
import recoder.java.expression.operator.New;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.statement.Return;
import recoder.kit.DifferentReturnTypeOverwrite;
import recoder.kit.FinalOverwrite;
import recoder.kit.IllegalInterfaceMember;
import recoder.kit.IllegalName;
import recoder.kit.MiscKit;
import recoder.kit.MorePrivateOverwrite;
import recoder.kit.NameConflict;
import recoder.kit.NonStaticOverwrite;
import recoder.kit.Problem;
import recoder.kit.TypeKit;
import recoder.kit.UncoveredExceptionsOverwrite;
import recoder.kit.VariableKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.ChangeHistory;
import recoder.service.CrossReferenceSourceInfo;
import recoder.service.NameInfo;
import recoder.service.ProgramModelInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;
import recoder.util.Queue;

public class MethodKit {
    private MethodKit() {
    }

    public static ASTList<Expression> createArguments(ParameterContainer p) {
        int c = p.getParameterDeclarationCount();
        ASTArrayList<int> res = new ASTArrayList<int>(c);
        for (int i = 0; i < c; ++i) {
            res.add((int)VariableKit.createVariableReference(p.getParameterDeclarationAt(i)));
        }
        return res;
    }

    public static MethodReference createMethodReference(MethodDeclaration decl) {
        ProgramFactory factory = decl.getFactory();
        return factory.createMethodReference(factory.createIdentifier(decl.getName()), MethodKit.createArguments(decl));
    }

    public static MethodReference createMethodReference(ReferencePrefix prefix, MethodDeclaration decl) {
        ProgramFactory factory = decl.getFactory();
        return factory.createMethodReference(prefix, factory.createIdentifier(decl.getName()), MethodKit.createArguments(decl));
    }

    public static New createNew(ConstructorDeclaration decl) {
        return decl.getFactory().createNew(null, TypeKit.createTypeReference(decl), MethodKit.createArguments(decl));
    }

    public static MethodDeclaration createAbstractMethodDeclaration(MethodDeclaration decl, boolean forInterface) {
        ProgramFactory factory = decl.getFactory();
        if (decl.isStatic()) {
            throw new IllegalArgumentException("A static method cannot made abstract!");
        }
        StatementBlock body = decl.getBody();
        decl.setBody(null);
        MethodDeclaration res = decl.deepClone();
        decl.setBody(body);
        Abstract anAbstract = factory.createAbstract();
        ASTList<DeclarationSpecifier> modList = res.getDeclarationSpecifiers();
        int abstractPos = modList == null ? -1 : modList.indexOf(anAbstract);
        VisibilityModifier vismod = res.getVisibilityModifier();
        if (forInterface) {
            if (abstractPos >= 0) {
                modList.remove(abstractPos);
            }
            if (vismod != null) {
                modList.remove(vismod);
            }
        } else if (abstractPos < 0) {
            if (modList == null) {
                modList = new ASTArrayList<boolean>(true);
                res.setDeclarationSpecifiers(modList);
            }
            modList.add(vismod == null ? 0 : 1, anAbstract);
        } else {
            return res;
        }
        return res;
    }

    public static MethodDeclaration createAdapterMethod(ReferencePrefix delegationObject, MethodDeclaration method) {
        MethodDeclaration clone = method.deepClone();
        clone.setComments(new ASTArrayList<Comment>(new DocComment("/** generated by createAdapterMethod */")));
        clone.setBody(new StatementBlock(new ASTArrayList<Statement>()));
        MethodReference call = MethodKit.createMethodReference(delegationObject, method);
        clone.getBody().getBody().add(call);
        return clone;
    }

    public static ClassDeclaration createPackerClass(String packerClassName, List<ParameterDeclaration> parameters) {
        ParameterDeclaration parameter;
        Debug.printlno("debugPackifier", "creating packer class " + packerClassName);
        JavaProgramFactory factory = JavaProgramFactory.getInstance();
        ASTArrayList<MemberDeclaration> memberList = new ASTArrayList<MemberDeclaration>();
        for (int j = 0; j < parameters.size(); ++j) {
            parameter = parameters.get(j);
            ASTArrayList<DeclarationSpecifier> modifierlist = new ASTArrayList<DeclarationSpecifier>();
            modifierlist.add(factory.createPublic());
            Identifier fieldName = factory.createIdentifier(parameter.getVariables().get(0).getName());
            FieldDeclaration fd = factory.createFieldDeclaration(parameter.getTypeReference(), fieldName);
            fd.setDeclarationSpecifiers(modifierlist);
            memberList.add(fd);
        }
        ASTArrayList<DeclarationSpecifier> modifierlist = new ASTArrayList<DeclarationSpecifier>();
        modifierlist.add(factory.createPublic());
        StatementBlock statements = factory.createStatementBlock();
        ConstructorDeclaration constructor = factory.createConstructorDeclaration(factory.createPublic(), factory.createIdentifier(packerClassName), null, null, statements);
        for (int j = 0; j < parameters.size(); ++j) {
            parameter = parameters.get(j);
            String paramString = parameter.getVariables().get(0).getName();
            FieldReference fieldRef = factory.createFieldReference(factory.createThisReference(), factory.createIdentifier(paramString));
            CopyAssignment assign = factory.createCopyAssignment(fieldRef, factory.createVariableReference(factory.createIdentifier(paramString)));
            statements.getBody().add(assign);
        }
        memberList.add(constructor);
        modifierlist = new ASTArrayList();
        modifierlist.add(factory.createPublic());
        ClassDeclaration packClass = factory.createClassDeclaration(modifierlist, factory.createIdentifier(packerClassName), factory.createExtends(factory.createTypeReference(factory.createPackageReference(factory.createPackageReference(factory.createIdentifier("java")), factory.createIdentifier("lang")), factory.createIdentifier("Object"))), factory.createImplements(), memberList);
        Debug.printlno("debugPackifier", "created packer " + packerClassName);
        return packClass;
    }

    public static List<MethodDeclaration> getGetters(SourceInfo si, FieldSpecification f) {
        Debug.assertNonnull((Object)si, f);
        ArrayList<MethodDeclaration> res = new ArrayList<MethodDeclaration>();
        TypeDeclaration tdecl = (TypeDeclaration)f.getContainingClassType();
        if (tdecl instanceof InterfaceDeclaration) {
            return res;
        }
        ASTList<MemberDeclaration> mems = tdecl.getMembers();
        if (mems == null) {
            return res;
        }
        Type fieldType = si.getType(f);
        for (int i = mems.size() - 1; i >= 0; --i) {
            FieldReference fr;
            Expression expr;
            Statement last;
            ASTList<Statement> statements;
            MemberDeclaration md = (MemberDeclaration)mems.get(i);
            if (!(md instanceof MethodDeclaration)) continue;
            MethodDeclaration m = (MethodDeclaration)md;
            if (!(fieldType instanceof PrimitiveType) ? !si.isWidening(fieldType, m.getReturnType()) : m.getReturnType() != fieldType) continue;
            StatementBlock body = m.getBody();
            if (body == null || (statements = body.getBody()) == null || !((last = (Statement)statements.get(statements.size() - 1)) instanceof Return) || !((expr = ((Return)last).getExpression()) instanceof FieldReference) || si.getField(fr = (FieldReference)expr) != f) continue;
            res.add(m);
        }
        return res;
    }

    public static boolean rename(ChangeHistory ch, CrossReferenceSourceInfo xr, MethodDeclaration method, String newName) {
        Debug.assertNonnull(xr, method, newName);
        Debug.assertNonnull(method.getName());
        Debug.assertBoolean(!(method instanceof ConstructorDeclaration));
        if (!newName.equals(method.getName())) {
            List<MemberReference> refs = xr.getReferences(method);
            MiscKit.rename(ch, method, newName);
            for (int i = refs.size() - 1; i >= 0; --i) {
                MiscKit.rename(ch, (MethodReference)refs.get(i), newName);
            }
            return true;
        }
        return false;
    }

    public static List<Method> getRedefinedMethods(Method m) {
        Debug.assertNonnull(m);
        if (m instanceof Constructor) {
            return new ArrayList<Method>(0);
        }
        ClassType ct = m.getContainingClassType();
        String mname = m.getName();
        List<Type> msig = m.getSignature();
        ArrayList<Method> result = new ArrayList<Method>();
        List<ClassType> supers = ct.getSupertypes();
        for (int i = supers.size() - 1; i >= 0; --i) {
            List<Method> meths = supers.get(i).getAllMethods();
            for (int j = meths.size() - 1; j >= 0; --j) {
                Method m2 = meths.get(j);
                if (!m2.getName().equals(mname) || !m2.getSignature().equals(msig)) continue;
                result.add(m2);
            }
        }
        return result;
    }

    public static List<Method> getRedefiningMethods(CrossReferenceSourceInfo xr, Method m) {
        Debug.assertNonnull(m);
        if (m instanceof Constructor) {
            return new ArrayList<Method>(0);
        }
        ClassType ct = m.getContainingClassType();
        String mname = m.getName();
        List<Type> msig = m.getSignature();
        ArrayList<Method> result = new ArrayList<Method>();
        List<ClassType> subs = xr.getAllSubtypes(ct);
        for (int i = subs.size() - 1; i >= 0; --i) {
            List<Method> meths = subs.get(i).getMethods();
            for (int j = meths.size() - 1; j >= 0; --j) {
                Method m2 = meths.get(j);
                if (!m2.getName().equals(mname) || !m2.getSignature().equals(msig)) continue;
                result.add(m2);
            }
        }
        return result;
    }

    public static boolean isMain(NameInfo ni, Method m) {
        if (!m.isPublic()) {
            return false;
        }
        if (!m.isStatic()) {
            return false;
        }
        if (!m.getName().equals("main")) {
            return false;
        }
        if (m.getReturnType() != null) {
            return false;
        }
        List<Type> list = m.getSignature();
        if (list.size() != 1) {
            return false;
        }
        return list.get(0) == ni.getArrayType(ni.getJavaLangString());
    }

    public static boolean isSerializationMethod(NameInfo ni, Method m) {
        if (m.getName().equals("writeObject") && m.isPrivate() && m.getReturnType() == null && m.getSignature().size() == 1 && m.getSignature().get(0) == ni.getClassType("java.io.ObjectOutputStream")) {
            return true;
        }
        if (m.getName().equals("readObject") && m.isPrivate() && m.getReturnType() == null && m.getSignature().size() == 1 && m.getSignature().get(0) == ni.getClassType("java.io.ObjectInputStream")) {
            return true;
        }
        if (m.getName().equals("writeReplace") && m.getReturnType() == ni.getJavaLangObject() && m.getSignature().isEmpty()) {
            return true;
        }
        return m.getName().equals("readResolve") && m.getReturnType() == ni.getJavaLangObject() && m.getSignature().isEmpty();
    }

    public static MethodDeclaration cloneHeader(MethodDeclaration md) {
        StatementBlock body = md.getBody();
        md.setBody(null);
        MethodDeclaration result = md.deepClone();
        md.setBody(body);
        return result;
    }

    public static Method getDefinedMethod(ClassType type, String name, List<Type> signature) {
        List<Method> methods = type.getMethods();
        for (int j = methods.size() - 1; j >= 0; --j) {
            Method m = methods.get(j);
            if (!name.equals(m.getName()) || !signature.equals(m.getSignature())) continue;
            return m;
        }
        return null;
    }

    public static List<Method> getRedefinedMethods(NameInfo ni, ClassType base, String name, List<Type> signature) {
        List<ClassType> supers = base.getSupertypes();
        ArrayList<Method> result = new ArrayList<Method>();
        boolean hasClass = false;
        for (int i = 0; i < supers.size(); ++i) {
            ClassType ct = supers.get(i);
            Method m = MethodKit.getDefinedMethod(ct, name, signature);
            if (m == null) continue;
            if (!ct.isInterface()) {
                result.add(0, m);
                hasClass = true;
                continue;
            }
            result.add(m);
        }
        if (!hasClass) {
            ClassType ct = base;
            do {
                Method m;
                if ((m = MethodKit.getDefinedMethod(ct = TypeKit.getSuperClass(ni, ct), name, signature)) == null) continue;
                result.add(0, m);
                break;
            } while (ct != ni.getJavaLangObject());
        }
        return result;
    }

    public static Problem checkMethodRedefinition(ProgramModelInfo pmi, Method redefined, Method redefining) {
        List<ClassType> redefinedex;
        if (redefining instanceof Constructor) {
            return null;
        }
        if (redefined.isFinal() || redefined.getContainingClassType().isFinal()) {
            return new FinalOverwrite(redefined);
        }
        if (redefined.getReturnType() != redefining.getReturnType()) {
            return new DifferentReturnTypeOverwrite(redefined);
        }
        if (TypeKit.isLessVisible(redefining, redefined)) {
            return new MorePrivateOverwrite(redefined);
        }
        if (!redefining.isStatic() && redefined.isStatic()) {
            return new NonStaticOverwrite(redefined);
        }
        List<ClassType> exceptions = redefining.getExceptions();
        if (!(exceptions == null || (redefinedex = redefined.getExceptions()) != null && TypeKit.isCovered(pmi, redefinedex, exceptions))) {
            return new UncoveredExceptionsOverwrite(redefined);
        }
        return null;
    }

    public static Problem checkMethodDeclaration(NameInfo ni, SourceInfo si, TypeDeclaration context, MethodDeclaration candidate) {
        if (context instanceof InterfaceDeclaration && !TypeKit.isValidInterfaceMember(candidate)) {
            return new IllegalInterfaceMember(candidate);
        }
        if (candidate instanceof Constructor) {
            if (!candidate.getName().equals(context.getName())) {
                return new NameConflict(context);
            }
        } else if (Naming.isKeyword(candidate.getName())) {
            return new IllegalName(candidate);
        }
        ASTList<MemberDeclaration> members = context.getMembers();
        String name = candidate.getName();
        List<Type> signature = candidate.getSignature();
        if (members != null) {
            for (int i = members.size() - 1; i >= 0; --i) {
                MethodDeclaration m;
                MemberDeclaration md = (MemberDeclaration)members.get(i);
                if (!(md instanceof MethodDeclaration) || !(m = (MethodDeclaration)md).getName().equals(name) || !m.getSignature().equals(signature)) continue;
                return new NameConflict(m);
            }
        }
        if (candidate instanceof Constructor) {
            return null;
        }
        List<Method> redefined = MethodKit.getRedefinedMethods(ni, context, name, signature);
        for (int i = 0; i < redefined.size(); ++i) {
            Problem problem = MethodKit.checkMethodRedefinition(si, redefined.get(i), candidate);
            if (problem == null) continue;
            return problem;
        }
        return null;
    }

    public static List<MemberReference> getReferences(CrossReferenceSourceInfo xr, Method m, NonTerminalProgramElement root, boolean scanTree) {
        Debug.assertNonnull(xr, m, root);
        ArrayList<MemberReference> result = new ArrayList<MemberReference>();
        if (scanTree) {
            TreeWalker tw = new TreeWalker(root);
            if (m instanceof Constructor) {
                while (tw.next(ConstructorReference.class)) {
                    ConstructorReference cr = (ConstructorReference)tw.getProgramElement();
                    if (xr.getConstructor(cr) != m) continue;
                    result.add(cr);
                }
            } else {
                while (tw.next(MethodReference.class)) {
                    MethodReference mr = (MethodReference)tw.getProgramElement();
                    if (xr.getMethod(mr) != m) continue;
                    result.add(mr);
                }
            }
        } else {
            List<MemberReference> refs = xr.getReferences(m);
            int s = refs.size();
            for (int i = 0; i < s; ++i) {
                MemberReference mr = refs.get(i);
                if (!MiscKit.contains(root, mr)) continue;
                result.add(mr);
            }
        }
        return result;
    }

    public static List<Method> getAllRelatedMethods(CrossReferenceSourceInfo xrsi, ClassType type, String methodName, List<Type> signature) {
        Debug.assertNonnull(xrsi, type, methodName, signature);
        RelatedMethodsHelper rmh = new RelatedMethodsHelper(xrsi, type, methodName, signature);
        return rmh.findRelatedMethods();
    }

    public static List<Method> getAllRelatedMethods(CrossReferenceSourceInfo xrsi, Method method) {
        Debug.assertNonnull(method);
        return MethodKit.getAllRelatedMethods(xrsi, method.getContainingClassType(), method.getName(), method.getSignature());
    }

    public static List<Method> getAllRelatedMethods(NameInfo ni, CrossReferenceSourceInfo xrsi, ClassType type, String methodName, List<Type> signature) {
        HashSet<ClassType> visited = new HashSet<ClassType>();
        Queue q = new Queue();
        q.enqueue(type);
        visited.add(type);
        ArrayList<Method> result = new ArrayList<Method>();
        while (!q.isEmpty()) {
            type = (ClassType)q.dequeue();
            Method m = MethodKit.getDefinedMethod(type, methodName, signature);
            if (m != null) {
                result.add(m);
            }
            List<Method> redefined = MethodKit.getRedefinedMethods(ni, type, methodName, signature);
            for (int i = redefined.size() - 1; i >= 0; --i) {
                ClassType ct = redefined.get(i).getContainingClassType();
                if (!visited.add(ct)) continue;
                q.enqueue(ct);
            }
            if (m == null && redefined.isEmpty()) continue;
            List<ClassType> types = xrsi.getSubtypes(type);
            for (int i = types.size() - 1; i >= 0; --i) {
                ClassType ct = types.get(i);
                if (!visited.add(ct)) continue;
                q.enqueue(ct);
            }
        }
        return result;
    }

    private static class RelatedMethodsHelper {
        private final List<Method> methods = new ArrayList<Method>();
        private final Set<ClassType> searchedUp = new HashSet<ClassType>();
        private final Set<ClassType> searchedDown = new HashSet<ClassType>();
        private final CrossReferenceSourceInfo xrsi;
        private final ClassType starting_type;
        private final String methodName;
        private final List<Type> signature;

        public RelatedMethodsHelper(CrossReferenceSourceInfo xrsi, ClassType type, String methodName, List<Type> signature) {
            this.xrsi = xrsi;
            this.methodName = methodName;
            this.signature = signature;
            this.starting_type = type;
        }

        public List<Method> findRelatedMethods() {
            this.addMethodsFromSubTypes(this.starting_type);
            return this.methods;
        }

        private void addMethodsFromSubTypes(ClassType type) {
            if (!this.searchedDown.add(type)) {
                return;
            }
            List<ClassType> subTypes = this.xrsi.getSubtypes(type);
            if (subTypes.isEmpty()) {
                this.addMethodsFromSuperTypes(type);
            } else {
                for (int i = subTypes.size() - 1; i >= 0; --i) {
                    ClassType child = subTypes.get(i);
                    this.addMethodsFromSubTypes(child);
                }
            }
        }

        private void addMethodsFromSuperTypes(ClassType type) {
            if (!this.searchedUp.add(type)) {
                return;
            }
            Method m = MethodKit.getDefinedMethod(type, this.methodName, this.signature);
            if (m != null) {
                this.methods.add(m);
                this.addMethodsFromSubTypes(type);
            }
            List<ClassType> superTypes = type.getSupertypes();
            for (int i = superTypes.size() - 1; i >= 0; --i) {
                ClassType parent = superTypes.get(i);
                this.addMethodsFromSuperTypes(parent);
            }
        }
    }
}

