/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import recoder.abstraction.ArrayType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.convenience.Naming;

public class NameGenerator {
    public static final int SHORT_STYLE = -1;
    public static final int DEFAULT_STYLE = 0;
    public static final int LONG_STYLE = 1;
    private int attempt = 0;
    private String[] derivates;

    public NameGenerator(String base) {
        this(base, 0);
    }

    public NameGenerator(String base, int strategy) {
        this.guessNames(base, strategy);
    }

    public NameGenerator(Type type) {
        while (type instanceof ArrayType) {
            type = ((ArrayType)type).getBaseType();
        }
        if (type instanceof PrimitiveType) {
            this.guessNames(type.getName(), -1);
        } else {
            this.guessNames(type.getName(), 0);
        }
    }

    private static String[] getLetters(String base) {
        char c = Character.toLowerCase(base.charAt(0));
        if (c < 'y') {
            return new String[]{base, "" + (char)(c + '\u0001'), "" + (char)(c + 2)};
        }
        if (c < 'z') {
            return new String[]{base, "" + (char)(c + '\u0001')};
        }
        return new String[]{base};
    }

    private static String[] separateWords(String base) {
        int len = base.length();
        StringBuffer[] buf = new StringBuffer[len / 2];
        int w = 0;
        buf[w] = new StringBuffer();
        buf[w].append(base.charAt(0));
        for (int i = 1; i < len - 1; ++i) {
            char c = base.charAt(i);
            if (Character.isUpperCase(c)) {
                char d = base.charAt(i - 1);
                char e = base.charAt(i + 1);
                if (Character.isLowerCase(e) || e == '_' || Character.isLowerCase(d)) {
                    buf[++w] = new StringBuffer();
                    buf[w].append(c);
                    continue;
                }
            }
            buf[w].append(c);
        }
        buf[w].append(base.charAt(len - 1));
        String[] res = new String[w + 1];
        for (int j = 0; j <= w; ++j) {
            res[j] = buf[j].toString();
        }
        return res;
    }

    private static boolean isVowel(char c) {
        return (c = Character.toLowerCase(c)) == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y';
    }

    private static String removeVowels(String str) {
        int len = str.length();
        StringBuffer res = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (NameGenerator.isVowel(c)) continue;
            res.append(c);
        }
        return res.toString();
    }

    private static String[] deriveShortCuts(int index, String[] words) {
        String s;
        String s2;
        String base = words[index];
        int len = base.length();
        String[] res = new String[6];
        int w = 0;
        char c0 = base.charAt(0);
        if (Character.isUpperCase(c0) && !Naming.isKeyword(s2 = base.toLowerCase())) {
            res[w++] = s2;
        }
        if (len > 3) {
            char c2;
            String s3;
            String bs;
            String s4;
            char c1 = base.charAt(1);
            if (!NameGenerator.isVowel(c1) && !Naming.isKeyword(s4 = base.substring(0, 2).toLowerCase())) {
                res[w++] = s4;
            }
            if (!NameGenerator.isVowel(c0) && ((bs = NameGenerator.removeVowels(base)).length() == 2 || bs.length() == 3 && len > 4) && !Naming.isKeyword(s3 = bs.toLowerCase())) {
                res[w++] = s3;
            }
            if (len > 4 && !NameGenerator.isVowel(c2 = base.charAt(2)) && !Naming.isKeyword(s3 = base.substring(0, 3).toLowerCase())) {
                res[w++] = s3;
            }
        }
        char lc0 = Character.toLowerCase(c0);
        if ((len > 1 || Character.isUpperCase(c0)) && !Naming.isKeyword(s = "" + lc0)) {
            res[w++] = s;
        }
        for (int i = 1; i < w; ++i) {
            int j;
            String x = res[i];
            int xlen = x.length();
            for (j = i - 1; j >= 0 && res[j].length() > xlen; --j) {
                res[j + 1] = res[j];
            }
            if (j >= 0 && res[j].equals(x)) {
                ++j;
                --w;
                --i;
                while (j < len) {
                    res[j] = res[j + 1];
                    ++j;
                }
                continue;
            }
            res[j + 1] = x;
        }
        String[] result = new String[w];
        for (int i = 0; i < w; ++i) {
            result[i] = res[i];
        }
        return result;
    }

    public String getNextCandidate() {
        Object res = this.attempt < this.derivates.length ? this.derivates[this.attempt] : this.derivates[0] + (2 + this.attempt - this.derivates.length);
        ++this.attempt;
        return res;
    }

    private void guessNames(String base, int strategy) {
        String[] words = NameGenerator.separateWords(base);
        int len = words.length;
        if (strategy == 0) {
            strategy = len >= 4 ? -1 : 1;
        }
        String[][] shortCuts = new String[len][];
        for (int i = 0; i < len; ++i) {
            shortCuts[i] = NameGenerator.deriveShortCuts(i, words);
        }
        if (strategy == -1) {
            StringBuffer res = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                res.append(shortCuts[i][0]);
            }
            this.derivates = len == 1 ? NameGenerator.getLetters(res.toString()) : new String[]{res.toString()};
        } else {
            int i;
            int c = 1;
            for (i = 0; i < len; ++i) {
                c += shortCuts[i].length - 1;
            }
            this.derivates = new String[c];
            c = 0;
            for (i = 0; i < len; ++i) {
                for (int k = shortCuts[i].length - (i == 0 ? 1 : 2); k >= 0; --k) {
                    int j;
                    StringBuffer buf = new StringBuffer();
                    for (j = 0; j < i; ++j) {
                        buf.append(shortCuts[j][0]);
                    }
                    buf.append(shortCuts[i][k]);
                    for (j = i + 1; j < len; ++j) {
                        buf.append(words[j]);
                    }
                    this.derivates[c++] = buf.toString();
                }
            }
        }
    }
}

