/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import recoder.ProgramFactory;
import recoder.ServiceConfiguration;
import recoder.abstraction.ClassType;
import recoder.abstraction.Field;
import recoder.abstraction.Type;
import recoder.abstraction.Variable;
import recoder.convenience.TreeWalker;
import recoder.java.Identifier;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.VariableScope;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.VariableDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.reference.FieldReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.VariableReference;
import recoder.kit.MiscKit;
import recoder.kit.NameGenerator;
import recoder.kit.TypeKit;
import recoder.service.ChangeHistory;
import recoder.service.CrossReferenceSourceInfo;
import recoder.service.NameInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public class VariableKit {
    private VariableKit() {
    }

    public static String createValidVariableName(SourceInfo si, ProgramElement context, String guess) {
        Debug.assertNonnull(si, context, guess);
        Object result = guess;
        int i = 0;
        Set<String> vars = VariableKit.collectInnerVariables(context);
        while (si.getVariable((String)result, context) != null || vars.contains(result)) {
            result = guess + i++;
        }
        return result;
    }

    public static String createValidVariableName(SourceInfo si, ProgramElement context) {
        return VariableKit.createValidVariableName(si, context, "_hvar_");
    }

    public static VariableDeclaration createVariableDeclaration(ServiceConfiguration sc, ProgramElement context, Type t, String guess) {
        Debug.assertNonnull(sc, context, t);
        String vname = VariableKit.createValidVariableName(sc.getSourceInfo(), context, guess);
        ProgramFactory pf = sc.getProgramFactory();
        TypeReference prefix = TypeKit.createTypeReference(pf, t);
        Identifier id = pf.createIdentifier(vname);
        return pf.createLocalVariableDeclaration(prefix, id);
    }

    public static VariableDeclaration createVariableDeclaration(ServiceConfiguration sc, ProgramElement context, Type t) {
        Debug.assertNonnull(sc, context, t);
        String varName = VariableKit.getNewVariableName(sc.getSourceInfo(), t, context);
        ProgramFactory f = sc.getProgramFactory();
        TypeReference prefix = TypeKit.createTypeReference(f, t);
        Identifier id = f.createIdentifier(varName);
        return f.createLocalVariableDeclaration(prefix, id);
    }

    public static VariableReference createVariableReference(VariableDeclaration decl) {
        ProgramFactory factory = decl.getFactory();
        String n = decl.getVariables().get(0).getName();
        return factory.createVariableReference(factory.createIdentifier(n));
    }

    private static Set<String> collectInnerVariables(ProgramElement context) {
        HashSet<String> result = new HashSet<String>();
        while (context != null && !(context instanceof VariableScope)) {
            context = context.getASTParent();
        }
        if (context != null) {
            TreeWalker tw = new TreeWalker(context);
            while (tw.next()) {
                if (!(tw.getProgramElement() instanceof Variable)) continue;
                result.add(((Variable)((Object)tw.getProgramElement())).getName());
            }
        }
        return result;
    }

    public static String getNewVariableName(SourceInfo si, Type type, ProgramElement context) {
        Debug.assertNonnull(si, type, context);
        NameGenerator generator = new NameGenerator(type);
        Set<String> vars = VariableKit.collectInnerVariables(context);
        String result = generator.getNextCandidate();
        while (si.getVariable(result, context) != null || vars.contains(result)) {
            result = generator.getNextCandidate();
        }
        return result;
    }

    public static String[] getNewVariableNames(SourceInfo si, Type[] types, ProgramElement context) {
        Debug.assertNonnull(si, types, context);
        while (!(context instanceof VariableScope)) {
            context = context.getASTParent();
        }
        Set<String> others = VariableKit.collectInnerVariables(context);
        String[] results = new String[types.length];
        for (int i = 0; i < results.length; ++i) {
            String vname;
            NameGenerator generator = new NameGenerator(types[i]);
            while (si.getVariable(vname = generator.getNextCandidate(), context) != null || others.contains(vname)) {
            }
            results[i] = vname;
            others.add(vname);
        }
        return results;
    }

    public static boolean rename(ChangeHistory ch, CrossReferenceSourceInfo xr, VariableSpecification var, String newName) {
        Debug.assertNonnull(xr, var, newName);
        Debug.assertNonnull(var.getName());
        if (!newName.equals(var.getName())) {
            List<VariableReference> refs = xr.getReferences(var);
            MiscKit.rename(ch, var, newName);
            for (int i = refs.size() - 1; i >= 0; --i) {
                MiscKit.rename(ch, refs.get(i), newName);
            }
            return true;
        }
        return false;
    }

    public static VariableReference createVariableReference(SourceInfo si, Variable v, ProgramElement context) {
        Debug.assertNonnull(si, v, context);
        String varname = v.getName();
        ProgramFactory f = context.getFactory();
        Variable lookup = si.getVariable(varname, context);
        if (lookup == null) {
            return null;
        }
        if (lookup == v) {
            VariableReference res = f.createVariableReference(f.createIdentifier(varname));
            res.makeAllParentRolesValid();
            return res;
        }
        if (!(v instanceof Field)) {
            return null;
        }
        ClassType varClass = ((Field)v).getContainingClassType();
        TypeDeclaration ctxClass = MiscKit.getParentTypeDeclaration(context);
        TypeReference prefix = null;
        do {
            if (varClass == ctxClass) {
                FieldReference res = f.createFieldReference(f.createIdentifier(varname));
                res.setReferencePrefix(f.createThisReference(prefix));
                res.makeAllParentRolesValid();
                return res;
            }
            List<ClassType> sups = ctxClass.getAllSupertypes();
            int s = sups.size();
            block1: for (int i = 1; i < s; ++i) {
                ClassType sup = sups.get(i);
                List<? extends Field> flist = sup.getFields();
                int t = flist.size();
                for (int j = 0; j < t; ++j) {
                    Field candid = flist.get(j);
                    if (!varname.equals(candid.getName())) continue;
                    if (candid != v || !si.isVisibleFor(candid, ctxClass)) break block1;
                    FieldReference res = f.createFieldReference(f.createIdentifier(varname));
                    res.setReferencePrefix(f.createSuperReference(prefix));
                    res.makeAllParentRolesValid();
                    return res;
                }
            }
            if ((ctxClass = ctxClass.getMemberParent()) == null) continue;
            prefix = TypeKit.createTypeReference(si, (Type)ctxClass, context);
        } while (ctxClass != null);
        return null;
    }

    public static List<VariableReference> getReferences(CrossReferenceSourceInfo xr, Variable v, NonTerminalProgramElement root, boolean scanTree) {
        Debug.assertNonnull(xr, v, root);
        ArrayList<VariableReference> result = new ArrayList<VariableReference>();
        if (scanTree) {
            TreeWalker tw = new TreeWalker(root);
            while (tw.next(VariableReference.class)) {
                VariableReference vr = (VariableReference)tw.getProgramElement();
                if (xr.getVariable(vr) != v) continue;
                result.add(vr);
            }
        } else {
            List<VariableReference> refs = xr.getReferences(v);
            int s = refs.size();
            for (int i = 0; i < s; ++i) {
                VariableReference vr = refs.get(i);
                if (!MiscKit.contains(root, vr)) continue;
                result.add(vr);
            }
        }
        return result;
    }

    public static boolean isSerialVersionUID(NameInfo ni, Field f) {
        return f.isStatic() && f.isFinal() && f.getType() == ni.getLongType() && f.getName().equals("serialVersionUID");
    }
}

