/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.pattern;

import java.util.ArrayList;
import java.util.List;
import recoder.ModelElement;
import recoder.ModelException;
import recoder.abstraction.Constructor;
import recoder.abstraction.DefaultConstructor;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.kit.pattern.DesignPattern;
import recoder.kit.pattern.FactoryMethod;
import recoder.kit.pattern.InconsistentPatternException;
import recoder.list.generic.ASTList;

public class Factory
implements DesignPattern {
    private final List<FactoryMethod> factoryMethods;

    public Factory(List<FactoryMethod> factoryMethods) {
        this.factoryMethods = factoryMethods;
    }

    public Factory(ClassDeclaration factoryClass, List<TypeDeclaration> products) {
        if (factoryClass == null || products == null) {
            throw new NullPointerException();
        }
        int n = products.size();
        this.factoryMethods = new ArrayList<FactoryMethod>(n);
        for (int i = 0; i < n; ++i) {
            TypeDeclaration td = products.get(i);
            if (!(td instanceof ClassDeclaration)) continue;
            this.addFactoryMethods((ClassDeclaration)td);
        }
        ASTList<MemberDeclaration> members = factoryClass.getMembers();
        for (int i = 0; i < this.factoryMethods.size(); ++i) {
            members.add(this.factoryMethods.get(i).getProducer());
        }
        factoryClass.makeParentRoleValid();
    }

    public void addFactoryMethods(ClassDeclaration decl) {
        List<? extends Constructor> cl = decl.getConstructors();
        for (int i = 0; i < cl.size(); ++i) {
            if (cl.get(i) instanceof DefaultConstructor) {
                FactoryMethod m = new FactoryMethod(decl);
                this.addFactoryMethod(m);
                return;
            }
            ConstructorDeclaration cons = (ConstructorDeclaration)cl.get(i);
            if (!cons.isPublic()) continue;
            FactoryMethod m = new FactoryMethod(cons);
            this.addFactoryMethod(m);
        }
    }

    public void addFactoryMethod(FactoryMethod m) {
        this.factoryMethods.add(m);
    }

    public List<FactoryMethod> getFactoryMethods() {
        return this.factoryMethods;
    }

    @Override
    public int getParticipantCount() {
        return this.factoryMethods != null ? this.factoryMethods.size() : 0;
    }

    @Override
    public ModelElement getParticipantAt(int index) {
        if (this.factoryMethods != null) {
            return this.factoryMethods.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void validate() throws ModelException {
        if (this.factoryMethods == null || this.factoryMethods.size() == 0) {
            throw new InconsistentPatternException("Factories must contain at least one factory method");
        }
        TypeDeclaration parent = null;
        int s = this.factoryMethods.size();
        for (int i = 0; i < s; ++i) {
            FactoryMethod m = this.factoryMethods.get(i);
            m.validate();
            if (parent == null) {
                parent = m.getProducer().getMemberParent();
                continue;
            }
            if (parent == m.getProducer().getMemberParent()) continue;
            throw new InconsistentPatternException("Factory methods must be members of the same type");
        }
    }
}

