/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation;

import recoder.CrossReferenceServiceConfiguration;
import recoder.abstraction.Constructor;
import recoder.abstraction.Method;
import recoder.abstraction.Type;
import recoder.java.declaration.ClassInitializer;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.list.generic.ASTList;

public class AppendMember
extends TwoPassTransformation {
    private final boolean isVisible;
    private final TypeDeclaration parent;
    private final MemberDeclaration child;
    private int insertPosition = -1;

    public AppendMember(CrossReferenceServiceConfiguration sc, boolean isVisible, MemberDeclaration child, TypeDeclaration parent) {
        super(sc);
        if (child == null || parent == null) {
            throw new IllegalArgumentException("Missing declaration");
        }
        this.isVisible = isVisible;
        this.child = child;
        this.parent = parent;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public ProblemReport analyze() {
        ASTList<MemberDeclaration> mdl = this.parent.getMembers();
        if (mdl == null) {
            this.insertPosition = 0;
            return this.setProblemReport(NO_PROBLEM);
        }
        int lastField = -1;
        int lastInitializer = -1;
        int lastConstructor = -1;
        int lastMethod = -1;
        int lastType = -1;
        for (int i = mdl.size() - 1; i >= 0; --i) {
            MemberDeclaration x = (MemberDeclaration)mdl.get(i);
            if (x instanceof FieldDeclaration) {
                lastField = lastField < 0 ? i : lastField;
                continue;
            }
            if (x instanceof ClassInitializer) {
                lastInitializer = lastInitializer < 0 ? i : lastInitializer;
                continue;
            }
            if (x instanceof Constructor) {
                lastConstructor = lastConstructor < 0 ? i : lastConstructor;
                continue;
            }
            if (x instanceof Method) {
                lastMethod = lastMethod < 0 ? i : lastMethod;
                continue;
            }
            if (!(x instanceof Type)) continue;
            lastType = lastType < 0 ? i : lastType;
        }
        if (this.child instanceof FieldDeclaration) {
            lastType = -1;
            lastMethod = -1;
            lastConstructor = -1;
            lastInitializer = -1;
        } else if (this.child instanceof ClassInitializer) {
            lastType = -1;
            lastMethod = -1;
            lastConstructor = -1;
        } else if (this.child instanceof ConstructorDeclaration) {
            lastType = -1;
            lastMethod = -1;
        } else if (this.child instanceof MethodDeclaration) {
            lastType = -1;
        }
        this.insertPosition = lastType >= 0 ? lastType + 1 : (lastMethod >= 0 ? lastMethod + 1 : (lastConstructor >= 0 ? lastConstructor + 1 : (lastInitializer >= 0 ? lastInitializer + 1 : (lastField >= 0 ? lastField + 1 : 0))));
        return this.setProblemReport(NO_PROBLEM);
    }

    @Override
    public void transform() {
        super.transform();
        this.attach(this.child, this.parent, this.insertPosition);
    }
}

