/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation;

import recoder.CrossReferenceServiceConfiguration;
import recoder.java.Expression;
import recoder.java.ProgramElement;
import recoder.java.Statement;
import recoder.java.StatementContainer;
import recoder.kit.Problem;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.transformation.PrepareStatementList;
import recoder.kit.transformation.ShiftPreceedingStatementExpressions;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.ChangeHistory;

public class PrependExpressionWithStatements
extends TwoPassTransformation {
    private final Expression expression;
    private final ASTList<Statement> statements;
    private ShiftPreceedingStatementExpressions shifter;

    public PrependExpressionWithStatements(CrossReferenceServiceConfiguration sc, Expression x, ASTList<Statement> statements) {
        super(sc);
        if (x == null) {
            throw new IllegalArgumentException("Missing expression");
        }
        if (statements == null) {
            throw new IllegalArgumentException("Missing statements");
        }
        this.expression = x;
        this.statements = statements;
    }

    public PrependExpressionWithStatements(CrossReferenceServiceConfiguration sc, Expression x, Statement statement) {
        this(sc, x, new ASTArrayList<Statement>(statement));
    }

    @Override
    public ProblemReport analyze() {
        if (this.statements.isEmpty()) {
            return this.setProblemReport(IDENTITY);
        }
        this.shifter = new ShiftPreceedingStatementExpressions(this.getServiceConfiguration(), this.expression);
        ProblemReport report = this.shifter.analyze();
        if (report instanceof Problem) {
            return this.setProblemReport(report);
        }
        if (report == IDENTITY) {
            int i;
            Statement parent = (Statement)((Object)this.shifter.getTopMostParent());
            StatementContainer grandpa = parent.getStatementContainer();
            int s = grandpa.getStatementCount();
            for (i = 0; i < s && grandpa.getStatementAt(i) != parent; ++i) {
            }
            int j = this.statements.size();
            if (i >= j) {
                --j;
                --i;
                while (j >= 0 && ProgramElement.STRUCTURAL_EQUALITY.equals(this.statements.get(j), grandpa.getStatementAt(i))) {
                    --j;
                    --i;
                }
                if (j < 0) {
                    return this.setProblemReport(report);
                }
            }
        }
        return this.setProblemReport(NO_PROBLEM);
    }

    @Override
    public void transform() {
        super.transform();
        this.shifter.transform();
        Statement statement = this.shifter.getEnclosingStatement();
        PrepareStatementList preparer = new PrepareStatementList(this.getServiceConfiguration(), statement, true);
        preparer.execute();
        ASTList<Statement> body = preparer.getStatementList();
        statement = preparer.getStatement();
        int position = body.indexOf(statement);
        body.addAll(position, this.statements);
        ChangeHistory ch = this.getChangeHistory();
        StatementContainer parent = statement.getStatementContainer();
        for (int i = 0; i < this.statements.size(); ++i) {
            Statement s = (Statement)this.statements.get(i);
            s.setStatementContainer(parent);
            if (!this.isVisible()) continue;
            ch.attached(s);
        }
    }
}

