/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.Method;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.kit.MethodKit;
import recoder.kit.MissingSources;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.service.CrossReferenceSourceInfo;

public class RenameMethod
extends TwoPassTransformation {
    private final Method methodToRename;
    private final String newName;
    private List<MethodDeclaration> methods;
    private List<MethodReference> refs;

    public RenameMethod(CrossReferenceServiceConfiguration sc, MethodDeclaration method, String newName) {
        super(sc);
        if (method == null) {
            throw new IllegalArgumentException("Missing method");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Missing name");
        }
        this.methodToRename = method;
        this.newName = newName;
    }

    @Override
    public ProblemReport analyze() {
        if (this.newName.equals(this.methodToRename.getName())) {
            return this.setProblemReport(IDENTITY);
        }
        CrossReferenceSourceInfo xr = this.getCrossReferenceSourceInfo();
        this.methods = new ArrayList<MethodDeclaration>();
        List<Method> relatedMethods = MethodKit.getAllRelatedMethods(xr, this.methodToRename);
        ArrayList<Method> problems = null;
        for (int i = relatedMethods.size() - 1; i >= 0; --i) {
            Method m = relatedMethods.get(i);
            if (m instanceof MethodDeclaration) {
                this.methods.add((MethodDeclaration)m);
                continue;
            }
            if (problems == null) {
                problems = new ArrayList<Method>();
            }
            problems.add(m);
        }
        if (problems != null) {
            return this.setProblemReport(new MissingMethodDeclarations(problems));
        }
        this.refs = new ArrayList<MethodReference>();
        for (int j = this.methods.size() - 1; j >= 0; --j) {
            MethodDeclaration mdecl = this.methods.get(j);
            List<MemberReference> mrefs = xr.getReferences(mdecl);
            int s = mrefs.size();
            for (int i = 0; i < s; ++i) {
                MemberReference mr = mrefs.get(i);
                if (!(mr instanceof MethodReference)) continue;
                this.refs.add((MethodReference)mr);
            }
        }
        return this.setProblemReport(EQUIVALENCE);
    }

    @Override
    public void transform() {
        int i;
        super.transform();
        ProgramFactory pf = this.getProgramFactory();
        for (i = this.methods.size() - 1; i >= 0; --i) {
            this.replace(this.methods.get(i).getIdentifier(), pf.createIdentifier(this.newName));
        }
        for (i = this.refs.size() - 1; i >= 0; --i) {
            this.replace(this.refs.get(i).getIdentifier(), pf.createIdentifier(this.newName));
        }
    }

    public List<MethodDeclaration> getRenamedMethods() {
        return this.methods;
    }

    public static class MissingMethodDeclarations
    extends MissingSources {
        private static final long serialVersionUID = 9214788084198236635L;
        private final List<Method> nonMethodDeclarations;

        MissingMethodDeclarations(List<Method> nonMethodDeclarations) {
            this.nonMethodDeclarations = nonMethodDeclarations;
        }

        public List<Method> getNonMethodDeclarations() {
            return this.nonMethodDeclarations;
        }
    }
}

