/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.abstraction.ClassType;
import recoder.abstraction.Package;
import recoder.java.reference.PackageReference;
import recoder.kit.MissingTypeDeclarations;
import recoder.kit.NameConflict;
import recoder.kit.PackageKit;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;

public class RenamePackage
extends TwoPassTransformation {
    private final Package pkg;
    private final String newName;
    private List<PackageReference> refs;

    public RenamePackage(CrossReferenceServiceConfiguration sc, Package pkg, String newName) {
        super(sc);
        if (pkg == null) {
            throw new IllegalArgumentException("Missing package");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Missing name");
        }
        this.pkg = pkg;
        this.newName = newName;
    }

    @Override
    public ProblemReport analyze() {
        if (this.newName.equals(this.pkg.getName())) {
            this.refs = new ArrayList<PackageReference>(0);
            return this.setProblemReport(IDENTITY);
        }
        Package pkg2 = this.getNameInfo().getPackage(this.newName);
        if (pkg2 != null) {
            return this.setProblemReport(new NameConflict(pkg2));
        }
        List<ClassType> nonTypeDeclarations = PackageKit.getNonSourcePackageTypes(this.pkg);
        if (!nonTypeDeclarations.isEmpty()) {
            return this.setProblemReport(new MissingTypeDeclarations(nonTypeDeclarations));
        }
        this.refs = this.getCrossReferenceSourceInfo().getReferences(this.pkg);
        return this.setProblemReport(EQUIVALENCE);
    }

    @Override
    public void transform() {
        super.transform();
        Package p = this.getNameInfo().createPackage(this.newName);
        PackageReference pr = PackageKit.createPackageReference(this.getProgramFactory(), p);
        for (int i = this.refs.size() - 1; i >= 0; --i) {
            PackageReference ref = this.refs.get(i);
            this.replace(ref, pr.deepClone());
        }
    }
}

