/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.Type;
import recoder.abstraction.Variable;
import recoder.java.Expression;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.LoopInitializer;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.declaration.LocalVariableDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.statement.EnhancedFor;
import recoder.java.statement.For;
import recoder.java.statement.JavaStatement;
import recoder.java.statement.LabeledStatement;
import recoder.kit.NameConflict;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.kit.VariableKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;

public final class EnhancedFor2For
extends TwoPassTransformation {
    private final CrossReferenceServiceConfiguration sc;
    private final EnhancedFor enhancedFor;
    private String iteratorName;
    private String arrayReferenceName;
    private Type guardType;
    private Type iteratorType;

    public EnhancedFor2For(CrossReferenceServiceConfiguration sc, EnhancedFor enhancedFor, String iteratorName, String arrayReferenceName) {
        super(sc);
        this.sc = sc;
        this.enhancedFor = enhancedFor;
        this.iteratorName = iteratorName;
        this.arrayReferenceName = arrayReferenceName;
    }

    public EnhancedFor2For(CrossReferenceServiceConfiguration sc, EnhancedFor enhancedFor) {
        this(sc, enhancedFor, null, null);
    }

    @Override
    public ProblemReport analyze() {
        Variable v;
        if (this.iteratorName != null) {
            v = this.sc.getSourceInfo().getVariable(this.iteratorName, this.enhancedFor.getASTParent());
            if (v != null) {
                return this.setProblemReport(new NameConflict(v));
            }
        } else {
            this.iteratorName = VariableKit.createValidVariableName(this.sc.getSourceInfo(), this.enhancedFor.getASTParent(), "i");
        }
        if (this.arrayReferenceName != null) {
            v = this.sc.getSourceInfo().getVariable(this.arrayReferenceName, this.enhancedFor.getASTParent());
            if (v != null) {
                return this.setProblemReport(new NameConflict(v));
            }
        } else {
            this.arrayReferenceName = VariableKit.createValidVariableName(this.sc.getSourceInfo(), this.enhancedFor.getASTParent(), "a");
        }
        this.guardType = this.sc.getSourceInfo().getType(this.enhancedFor.getGuard());
        if (this.guardType instanceof ClassType) {
            MethodReference mr = this.getProgramFactory().createMethodReference((ReferencePrefix)((Object)this.enhancedFor.getGuard()), this.getProgramFactory().createIdentifier("iterator"));
            mr.setExpressionContainer(this.enhancedFor);
            this.iteratorType = this.sc.getSourceInfo().getType(mr);
        } else if (this.guardType instanceof ArrayType) {
            this.iteratorType = null;
        } else {
            throw new IllegalStateException("Broken Model");
        }
        return this.setProblemReport(EQUIVALENCE);
    }

    @Override
    public void transform() {
        JavaStatement replacement;
        JavaStatement replacee;
        ASTArrayList<Expression> update;
        JavaNonTerminalProgramElement guard;
        LocalVariableDeclaration init;
        super.transform();
        ProgramFactory pf = this.getProgramFactory();
        LocalVariableDeclaration firstStmnt = ((LocalVariableDeclaration)this.enhancedFor.getInitializers().get(0)).deepClone();
        if (this.iteratorType == null) {
            init = pf.createLocalVariableDeclaration(null, TypeKit.createTypeReference(pf, "int"), pf.createIdentifier(this.iteratorName), pf.createIntLiteral(0));
            guard = pf.createLessThan(pf.createVariableReference(pf.createIdentifier(this.iteratorName)), pf.createArrayLengthReference(pf.createVariableReference(pf.createIdentifier(this.arrayReferenceName))));
            update = new ASTArrayList<Expression>(pf.createPostIncrement(pf.createVariableReference(pf.createIdentifier(this.iteratorName))));
            ((VariableSpecification)firstStmnt.getVariableSpecifications().get(0)).setInitializer(pf.createArrayReference(pf.createVariableReference(pf.createIdentifier(this.arrayReferenceName)), new ASTArrayList<Expression>(pf.createVariableReference(pf.createIdentifier(this.iteratorName)))));
        } else {
            init = pf.createLocalVariableDeclaration(null, TypeKit.createTypeReference(pf, this.iteratorType, true), pf.createIdentifier(this.iteratorName), pf.createMethodReference((ReferencePrefix)((Object)this.enhancedFor.getExpressionAt(0).deepClone()), pf.createIdentifier("iterator")));
            guard = pf.createMethodReference(pf.createVariableReference(pf.createIdentifier(this.iteratorName)), pf.createIdentifier("hasNext"));
            update = null;
            ((VariableSpecification)firstStmnt.getVariableSpecifications().get(0)).setInitializer(pf.createMethodReference(pf.createVariableReference(pf.createIdentifier(this.iteratorName)), pf.createIdentifier("next")));
        }
        ASTArrayList<int> statements = new ASTArrayList<int>(2);
        statements.add((int)firstStmnt);
        if (this.enhancedFor.getStatementCount() > 0) {
            Statement s = this.enhancedFor.getStatementAt(0);
            if (s instanceof StatementBlock) {
                StatementBlock sb = (StatementBlock)s;
                for (int i = 0; i < sb.getStatementCount(); ++i) {
                    statements.add((int)sb.getStatementAt(i).deepClone());
                }
            } else {
                statements.add((int)s.deepClone());
            }
        }
        For newFor = new For((ASTList<LoopInitializer>)new ASTArrayList<LoopInitializer>(init), (Expression)((Object)guard), (ASTList<Expression>)update, new StatementBlock(statements));
        newFor.makeAllParentRolesValid();
        if (this.iteratorType == null) {
            ASTArrayList<int> sml = new ASTArrayList<int>(2);
            LocalVariableDeclaration lvd = pf.createLocalVariableDeclaration(null, TypeKit.createTypeReference(pf, this.guardType), pf.createIdentifier(this.arrayReferenceName), this.enhancedFor.getGuard().deepClone());
            sml.add((int)lvd);
            JavaStatement s = newFor;
            replacee = this.enhancedFor;
            while (replacee.getASTParent() instanceof LabeledStatement) {
                replacee = (LabeledStatement)replacee.getASTParent();
                s = new LabeledStatement(((LabeledStatement)replacee).getIdentifier().deepClone(), s);
            }
            sml.add((int)s);
            replacement = pf.createStatementBlock(sml);
        } else {
            replacement = newFor;
            replacee = this.enhancedFor;
        }
        this.replace(replacee, replacement);
    }
}

