/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.convenience.TreeWalker;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.declaration.AnnotationDeclaration;
import recoder.java.declaration.AnnotationPropertyDeclaration;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.reference.TypeReference;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;

public class RemoveAnnotations
extends TwoPassTransformation {
    private final NonTerminalProgramElement root;
    private List<AnnotationUseSpecification> toRemove;
    private List<AnnotationDeclaration> unusedAnnotationTypes;
    private List<AnnotationDeclaration> usedAnnotationTypes;

    public RemoveAnnotations(CrossReferenceServiceConfiguration sc, NonTerminalProgramElement root) {
        super(sc);
        this.root = root;
    }

    @Override
    public ProblemReport analyze() {
        this.toRemove = new ArrayList<AnnotationUseSpecification>(100);
        this.unusedAnnotationTypes = new ArrayList<AnnotationDeclaration>(10);
        this.usedAnnotationTypes = new ArrayList<AnnotationDeclaration>(10);
        TreeWalker tw = new TreeWalker(this.root);
        while (tw.next()) {
            int i;
            ProgramElement pe = tw.getProgramElement();
            if (pe instanceof AnnotationUseSpecification) {
                this.toRemove.add((AnnotationUseSpecification)pe);
                continue;
            }
            if (!(pe instanceof AnnotationDeclaration)) continue;
            AnnotationDeclaration ad = (AnnotationDeclaration)pe;
            List<TypeReference> trl = this.getServiceConfiguration().getCrossReferenceSourceInfo().getReferences(ad);
            boolean remove = true;
            for (i = 0; i < trl.size(); ++i) {
                if (trl.get(i).getASTParent() instanceof AnnotationUseSpecification) continue;
                remove = false;
                break;
            }
            for (i = 0; i < ad.getMembers().size(); ++i) {
                MemberDeclaration md = (MemberDeclaration)ad.getMembers().get(i);
                if (!(md instanceof TypeDeclaration)) continue;
                remove = false;
                break;
            }
            if (remove) {
                this.unusedAnnotationTypes.add(ad);
                continue;
            }
            this.usedAnnotationTypes.add(ad);
        }
        return super.analyze();
    }

    @Override
    public void transform() {
        super.transform();
        for (AnnotationUseSpecification au : this.toRemove) {
            this.detach(au);
        }
        for (AnnotationDeclaration ad : this.unusedAnnotationTypes) {
            this.detach(ad);
        }
        for (AnnotationDeclaration ad : this.usedAnnotationTypes) {
            this.replace(ad, this.makeInterface(ad));
        }
    }

    private InterfaceDeclaration makeInterface(AnnotationDeclaration ad) {
        ProgramFactory f = this.getProgramFactory();
        InterfaceDeclaration replacement = this.getProgramFactory().createInterfaceDeclaration();
        ASTList<MemberDeclaration> oldMems = ad.getMembers();
        ASTArrayList<int> newMems = new ASTArrayList<int>(oldMems.size());
        for (int i = 0; i < oldMems.size(); ++i) {
            MemberDeclaration newMD;
            MemberDeclaration md = (MemberDeclaration)oldMems.get(i);
            if (md instanceof AnnotationPropertyDeclaration) {
                AnnotationPropertyDeclaration apd = (AnnotationPropertyDeclaration)md;
                MethodDeclaration m = f.createMethodDeclaration();
                if (apd.getComments() != null) {
                    m.setComments(apd.getComments().deepClone());
                }
                m.setIdentifier(apd.getIdentifier().deepClone());
                m.setTypeReference(apd.getTypeReference().deepClone());
                newMD = m;
            } else {
                newMD = md instanceof AnnotationDeclaration ? this.makeInterface((AnnotationDeclaration)md) : (MemberDeclaration)md.deepClone();
            }
            newMD.makeParentRoleValid();
            newMems.add((int)newMD);
        }
        replacement.setIdentifier(ad.getIdentifier().deepClone());
        replacement.setMembers(newMems);
        if (ad.getComments() != null) {
            replacement.setComments(ad.getComments().deepClone());
        }
        replacement.setDeclarationSpecifiers(ad.getDeclarationSpecifiers().deepClone());
        replacement.makeParentRoleValid();
        return replacement;
    }
}

