/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ModelException;
import recoder.ProgramFactory;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.ProgramElement;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.EnumConstantDeclaration;
import recoder.java.declaration.EnumConstantSpecification;
import recoder.java.declaration.EnumDeclaration;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.expression.operator.LogicalOr;
import recoder.java.expression.operator.New;
import recoder.java.expression.operator.NewArray;
import recoder.java.reference.FieldReference;
import recoder.java.statement.Branch;
import recoder.java.statement.Case;
import recoder.java.statement.Default;
import recoder.java.statement.Do;
import recoder.java.statement.If;
import recoder.java.statement.JumpStatement;
import recoder.java.statement.Switch;
import recoder.java.statement.Then;
import recoder.kit.MiscKit;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.kit.VariableKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;

public class ReplaceEnums
extends TwoPassTransformation {
    private final CompilationUnit cu;
    private List<ReplaceSingleEnum> parts;

    public ReplaceEnums(CrossReferenceServiceConfiguration sc, CompilationUnit cu) {
        super(sc);
        this.cu = cu;
    }

    @Override
    public ProblemReport analyze() {
        this.parts = new ArrayList<ReplaceSingleEnum>();
        TreeWalker tw = new TreeWalker(this.cu);
        while (tw.next()) {
            ProgramElement pe = tw.getProgramElement();
            if (!(pe instanceof EnumDeclaration)) continue;
            ReplaceSingleEnum p = new ReplaceSingleEnum(this.getServiceConfiguration(), (EnumDeclaration)pe);
            p.analyze();
            this.parts.add(p);
        }
        return super.analyze();
    }

    @Override
    public void transform() {
        super.transform();
        for (int i = this.parts.size() - 1; i >= 0; --i) {
            this.parts.get(i).transform();
        }
    }

    public class ReplaceSingleEnum
    extends TwoPassTransformation {
        private final EnumDeclaration ed;
        private ClassDeclaration repl;
        private Set<Switch> switchStmnts;
        private Map<Switch, String[]> names;

        public ReplaceSingleEnum(CrossReferenceServiceConfiguration sc, EnumDeclaration ed) {
            super(sc);
            this.ed = ed;
        }

        @Override
        public ProblemReport analyze() {
            this.switchStmnts = new HashSet<Switch>();
            this.names = new HashMap<Switch, String[]>();
            ProgramFactory f = this.getProgramFactory();
            this.repl = f.createClassDeclaration();
            if (this.ed.getDeclarationSpecifiers() != null) {
                this.repl.setDeclarationSpecifiers(this.ed.getDeclarationSpecifiers().deepClone());
            } else {
                this.repl.setDeclarationSpecifiers(new ASTArrayList<boolean>(true));
            }
            if (this.ed.isFinal()) {
                this.repl.getDeclarationSpecifiers().add(f.createFinal());
            }
            if (this.ed.getComments() != null) {
                this.repl.setComments(this.ed.getComments().deepClone());
            }
            ASTArrayList<int> mlist = new ASTArrayList<int>(this.ed.getMembers().size());
            this.repl.setMembers(mlist);
            this.repl.setIdentifier(this.ed.getIdentifier().deepClone());
            ASTArrayList<FieldSpecification> enumSpecRepl = new ASTArrayList<FieldSpecification>();
            for (int i = 0; i < this.ed.getMembers().size(); ++i) {
                MemberDeclaration md = (MemberDeclaration)this.ed.getMembers().get(i);
                if (md instanceof EnumConstantDeclaration) {
                    EnumConstantDeclaration ec = (EnumConstantDeclaration)md;
                    EnumConstantSpecification ecs = ec.getEnumConstantSpecification();
                    ASTArrayList<DeclarationSpecifier> dsml = new ASTArrayList<DeclarationSpecifier>();
                    if (ec.getAnnotations() == null) {
                        for (AnnotationUseSpecification a : ec.getAnnotations()) {
                            dsml.add(a.deepClone());
                        }
                    }
                    dsml.add(f.createFinal());
                    dsml.add(f.createPublic());
                    dsml.add(f.createStatic());
                    FieldDeclaration fd = f.createFieldDeclaration(dsml, f.createTypeReference(this.ed.getIdentifier().deepClone()), ecs.getIdentifier().deepClone(), null);
                    FieldSpecification fs = (FieldSpecification)fd.getFieldSpecifications().get(0);
                    List<FieldReference> frl = this.getCrossReferenceSourceInfo().getReferences(ecs);
                    for (int j = 0; j < frl.size(); ++j) {
                        FieldReference fr = frl.get(j);
                        if (!(fr.getASTParent() instanceof Case)) continue;
                        Switch sw = (Switch)fr.getASTParent().getASTParent();
                        this.switchStmnts.add(sw);
                        String fallThroughName = VariableKit.createValidVariableName(this.getSourceInfo(), sw, "fallThrough");
                        String doneAnyName = VariableKit.createValidVariableName(this.getSourceInfo(), sw, "doneAny");
                        this.names.put(sw, new String[]{fallThroughName, doneAnyName});
                    }
                    New e = f.createNew();
                    e.setTypeReference(f.createTypeReference(this.repl.getIdentifier()));
                    if (ecs.getConstructorReference().getArguments() != null || ecs.getConstructorReference().getClassDeclaration() != null) {
                        ASTList<Expression> ecsargs = ecs.getConstructorReference().getArguments();
                        int s = ecsargs == null ? 0 : ecsargs.size();
                        ASTArrayList<int> args = new ASTArrayList<int>(s);
                        e.setArguments(args);
                        for (int j = 0; j < s; ++j) {
                            args.add((int)((Expression)ecsargs.get(j)).deepClone());
                        }
                        if (ecs.getConstructorReference().getClassDeclaration() != null) {
                            e.setClassDeclaration(ecs.getConstructorReference().getClassDeclaration().deepClone());
                        }
                    }
                    fs.setInitializer(e);
                    e.makeParentRoleValid();
                    fs.makeParentRoleValid();
                    fd.makeParentRoleValid();
                    enumSpecRepl.add(fs);
                    mlist.add((int)fd);
                    continue;
                }
                mlist.add((int)((MemberDeclaration)md.deepClone()));
            }
            MethodDeclaration values = f.createMethodDeclaration();
            MethodDeclaration valueOf = f.createMethodDeclaration();
            MethodDeclaration ordinal = f.createMethodDeclaration();
            values.setIdentifier(f.createIdentifier("values"));
            valueOf.setIdentifier(f.createIdentifier("valueOf"));
            ordinal.setIdentifier(f.createIdentifier("ordinal"));
            ASTList<DeclarationSpecifier> declSpecs = new ASTArrayList<DeclarationSpecifier>();
            ((ArrayList)((Object)declSpecs)).add(f.createPublic());
            ((ArrayList)((Object)declSpecs)).add(f.createStatic());
            values.setDeclarationSpecifiers(declSpecs);
            declSpecs = ((ASTArrayList)declSpecs).deepClone();
            valueOf.setDeclarationSpecifiers(declSpecs);
            declSpecs = ((ASTArrayList)declSpecs).deepClone();
            ((ArrayList)((Object)declSpecs)).remove(1);
            ((ArrayList)((Object)declSpecs)).add(f.createFinal());
            ordinal.setDeclarationSpecifiers(declSpecs);
            values.setTypeReference(f.createTypeReference(this.repl.getIdentifier().deepClone(), 1));
            valueOf.setTypeReference(f.createTypeReference(this.repl.getIdentifier().deepClone()));
            ordinal.setTypeReference(f.createTypeReference(f.createIdentifier("int")));
            valueOf.setParameters(new ASTArrayList<ParameterDeclaration>(f.createParameterDeclaration(TypeKit.createTypeReference(f, "String"), f.createIdentifier("name"))));
            StatementBlock valuesSt = f.createStatementBlock();
            StatementBlock valueOfSt = f.createStatementBlock();
            StatementBlock ordinalSt = f.createStatementBlock();
            values.setBody(valuesSt);
            valueOf.setBody(valueOfSt);
            ordinal.setBody(ordinalSt);
            ordinalSt.setBody(new ASTArrayList<Statement>(f.createReturn(f.createFieldReference(f.createIdentifier("ordinal")))));
            NewArray na = f.createNewArray();
            na.setTypeReference(f.createTypeReference(this.repl.getIdentifier().deepClone(), 1));
            na.setArrayInitializer(f.createArrayInitializer(new ASTArrayList<int>(enumSpecRepl.size())));
            na.makeParentRoleValid();
            valuesSt.setBody(new ASTArrayList<Statement>(f.createReturn(na)));
            If ite = f.createIf();
            valueOfSt.setBody(new ASTArrayList<Statement>(ite));
            for (int i = 0; i < enumSpecRepl.size(); ++i) {
                FieldSpecification fs = (FieldSpecification)enumSpecRepl.get(i);
                na.getArrayInitializer().getArguments().add(f.createFieldReference(fs.getIdentifier().deepClone()));
                ite.setExpression(f.createMethodReference(f.createVariableReference(f.createIdentifier("name")), f.createIdentifier("equals"), new ASTArrayList<Expression>(f.createStringLiteral("\"" + fs.getName() + "\""))));
                ite.setThen(f.createThen(f.createReturn(f.createFieldReference(fs.getIdentifier().deepClone()))));
                if (i + 1 < enumSpecRepl.size()) {
                    ite.setElse(f.createElse(f.createIf()));
                    ite.makeParentRoleValid();
                    ite = (If)ite.getElse().getStatementAt(0);
                    continue;
                }
                ite.makeParentRoleValid();
            }
            na.getArrayInitializer().makeParentRoleValid();
            ite.setElse(f.createElse(f.createThrow(f.createNew(null, f.createTypeReference(f.createIdentifier("IllegalArgumentException")), null))));
            ite.makeParentRoleValid();
            valuesSt.makeParentRoleValid();
            valueOfSt.makeParentRoleValid();
            ordinalSt.makeParentRoleValid();
            valueOf.makeParentRoleValid();
            values.makeParentRoleValid();
            ordinal.makeParentRoleValid();
            mlist.add((int)valueOf);
            mlist.add((int)values);
            mlist.add((int)ordinal);
            declSpecs = new ASTArrayList<int>(2);
            ((ArrayList)((Object)declSpecs)).add(f.createPrivate());
            ((ArrayList)((Object)declSpecs)).add(f.createStatic());
            mlist.add((int)f.createFieldDeclaration(declSpecs, f.createTypeReference(f.createIdentifier("int")), f.createIdentifier("CURRENT_ORDINAL"), f.createIntLiteral("0")));
            declSpecs = new ASTArrayList<int>(2);
            ((ArrayList)((Object)declSpecs)).add(f.createPrivate());
            ((ArrayList)((Object)declSpecs)).add(f.createFinal());
            mlist.add((int)f.createFieldDeclaration(declSpecs, f.createTypeReference(f.createIdentifier("int")), f.createIdentifier("ordinal"), f.createPostIncrement(f.createFieldReference(f.createIdentifier("CURRENT_ORDINAL")))));
            this.repl.makeParentRoleValid();
            MiscKit.unindent(this.repl);
            return super.analyze();
        }

        @Override
        public void transform() {
            super.transform();
            this.replace(this.ed, this.repl);
            for (Switch sw : this.switchStmnts) {
                ProgramFactory f = this.getProgramFactory();
                ASTArrayList<Statement> sml = new ASTArrayList<Statement>();
                StatementBlock sb = f.createStatementBlock(sml);
                String[] nm = this.names.get(sw);
                String fallThroughName = nm[0];
                String doneAnyName = nm[1];
                sml.add(f.createLocalVariableDeclaration(null, f.createTypeReference(f.createIdentifier("boolean")), f.createIdentifier(fallThroughName), f.createBooleanLiteral(false)));
                sml.add(f.createLocalVariableDeclaration(null, f.createTypeReference(f.createIdentifier("boolean")), f.createIdentifier(doneAnyName), f.createBooleanLiteral(false)));
                Do repl = f.createDo(f.createBooleanLiteral(false), sb);
                for (int i = 0; i < sw.getBranchCount(); ++i) {
                    If newIf;
                    Then then;
                    Branch b = sw.getBranchAt(i);
                    if (b instanceof Default) {
                        if (i != sw.getBranchCount() - 1) {
                            throw new ModelException("case after default is illegal");
                        }
                        Default d = (Default)b;
                        ASTArrayList<Statement> defaultStmnt = new ASTArrayList<Statement>();
                        StatementBlock sb2 = f.createStatementBlock(defaultStmnt);
                        LogicalOr cond = f.createLogicalOr(f.createVariableReference(f.createIdentifier(doneAnyName)), f.createVariableReference(f.createIdentifier(fallThroughName)));
                        defaultStmnt.addAll(d.getBody().deepClone());
                        sb2.makeParentRoleValid();
                        then = f.createThen(sb2);
                        newIf = f.createIf((Expression)cond, then);
                        sml.add(newIf);
                        continue;
                    }
                    Case c = (Case)b;
                    LogicalOr cond = f.createLogicalOr(f.createVariableReference(f.createIdentifier(fallThroughName)), f.createEquals(f.createFieldReference(TypeKit.createTypeReference(f, this.ed.getFullName()), f.createIdentifier(((FieldReference)c.getExpression()).getName())), sw.getExpression().deepClone()));
                    ASTArrayList<Statement> thenStmnt = new ASTArrayList<Statement>();
                    StatementBlock sb2 = f.createStatementBlock(thenStmnt);
                    thenStmnt.add(f.createCopyAssignment(f.createVariableReference(f.createIdentifier(doneAnyName)), f.createBooleanLiteral(true)));
                    thenStmnt.add(f.createCopyAssignment(f.createVariableReference(f.createIdentifier(fallThroughName)), f.createBooleanLiteral(false)));
                    thenStmnt.addAll(c.getBody().deepClone());
                    if (c.getBody().size() == 0 || !(c.getBody().get(c.getBody().size() - 1) instanceof JumpStatement)) {
                        thenStmnt.add(f.createCopyAssignment(f.createVariableReference(f.createIdentifier(fallThroughName)), f.createBooleanLiteral(true)));
                    }
                    sb2.makeParentRoleValid();
                    then = f.createThen(sb2);
                    newIf = f.createIf((Expression)cond, then);
                    sml.add(newIf);
                }
                sb.makeParentRoleValid();
                MiscKit.unindent(repl);
                this.replace(sw, repl);
            }
        }
    }
}

